/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.dom.Element;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;

public class Html
extends Component {
    private static final PropertyDescriptor<String, String> innerHtmlDescriptor = PropertyDescriptors.propertyWithDefault("innerHTML", "");

    public Html(InputStream stream) {
        super(null);
        if (stream == null) {
            throw new IllegalArgumentException("HTML stream cannot be null");
        }
        try {
            this.setOuterHtml(Jsoup.parse((InputStream)stream, (String)StandardCharsets.UTF_8.name(), (String)""));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read HTML from stream", e);
        }
    }

    public Html(String outerHtml) {
        super(null);
        if (outerHtml == null || outerHtml.isEmpty()) {
            throw new IllegalArgumentException("HTML cannot be null or empty");
        }
        this.setOuterHtml(Jsoup.parse((String)outerHtml));
    }

    private void setOuterHtml(Document doc) {
        int nrChildren = doc.body().children().size();
        if (nrChildren != 1) {
            String message = "HTML must contain exactly one top level element (ignoring text nodes). Found " + nrChildren;
            if (nrChildren > 1) {
                String tagNames = doc.body().children().stream().map(org.jsoup.nodes.Element::tagName).collect(Collectors.joining(", "));
                message = message + " elements with the tag names " + tagNames;
            }
            throw new IllegalArgumentException(message);
        }
        org.jsoup.nodes.Element root = doc.body().child(0);
        Attributes attrs = root.attributes();
        Component.setElement(this, new Element(root.tagName()));
        attrs.forEach(a -> {
            String name = a.getKey();
            String value = a.getValue();
            this.getElement().setAttribute(name, value);
        });
        doc.outputSettings().prettyPrint(false);
        this.setInnerHtml(root.html());
    }

    private void setInnerHtml(String innerHtml) {
        this.set(innerHtmlDescriptor, innerHtml);
    }

    public String getInnerHtml() {
        return this.get(innerHtmlDescriptor);
    }
}

