/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.client;

import com.vaadin.flow.client.ClientResources;
import com.vaadin.flow.client.DefaultClientResources;
import java.io.InputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public final class ClientResourcesUtils {
    private static final ClientResources SERVICE = ClientResourcesUtils.loadService();

    private ClientResourcesUtils() {
    }

    public static InputStream getResource(String path) {
        return SERVICE.getResource(path);
    }

    private static ClientResources loadService() {
        try {
            Class.forName("org.osgi.framework.FrameworkUtil");
            Bundle bundle = FrameworkUtil.getBundle(ClientResources.class);
            if (bundle == null) {
                return ClientResourcesUtils.getDefaultService(null);
            }
            BundleContext context = bundle.getBundleContext();
            ServiceReference reference = context.getServiceReference(ClientResources.class);
            if (reference == null) {
                return ClientResourcesUtils.getDefaultService(null);
            }
            LoggerFactory.getLogger(ClientResourcesUtils.class).trace("OSGi environment is detected. Load client resources using OSGi service");
            return (ClientResources)context.getService(reference);
        }
        catch (ClassNotFoundException exception) {
            return ClientResourcesUtils.getDefaultService(exception);
        }
    }

    private static ClientResources getDefaultService(ClassNotFoundException exception) {
        LoggerFactory.getLogger(ClientResourcesUtils.class).trace("Using standard Java way to access to the client resources", (Throwable)exception);
        return new DefaultClientResources();
    }
}

