/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.startup.AbstractRouteRegistryInitializer;
import com.vaadin.flow.server.startup.RouteRegistry;
import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={Route.class, RouteAlias.class})
public class RouteRegistryInitializer
extends AbstractRouteRegistryInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> classSet, ServletContext servletContext) throws ServletException {
        try {
            if (classSet == null) {
                RouteRegistry.getInstance(servletContext).setNavigationTargets(Collections.emptySet());
                return;
            }
            Set<Class<? extends Component>> routes = this.validateRouteClasses(classSet.stream());
            RouteRegistry routeRegistry = RouteRegistry.getInstance(servletContext);
            routeRegistry.setNavigationTargets(routes);
            routeRegistry.setPwaConfigurationClass(this.validatePwaClass(routes.stream().map(clazz -> clazz)));
        }
        catch (InvalidRouteConfigurationException irce) {
            throw new ServletException("Exception while registering Routes on servlet startup", (Throwable)irce);
        }
    }
}

