/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.AbstractDeploymentConfiguration;
import com.vaadin.flow.shared.communication.PushMode;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeploymentConfiguration
extends AbstractDeploymentConfiguration {
    private static final String SEPARATOR = "\n===========================================================";
    public static final String NOT_PRODUCTION_MODE_INFO = "\n===========================================================\nVaadin is running in DEBUG MODE.\nAdd productionMode=true to web.xml to disable debug features.\n===========================================================";
    public static final String WARNING_XSRF_PROTECTION_DISABLED = "\n===========================================================\nWARNING: Cross-site request forgery protection is disabled!\n===========================================================";
    public static final String WARNING_HEARTBEAT_INTERVAL_NOT_NUMERIC = "\n===========================================================\nWARNING: heartbeatInterval has been set to a non integer value in web.xml. The default of 5min will be used.\n===========================================================";
    public static final String WARNING_PUSH_MODE_NOT_RECOGNIZED = "\n===========================================================\nWARNING: pushMode has been set to an unrecognized value\nin web.xml. The permitted values are \"disabled\", \"manual\",\nand \"automatic\". The default of \"disabled\" will be used.\n===========================================================";
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 300;
    public static final boolean DEFAULT_CLOSE_IDLE_SESSIONS = false;
    public static final boolean DEFAULT_SYNC_ID_CHECK = true;
    public static final boolean DEFAULT_SEND_URLS_AS_PARAMETERS = true;
    private final Properties initParameters;
    private boolean productionMode;
    private boolean xsrfProtectionEnabled;
    private int heartbeatInterval;
    private boolean closeIdleSessions;
    private PushMode pushMode;
    private String pushURL;
    private final Class<?> systemPropertyBaseClass;
    private boolean syncIdCheck;
    private boolean sendUrlsAsParameters;
    private boolean requestTiming;

    public DefaultDeploymentConfiguration(Class<?> systemPropertyBaseClass, Properties initParameters) {
        this.initParameters = initParameters;
        this.systemPropertyBaseClass = systemPropertyBaseClass;
        this.checkProductionMode();
        this.checkRequestTiming();
        this.checkXsrfProtection();
        this.checkHeartbeatInterval();
        this.checkCloseIdleSessions();
        this.checkPushMode();
        this.checkPushURL();
        this.checkSyncIdCheck();
        this.checkSendUrlsAsParameters();
    }

    @Override
    public <T> T getApplicationOrSystemProperty(String propertyName, T defaultValue, Function<String, T> converter) {
        String val = this.getSystemProperty(propertyName);
        if (val != null) {
            return converter.apply(val);
        }
        val = this.getApplicationProperty(propertyName);
        if (val != null) {
            return converter.apply(val);
        }
        return defaultValue;
    }

    protected String getSystemProperty(String parameterName) {
        String className;
        int index;
        Package pkg = this.systemPropertyBaseClass.getPackage();
        String pkgName = pkg != null ? pkg.getName() : ((index = (className = this.systemPropertyBaseClass.getName()).lastIndexOf(46)) >= 0 ? className.substring(0, index) : null);
        if (pkgName == null) {
            pkgName = "";
        } else if (!pkgName.isEmpty()) {
            pkgName = pkgName + '.';
        }
        String val = System.getProperty(pkgName + parameterName);
        if (val != null) {
            return val;
        }
        val = System.getProperty(pkgName + parameterName.toLowerCase(Locale.ENGLISH));
        if (val != null) {
            return val;
        }
        val = System.getProperty("vaadin." + parameterName);
        return val;
    }

    public String getApplicationProperty(String parameterName) {
        String val = this.initParameters.getProperty(parameterName);
        if (val != null) {
            return val;
        }
        val = this.initParameters.getProperty(parameterName.toLowerCase());
        return val;
    }

    @Override
    public boolean isProductionMode() {
        return this.productionMode;
    }

    @Override
    public boolean isRequestTiming() {
        return this.requestTiming;
    }

    @Override
    public boolean isXsrfProtectionEnabled() {
        return this.xsrfProtectionEnabled;
    }

    @Override
    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public boolean isCloseIdleSessions() {
        return this.closeIdleSessions;
    }

    @Override
    public boolean isSyncIdCheckEnabled() {
        return this.syncIdCheck;
    }

    @Override
    public boolean isSendUrlsAsParameters() {
        return this.sendUrlsAsParameters;
    }

    @Override
    public PushMode getPushMode() {
        return this.pushMode;
    }

    @Override
    public String getPushURL() {
        return this.pushURL;
    }

    @Override
    public Properties getInitParameters() {
        return this.initParameters;
    }

    private void checkProductionMode() {
        this.productionMode = this.getBooleanProperty("productionMode", false);
        if (!this.productionMode) {
            this.getLogger().warn(NOT_PRODUCTION_MODE_INFO);
        }
    }

    private void checkRequestTiming() {
        this.requestTiming = this.getBooleanProperty("requestTiming", !this.productionMode);
    }

    private void checkXsrfProtection() {
        boolean bl = this.xsrfProtectionEnabled = !this.getBooleanProperty("disable-xsrf-protection", false);
        if (!this.xsrfProtectionEnabled) {
            this.getLogger().warn(WARNING_XSRF_PROTECTION_DISABLED);
        }
    }

    private void checkHeartbeatInterval() {
        try {
            this.heartbeatInterval = this.getApplicationOrSystemProperty("heartbeatInterval", 300, Integer::parseInt);
        }
        catch (NumberFormatException e) {
            this.getLogger().warn(WARNING_HEARTBEAT_INTERVAL_NOT_NUMERIC);
            this.heartbeatInterval = 300;
        }
    }

    private void checkCloseIdleSessions() {
        this.closeIdleSessions = this.getBooleanProperty("closeIdleSessions", false);
    }

    private void checkPushMode() {
        try {
            this.pushMode = this.getApplicationOrSystemProperty("pushMode", PushMode.DISABLED, stringMode -> Enum.valueOf(PushMode.class, stringMode.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn(WARNING_PUSH_MODE_NOT_RECOGNIZED);
            this.pushMode = PushMode.DISABLED;
        }
    }

    private void checkPushURL() {
        this.pushURL = this.getStringProperty("pushURL", "");
    }

    private void checkSyncIdCheck() {
        this.syncIdCheck = this.getBooleanProperty("syncIdCheck", true);
    }

    private void checkSendUrlsAsParameters() {
        this.sendUrlsAsParameters = this.getBooleanProperty("sendUrlsAsParameters", true);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

