/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.impl.AbstractNodeStateProvider;
import com.vaadin.flow.dom.impl.ShadowRootStateProvider;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.PolymerEventListenerMap;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.internal.nodefeature.ShadowRootData;
import com.vaadin.flow.internal.nodefeature.SynchronizedPropertiesList;
import com.vaadin.flow.internal.nodefeature.SynchronizedPropertyEventsList;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;

public class BasicElementStateProvider
extends AbstractNodeStateProvider {
    private static BasicElementStateProvider instance = new BasicElementStateProvider();
    private static Class<? extends NodeFeature>[] features = new Class[]{ElementData.class, ElementAttributeMap.class, ElementChildrenList.class, ElementPropertyMap.class, ElementListenerMap.class, ElementClassList.class, ElementStylePropertyMap.class, SynchronizedPropertiesList.class, SynchronizedPropertyEventsList.class, ComponentMapping.class, PolymerServerEventHandlers.class, ClientCallableHandlers.class, PolymerEventListenerMap.class, ShadowRootData.class, AttachExistingElementFeature.class, VirtualChildrenList.class};

    private BasicElementStateProvider() {
    }

    public static BasicElementStateProvider get() {
        return instance;
    }

    public static StateNode createStateNode(String tag) {
        assert (ElementUtil.isValidTagName(tag)) : "Invalid tag name " + tag;
        StateNode node = new StateNode(Collections.singletonList(ElementData.class), features);
        node.getFeature(ElementData.class).setTag(tag);
        return node;
    }

    @Override
    public boolean supports(StateNode node) {
        if (!super.supports(node)) {
            return false;
        }
        return node.getFeature(ElementData.class).getTag() != null;
    }

    @Override
    public String getTag(StateNode node) {
        return BasicElementStateProvider.getDataFeature(node).getTag();
    }

    private static ElementData getDataFeature(StateNode node) {
        return node.getFeature(ElementData.class);
    }

    private static ElementAttributeMap getAttributeFeature(StateNode node) {
        return node.getFeature(ElementAttributeMap.class);
    }

    private static ElementPropertyMap getPropertyFeature(StateNode node) {
        return node.getFeature(ElementPropertyMap.class);
    }

    @Override
    public void setAttribute(StateNode node, String attribute, String value) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        BasicElementStateProvider.getAttributeFeature(node).set(attribute, value);
    }

    @Override
    public String getAttribute(StateNode node, String attribute) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        return BasicElementStateProvider.getAttributeFeature(node).get(attribute);
    }

    @Override
    public boolean hasAttribute(StateNode node, String attribute) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        return BasicElementStateProvider.getAttributeFeature(node).has(attribute);
    }

    @Override
    public void removeAttribute(StateNode node, String attribute) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        BasicElementStateProvider.getAttributeFeature(node).remove(attribute);
    }

    @Override
    public Stream<String> getAttributeNames(StateNode node) {
        return BasicElementStateProvider.getAttributeFeature(node).attributes();
    }

    @Override
    public Node getParent(StateNode node) {
        StateNode parentNode = node.getParent();
        if (parentNode == null) {
            return null;
        }
        return super.getParent(node);
    }

    @Override
    public DomListenerRegistration addEventListener(StateNode node, String eventType, DomEventListener listener) {
        ElementListenerMap listeners = node.getFeature(ElementListenerMap.class);
        return listeners.add(eventType, listener);
    }

    public static Collection<Class<? extends NodeFeature>> getFeatures() {
        return Collections.unmodifiableCollection(Arrays.asList(BasicElementStateProvider.get().getProviderFeatures()));
    }

    @Override
    public Serializable getProperty(StateNode node, String name) {
        assert (node != null);
        assert (name != null);
        return BasicElementStateProvider.getPropertyFeature(node).getProperty(name);
    }

    @Override
    public void setProperty(StateNode node, String name, Serializable value, boolean emitChange) {
        assert (node != null);
        assert (name != null);
        BasicElementStateProvider.getPropertyFeature(node).setProperty(name, value, emitChange);
    }

    @Override
    public void removeProperty(StateNode node, String name) {
        assert (node != null);
        assert (name != null);
        BasicElementStateProvider.getPropertyFeature(node).removeProperty(name);
    }

    @Override
    public boolean hasProperty(StateNode node, String name) {
        assert (node != null);
        assert (name != null);
        return BasicElementStateProvider.getPropertyFeature(node).hasProperty(name);
    }

    @Override
    public Stream<String> getPropertyNames(StateNode node) {
        assert (node != null);
        return BasicElementStateProvider.getPropertyFeature(node).getPropertyNames();
    }

    @Override
    public boolean isTextNode(StateNode node) {
        return false;
    }

    @Override
    public String getTextContent(StateNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTextContent(StateNode node, String textContent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassList getClassList(StateNode node) {
        return node.getFeature(ElementClassList.class).getClassList();
    }

    @Override
    public Style getStyle(StateNode node) {
        return node.getFeature(ElementStylePropertyMap.class).getStyle();
    }

    @Override
    public Set<String> getSynchronizedProperties(StateNode node) {
        return node.getFeature(SynchronizedPropertiesList.class).getSynchronizedProperties();
    }

    @Override
    public Set<String> getSynchronizedPropertyEvents(StateNode node) {
        return node.getFeature(SynchronizedPropertyEventsList.class).getSynchronizedPropertyEvents();
    }

    @Override
    public void setAttribute(StateNode node, String attribute, AbstractStreamResource receiver) {
        assert (node != null);
        assert (attribute != null);
        assert (receiver != null);
        BasicElementStateProvider.getAttributeFeature(node).setResource(attribute, receiver);
    }

    @Override
    public Registration addPropertyChangeListener(StateNode node, String name, PropertyChangeListener listener) {
        return BasicElementStateProvider.getPropertyFeature(node).addPropertyChangeListener(name, listener);
    }

    @Override
    public StateNode getShadowRoot(StateNode node) {
        return node.getFeature(ShadowRootData.class).getShadowRoot();
    }

    @Override
    public StateNode attachShadow(StateNode node) {
        assert (this.getShadowRoot(node) == null);
        return ShadowRootStateProvider.get().createShadowRootNode(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(StateNode node, NodeVisitor visitor) {
        boolean visitDescendants;
        Element element = Element.get(node);
        ElementData data = node.getFeature(ElementData.class);
        JsonValue payload = data.getPayload();
        if (payload instanceof JsonObject) {
            JsonObject object = (JsonObject)payload;
            String type = object.getString("type");
            if ("inMemory".equals(type)) {
                visitDescendants = visitor.visit(NodeVisitor.ElementType.VIRTUAL, element);
            } else {
                if (!"@id".equals(type) && !"subTemplate".equals(type)) throw new IllegalStateException("Unexpected payload type : " + type);
                visitDescendants = visitor.visit(NodeVisitor.ElementType.VIRTUAL_ATTACHED, element);
            }
        } else {
            if (payload != null) throw new IllegalStateException("Unexpected payload in element data : " + payload.toJson());
            visitDescendants = visitor.visit(NodeVisitor.ElementType.REGULAR, element);
        }
        if (!visitDescendants) return;
        this.visitDescendants(element, visitor);
        element.getShadowRoot().ifPresent(root -> {
            ShadowRoot cfr_ignored_0 = (ShadowRoot)root.accept(visitor);
        });
    }

    @Override
    public void setVisible(StateNode node, boolean visible) {
        assert (node.hasFeature(ElementData.class));
        node.getFeature(ElementData.class).setVisible(visible);
    }

    @Override
    public boolean isVisible(StateNode node) {
        assert (node.hasFeature(ElementData.class));
        return node.getFeature(ElementData.class).isVisible();
    }

    @Override
    public void addSynchronizedProperty(StateNode node, String property, DisabledUpdateMode mode) {
        node.getFeature(SynchronizedPropertiesList.class).add(property, mode);
    }

    @Override
    protected Node<?> getNode(StateNode node) {
        assert (this.supports(node));
        return Element.get(node);
    }

    @Override
    protected Class<? extends NodeFeature>[] getProviderFeatures() {
        return features;
    }
}

