/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.dom.ChildElementConsumer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementStateProvider;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class Node<N extends Node<N>>
implements Serializable {
    static final String CANNOT_X_WITH_INDEX_Y_WHEN_THERE_ARE_Z_CHILDREN = "Cannot %s element with index %d when there are %d children";
    static final String THE_CHILDREN_ARRAY_CANNOT_BE_NULL = "The children array cannot be null";
    private final ElementStateProvider stateProvider;
    private final StateNode node;

    protected Node(StateNode node, ElementStateProvider stateProvider) {
        assert (node != null);
        assert (stateProvider != null);
        if (!stateProvider.supports(node)) {
            throw new IllegalArgumentException(stateProvider.getClass().getSimpleName() + " does not support the given state node");
        }
        this.stateProvider = stateProvider;
        this.node = node;
    }

    public StateNode getNode() {
        return this.node;
    }

    public ElementStateProvider getStateProvider() {
        return this.stateProvider;
    }

    public int getChildCount() {
        return this.getStateProvider().getChildCount(this.getNode());
    }

    public Element getChild(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            throw new IllegalArgumentException(String.format(CANNOT_X_WITH_INDEX_Y_WHEN_THERE_ARE_Z_CHILDREN, "get", index, this.getChildCount()));
        }
        return this.getStateProvider().getChild(this.getNode(), index);
    }

    public Stream<Element> getChildren() {
        return IntStream.range(0, this.getChildCount()).mapToObj(this::getChild);
    }

    public N appendChild(Element ... children) {
        if (children == null) {
            throw new IllegalArgumentException(THE_CHILDREN_ARRAY_CANNOT_BE_NULL);
        }
        this.insertChild(this.getChildCount(), children);
        return this.getSelf();
    }

    public N appendVirtualChild(Element ... children) {
        if (children == null) {
            throw new IllegalArgumentException(THE_CHILDREN_ARRAY_CANNOT_BE_NULL);
        }
        for (Element child : children) {
            if (child == null) {
                throw new IllegalArgumentException("Element to insert must not be null");
            }
            Node parentNode = child.getParentNode();
            if (parentNode != null) {
                throw new IllegalArgumentException("Element to insert already has a parent and can't be added as a virtual child");
            }
            this.getStateProvider().appendVirtualChild(this.getNode(), child, "inMemory", null);
            this.ensureChildHasParent(child, true);
        }
        return this.getSelf();
    }

    public boolean isVirtualChild() {
        Node parentNode = this.getParentNode();
        if (parentNode == null) {
            return false;
        }
        if (!parentNode.getNode().hasFeature(VirtualChildrenList.class)) {
            return false;
        }
        Iterator<StateNode> iterator = parentNode.getNode().getFeature(VirtualChildrenList.class).iterator();
        while (iterator.hasNext()) {
            StateNode child = iterator.next();
            if (!this.getNode().equals(child)) continue;
            return true;
        }
        return false;
    }

    public N insertChild(int index, Element ... children) {
        if (children == null) {
            throw new IllegalArgumentException(THE_CHILDREN_ARRAY_CANNOT_BE_NULL);
        }
        if (index > this.getChildCount()) {
            throw new IllegalArgumentException(String.format(CANNOT_X_WITH_INDEX_Y_WHEN_THERE_ARE_Z_CHILDREN, "insert", index, this.getChildCount()));
        }
        int i = 0;
        int insertIndex = index;
        while (i < children.length) {
            block9: {
                Element child;
                block8: {
                    child = children[i];
                    if (child == null) {
                        throw new IllegalArgumentException("Element to insert must not be null");
                    }
                    if (!this.equals(child.getParentNode())) break block8;
                    int childIndex = this.indexOfChild(child);
                    if (childIndex == insertIndex) break block9;
                    if (childIndex < insertIndex) {
                        --insertIndex;
                    }
                }
                child.removeFromParent();
                this.getStateProvider().insertChild(this.node, insertIndex, child);
                this.ensureChildHasParent(child, true);
            }
            ++i;
            ++insertIndex;
        }
        return this.getSelf();
    }

    public int indexOfChild(Element child) {
        if (child == null) {
            throw new IllegalArgumentException("Child parameter cannot be null");
        }
        if (!this.equals(child.getParentNode())) {
            return -1;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element = this.getChild(i);
            if (!element.equals(child)) continue;
            return i;
        }
        return -1;
    }

    public N setChild(int index, Element child) {
        if (child == null) {
            throw new IllegalArgumentException("The child cannot be null");
        }
        int childCount = this.getChildCount();
        if (index < 0) {
            throw new IllegalArgumentException(String.format(CANNOT_X_WITH_INDEX_Y_WHEN_THERE_ARE_Z_CHILDREN, "set", index, this.getChildCount()));
        }
        if (index < childCount) {
            if (this.getChild(index).equals(child)) {
                return this.getSelf();
            }
            this.removeChild(index);
            this.insertChild(index, child);
        } else if (index == childCount) {
            this.insertChild(index, child);
        } else {
            throw new IllegalArgumentException(String.format(CANNOT_X_WITH_INDEX_Y_WHEN_THERE_ARE_Z_CHILDREN, "set", index, this.getChildCount()));
        }
        return this.getSelf();
    }

    public N removeChild(Element ... children) {
        if (children == null) {
            throw new IllegalArgumentException(THE_CHILDREN_ARRAY_CANNOT_BE_NULL);
        }
        for (Element child : children) {
            this.ensureChildHasParent(child, false);
            this.getStateProvider().removeChild(this.getNode(), child);
        }
        return this.getSelf();
    }

    public N removeChild(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            throw new IllegalArgumentException(String.format(CANNOT_X_WITH_INDEX_Y_WHEN_THERE_ARE_Z_CHILDREN, "remove", index, this.getChildCount()));
        }
        this.getStateProvider().removeChild(this.getNode(), index);
        return this.getSelf();
    }

    public N removeAllChildren() {
        this.getStateProvider().removeAllChildren(this.getNode());
        return this.getSelf();
    }

    public Node getParentNode() {
        return this.getStateProvider().getParent(this.getNode());
    }

    protected abstract N getSelf();

    public int hashCode() {
        return Objects.hash(this.getNode(), this.getStateProvider());
    }

    public N accept(NodeVisitor visitor) {
        this.getStateProvider().visit(this.getNode(), visitor);
        return this.getSelf();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return other.getNode().equals(this.getNode()) && other.getStateProvider().equals(this.getStateProvider());
    }

    protected void ensureChildHasParent(Element child, boolean internalCheck) {
        if (!Objects.equals(this, child.getParentNode())) {
            if (internalCheck) {
                assert (false) : "Child should have this element as a parent";
            } else {
                throw new IllegalArgumentException("Child should have this element as a parent");
            }
        }
    }

    private N attachExistingElement(String tagName, Element previousSibling, ChildElementConsumer callback) {
        this.getStateProvider().attachExistingElement(this.getNode(), tagName, previousSibling, callback);
        return this.getSelf();
    }
}

