/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class RouterUtil {
    private RouterUtil() {
    }

    public static List<Class<? extends RouterLayout>> getParentLayouts(Class<?> component) {
        Optional<Route> route = AnnotationReader.getAnnotationFor(component, Route.class);
        if (route.isPresent() && !route.get().layout().equals(UI.class)) {
            return RouterUtil.collectRouteParentLayouts(route.get().layout());
        }
        return Collections.emptyList();
    }

    public static List<Class<? extends RouterLayout>> getParentLayouts(Class<?> component, String path) {
        ArrayList<Class<? extends RouterLayout>> list = new ArrayList<Class<? extends RouterLayout>>();
        Optional<Route> route = AnnotationReader.getAnnotationFor(component, Route.class);
        List<RouteAlias> routeAliases = AnnotationReader.getAnnotationsFor(component, RouteAlias.class);
        if (route.isPresent() && path.equals(RouterUtil.getRoutePath(component, route.get())) && !route.get().layout().equals(UI.class)) {
            list.addAll(RouterUtil.collectRouteParentLayouts(route.get().layout()));
        } else {
            Optional<RouteAlias> matchingRoute = RouterUtil.getMatchingRouteAlias(component, path, routeAliases);
            if (matchingRoute.isPresent()) {
                list.addAll(RouterUtil.collectRouteParentLayouts(matchingRoute.get().layout()));
            }
        }
        return list;
    }

    public static String getRoutePath(Class<?> component, Route route) {
        if (route.absolute()) {
            return Router.resolve(component, route);
        }
        List<String> parentRoutePrefixes = RouterUtil.getRoutePrefixes(component, route.layout(), Router.resolve(component, route));
        return parentRoutePrefixes.stream().collect(Collectors.joining("/"));
    }

    public static String getRouteAliasPath(Class<?> component, RouteAlias alias) {
        if (alias.absolute()) {
            return alias.value();
        }
        List<String> parentRoutePrefixes = RouterUtil.getRoutePrefixes(component, alias.layout(), alias.value());
        return parentRoutePrefixes.stream().collect(Collectors.joining("/"));
    }

    private static List<String> getRoutePrefixes(Class<?> component, Class<? extends RouterLayout> layout, String value) {
        List<String> parentRoutePrefixes = RouterUtil.getParentRoutePrefixes(component, () -> layout);
        Collections.reverse(parentRoutePrefixes);
        if (value != null && !value.isEmpty()) {
            parentRoutePrefixes.add(value);
        }
        return parentRoutePrefixes;
    }

    private static List<String> getParentRoutePrefixes(Class<?> component, Supplier<Class<? extends RouterLayout>> routerLayoutSupplier) {
        ArrayList<String> list = new ArrayList<String>();
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(component, ParentLayout.class);
        Optional<RoutePrefix> routePrefix = AnnotationReader.getAnnotationFor(component, RoutePrefix.class);
        routePrefix.ifPresent(prefix -> list.add(prefix.value()));
        if (routePrefix.isPresent() && routePrefix.get().absolute()) {
            return list;
        }
        Class<? extends RouterLayout> routerLayout = routerLayoutSupplier.get();
        if (routerLayout != null && !routerLayout.equals(UI.class)) {
            list.addAll(RouterUtil.getParentRoutePrefixes(routerLayout, () -> null));
        } else if (parentLayout.isPresent()) {
            list.addAll(RouterUtil.getParentRoutePrefixes(parentLayout.get().value(), () -> null));
        }
        return list;
    }

    private static Optional<RouteAlias> getMatchingRouteAlias(Class<?> component, String path, List<RouteAlias> routeAliases) {
        return routeAliases.stream().filter(alias -> path.equals(RouterUtil.getRouteAliasPath(component, alias)) && !alias.layout().equals(UI.class)).findFirst();
    }

    private static List<Class<? extends RouterLayout>> collectRouteParentLayouts(Class<? extends RouterLayout> layout) {
        ArrayList<Class<? extends RouterLayout>> layouts = new ArrayList<Class<? extends RouterLayout>>();
        layouts.add(layout);
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(layout, ParentLayout.class);
        if (parentLayout.isPresent()) {
            layouts.addAll(RouterUtil.collectRouteParentLayouts(parentLayout.get().value()));
        }
        return layouts;
    }

    public static List<Class<? extends RouterLayout>> getParentLayoutsForNonRouteTarget(Class<?> navigationTarget) {
        ArrayList<Class<? extends RouterLayout>> layouts = new ArrayList<Class<? extends RouterLayout>>();
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(navigationTarget, ParentLayout.class);
        if (parentLayout.isPresent()) {
            layouts.addAll(RouterUtil.collectRouteParentLayouts(parentLayout.get().value()));
        }
        return layouts;
    }

    public static Class<? extends RouterLayout> getTopParentLayout(Class<?> component, String path) {
        if (path == null) {
            Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(component, ParentLayout.class);
            if (parentLayout.isPresent()) {
                return RouterUtil.recuseToTopLayout(parentLayout.get().value());
            }
            return null;
        }
        Optional<Route> route = AnnotationReader.getAnnotationFor(component, Route.class);
        List<RouteAlias> routeAliases = AnnotationReader.getAnnotationsFor(component, RouteAlias.class);
        if (route.isPresent() && path.equals(RouterUtil.getRoutePath(component, route.get())) && !route.get().layout().equals(UI.class)) {
            return RouterUtil.recuseToTopLayout(route.get().layout());
        }
        Optional<RouteAlias> matchingRoute = RouterUtil.getMatchingRouteAlias(component, path, routeAliases);
        if (matchingRoute.isPresent()) {
            return RouterUtil.recuseToTopLayout(matchingRoute.get().layout());
        }
        return null;
    }

    private static Class<? extends RouterLayout> recuseToTopLayout(Class<? extends RouterLayout> layout) {
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(layout, ParentLayout.class);
        if (parentLayout.isPresent()) {
            return RouterUtil.recuseToTopLayout(parentLayout.get().value());
        }
        return layout;
    }

    public static void updatePageTitle(NavigationEvent navigationEvent, Component routeTarget) {
        String title = routeTarget instanceof HasDynamicTitle ? ((HasDynamicTitle)((Object)routeTarget)).getPageTitle() : RouterUtil.lookForTitleInTarget(routeTarget).map(PageTitle::value).orElse("");
        navigationEvent.getUI().getPage().setTitle(title);
    }

    private static Optional<PageTitle> lookForTitleInTarget(Component routeTarget) {
        return Optional.ofNullable(routeTarget.getClass().getAnnotation(PageTitle.class));
    }

    public static void checkForDuplicates(Class<? extends Component> routeTargetType, Collection<Class<? extends RouterLayout>> routeLayoutTypes) {
        HashSet<Class<HasElement>> duplicateCheck = new HashSet<Class<HasElement>>();
        duplicateCheck.add(routeTargetType);
        for (Class<? extends RouterLayout> parentType : routeLayoutTypes) {
            if (duplicateCheck.add(parentType)) continue;
            throw new IllegalArgumentException(parentType + " is used in multiple locations");
        }
    }

    public static LocationChangeEvent createEvent(NavigationEvent event, List<HasElement> routeTargetChain) {
        return new LocationChangeEvent(event.getSource(), event.getUI(), event.getTrigger(), event.getLocation(), routeTargetChain);
    }
}

