/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouterUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RouteData
implements Comparable<RouteData>,
Serializable {
    private final Class<? extends RouterLayout> parentLayout;
    private final String url;
    private final List<Class<?>> parameters;
    private final Class<? extends Component> navigationTarget;
    private final List<AliasData> routeAliases;

    public RouteData(Class<? extends RouterLayout> parentLayout, String url, List<Class<?>> parameters, Class<? extends Component> navigationTarget) {
        this.parentLayout = parentLayout;
        this.url = url;
        this.parameters = parameters;
        this.navigationTarget = navigationTarget;
        this.routeAliases = new ArrayList<AliasData>();
        AnnotationReader.getAnnotationsFor(navigationTarget, RouteAlias.class).forEach(alias -> this.routeAliases.add(new AliasData(alias.layout(), RouterUtil.getRouteAliasPath(navigationTarget, alias))));
        Collections.sort(this.routeAliases);
    }

    public Class<? extends RouterLayout> getParentLayout() {
        return this.parentLayout;
    }

    public String getUrl() {
        return this.url;
    }

    public List<Class<?>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget;
    }

    public List<AliasData> getRouteAliases() {
        return Collections.unmodifiableList(this.routeAliases);
    }

    @Override
    public int compareTo(RouteData otherRouteData) {
        return this.getUrl().compareToIgnoreCase(otherRouteData.getUrl());
    }

    public boolean equals(Object obj) {
        if (obj instanceof RouteData) {
            RouteData other = (RouteData)obj;
            return other.parentLayout.equals(this.parentLayout) && other.url.equals(this.url) && other.navigationTarget.equals(this.navigationTarget);
        }
        return false;
    }

    public static class AliasData
    implements Comparable<AliasData>,
    Serializable {
        private final Class<? extends RouterLayout> parentLayout;
        private final String url;

        public AliasData(Class<? extends RouterLayout> parentLayout, String url) {
            this.parentLayout = parentLayout;
            this.url = url;
        }

        public Class<? extends RouterLayout> getParentLayout() {
            return this.parentLayout;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public int compareTo(AliasData otherAlias) {
            return this.getUrl().compareToIgnoreCase(otherAlias.getUrl());
        }

        public boolean equals(Object obj) {
            if (obj instanceof AliasData) {
                AliasData other = (AliasData)obj;
                return other.parentLayout.equals(this.parentLayout) && other.url.equals(this.url);
            }
            return false;
        }
    }
}

