/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.startup.RouteRegistry;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ServletDeployer
implements ServletContextListener {
    private static final String SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE = "Skipping automatic servlet registration because";

    public void contextInitialized(ServletContextEvent sce) {
        if (!RouteRegistry.getInstance(sce.getServletContext()).hasNavigationTargets()) {
            ServletDeployer.getLogger().info("{} there are no navigation targets annotated with @Route", (Object)SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE);
            return;
        }
        ServletContext servletContext = sce.getServletContext();
        ServletRegistration rootServlet = ServletDeployer.findRootServlet(servletContext);
        if (rootServlet != null) {
            ServletDeployer.getLogger().info("{} there is already a /* servlet with the name {}", (Object)SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, (Object)rootServlet.getName());
            return;
        }
        ServletRegistration vaadinServlet = ServletDeployer.findVaadinServlet(servletContext);
        if (vaadinServlet != null) {
            ServletDeployer.getLogger().info("{} there is already a Vaadin servlet with the name {}", (Object)SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, (Object)vaadinServlet.getName());
            return;
        }
        String servletName = this.getClass().getName();
        ServletRegistration.Dynamic registration = servletContext.addServlet(servletName, VaadinServlet.class);
        if (registration == null) {
            ServletDeployer.getLogger().info("{} there is already a servlet with the name {}", (Object)SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, (Object)servletName);
            return;
        }
        ServletDeployer.getLogger().info("Automatically deploying Vaadin servlet to /*");
        registration.setAsyncSupported(true);
        registration.addMapping(new String[]{"/*"});
    }

    private static ServletRegistration findRootServlet(ServletContext context) {
        return context.getServletRegistrations().values().stream().filter(registration -> registration.getMappings().contains("/*")).findAny().orElse(null);
    }

    private static ServletRegistration findVaadinServlet(ServletContext context) {
        return context.getServletRegistrations().values().stream().filter(registration -> ServletDeployer.isVaadinServlet(context.getClassLoader(), registration)).findAny().orElse(null);
    }

    private static boolean isVaadinServlet(ClassLoader classLoader, ServletRegistration registration) {
        String className = registration.getClassName();
        try {
            return VaadinServlet.class.isAssignableFrom(classLoader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            ServletDeployer.getLogger().info("Assuming {} is not a Vaadin servlet", (Object)className, (Object)e);
            return false;
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ServletDeployer.class.getName());
    }
}

