/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.base;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.polymer2lit.FrontendConverter;
import com.vaadin.flow.polymer2lit.ServerConverter;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class ConvertPolymerCommand
implements AutoCloseable {
    private static final String SERVER_GLOB = "**/*.java";
    private static final String FRONTEND_GLOB = "**/*.js";
    private PluginAdapterBase adapter;
    private String path;
    private boolean useLit1;
    private boolean disableOptionalChaining;
    private ServerConverter serverConverter;
    private FrontendConverter frontendConverter;

    public ConvertPolymerCommand(PluginAdapterBase adapter, String path, boolean useLit1, boolean disableOptionalChaining) throws URISyntaxException, IOException {
        this.adapter = adapter;
        this.path = path;
        this.useLit1 = useLit1;
        this.disableOptionalChaining = disableOptionalChaining;
        this.serverConverter = new ServerConverter();
        this.frontendConverter = new FrontendConverter(new FrontendTools(this.getFrontendToolsSettings()));
    }

    @Override
    public void close() throws IOException {
        this.frontendConverter.close();
    }

    public void execute() throws IOException, InterruptedException, FrontendUtils.CommandExecutionException {
        Path lookupPath = this.getLookupPath();
        int totalCount = 0;
        int convertedCount = 0;
        int skippedCount = 0;
        int failedCount = 0;
        for (Path filePath : this.getFilePathsByGlob(lookupPath, SERVER_GLOB)) {
            try {
                ++totalCount;
                this.adapter.logInfo(String.format("Processing %s...", filePath));
                if (this.serverConverter.convertFile(filePath)) {
                    this.adapter.logInfo("The file was successfully converted.");
                    ++convertedCount;
                    continue;
                }
                this.adapter.logInfo("No occurences of PolymerTemplate was found. Skipping.");
                ++skippedCount;
            }
            catch (Exception e) {
                this.adapter.logError("An error occurred while processing.", e);
                ++failedCount;
            }
        }
        for (Path filePath : this.getFilePathsByGlob(lookupPath, FRONTEND_GLOB)) {
            try {
                ++totalCount;
                this.adapter.logInfo(String.format("Processing %s...", filePath));
                if (this.frontendConverter.convertFile(filePath, this.useLit1, this.disableOptionalChaining)) {
                    this.adapter.logInfo("The file was successfully converted.");
                    ++convertedCount;
                    continue;
                }
                this.adapter.logInfo("No occurences of PolymerElement was found. Skipping.");
                ++skippedCount;
            }
            catch (Exception e) {
                this.adapter.logError("An error occurred while processing.", e);
                ++failedCount;
            }
        }
        this.adapter.logInfo("------------------------------------------------------------------------");
        this.adapter.logInfo(String.format("Total: %d | Converted: %d | Failed: %d | Skipped: %d", totalCount, convertedCount, failedCount, skippedCount));
    }

    private List<Path> getFilePathsByGlob(Path baseDir, String glob) throws IOException {
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        final ArrayList<Path> matchingPaths = new ArrayList<Path>();
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.toString().contains("node_modules")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (matcher.matches(file)) {
                    matchingPaths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return matchingPaths;
    }

    private Path getLookupPath() {
        if (this.path != null) {
            return Paths.get(this.adapter.projectBaseDirectory().toString(), this.path);
        }
        return this.adapter.projectBaseDirectory();
    }

    private FrontendToolsSettings getFrontendToolsSettings() throws URISyntaxException {
        FrontendToolsSettings settings = new FrontendToolsSettings(this.adapter.npmFolder().getAbsolutePath(), (SerializableSupplier & Serializable)() -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(this.adapter.nodeDownloadRoot());
        settings.setNodeVersion(this.adapter.nodeVersion());
        settings.setUseGlobalPnpm(this.adapter.useGlobalPnpm());
        settings.setForceAlternativeNode(this.adapter.requireHomeNodeExec());
        settings.setIgnoreVersionChecks(this.adapter.isFrontendIgnoreVersionChecks());
        return settings;
    }
}

