/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import java.io.File;
import java.net.URL;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

public class FlowPluginFrontendUtils {
    private static final String INCLUDE_FROM_COMPILE_DEPS_REGEX = ".*(/|\\\\)(portlet-api|javax\\.servlet-api)-.+jar$";

    private FlowPluginFrontendUtils() {
    }

    public static ClassFinder getClassFinder(MavenProject project) {
        Stream<String> classpathElements;
        try {
            classpathElements = Stream.concat(project.getRuntimeClasspathElements().stream(), project.getCompileClasspathElements().stream().filter(s -> s.matches(INCLUDE_FROM_COMPILE_DEPS_REGEX)));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException(String.format("Failed to retrieve runtime classpath elements from project '%s'", project), e);
        }
        URL[] urls = (URL[])classpathElements.distinct().map(File::new).map(FlowFileUtils::convertToUrl).toArray(URL[]::new);
        return new ReflectionsClassFinder(urls);
    }
}

