/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.html.NativeTableRow;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

interface NativeTableRowContainer
extends HasOrderedComponents {
    default public int getRowIndex(NativeTableRow row) {
        return this.indexOf((Component)row);
    }

    default public List<NativeTableRow> getRows() {
        return this.getChildren().filter(c -> c instanceof NativeTableRow).map(c -> (NativeTableRow)((Object)c)).collect(Collectors.toList());
    }

    default public Optional<NativeTableRow> getRow(int index) {
        return this.getChildren().filter(c -> c instanceof NativeTableRow).map(c -> (NativeTableRow)((Object)c)).skip(index).findFirst();
    }

    default public void addRows(NativeTableRow ... rows) {
        this.add((Component[])rows);
    }

    default public NativeTableRow addRow() {
        NativeTableRow row = new NativeTableRow();
        this.add(new Component[]{row});
        return row;
    }

    default public NativeTableRow insertRow(int position) {
        NativeTableRow row = new NativeTableRow();
        this.addComponentAtIndex(position, (Component)row);
        return row;
    }

    default public void removeRows(NativeTableRow ... rows) {
        this.remove((Component[])rows);
    }

    default public void removeRow(int index) {
        this.getRow(index).ifPresent(xva$0 -> this.remove(new Component[]{xva$0}));
    }

    default public void removeAllRows() {
        this.removeAll();
    }

    default public void replaceRow(int index, NativeTableRow row) {
        Component oldRow = this.getComponentAt(index);
        this.replace(oldRow, (Component)row);
    }

    default public long getRowCount() {
        return this.getChildren().filter(c -> c instanceof NativeTableRow).count();
    }
}

