/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="iframe")
public class IFrame
extends HtmlComponent
implements HasAriaLabel {
    private static final PropertyDescriptor<String, String> srcDescriptor = PropertyDescriptors.attributeWithDefault((String)"src", (String)"");
    private static final PropertyDescriptor<String, Optional<String>> srcdocDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"srcdoc", (String)"");
    private static final PropertyDescriptor<String, Optional<String>> nameDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"name", (String)"");
    private static final PropertyDescriptor<String, Optional<String>> sandboxDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"sandbox", (String)"allow-all");
    private static final PropertyDescriptor<String, Optional<String>> allowDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"allow", (String)"");
    private static final PropertyDescriptor<String, Optional<String>> importanceDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"importance", (String)"auto");

    public IFrame() {
    }

    public IFrame(String src) {
        this.setSrc(src);
    }

    public IFrame(DownloadHandler downloadHandler) {
        this.setSrc(downloadHandler);
    }

    public void setSrc(String src) {
        this.set(srcDescriptor, src);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public void setSrc(AbstractStreamResource src) {
        this.getElement().setAttribute("src", src);
    }

    public void setSrc(DownloadHandler downloadHandler) {
        if (downloadHandler instanceof AbstractDownloadHandler) {
            AbstractDownloadHandler handler = (AbstractDownloadHandler)downloadHandler;
            handler.inline();
        }
        this.getElement().setAttribute("src", (ElementRequestHandler)downloadHandler);
    }

    public String getSrc() {
        return (String)this.get(srcDescriptor);
    }

    public void setSrcdoc(String srcdoc) {
        this.set(srcdocDescriptor, srcdoc);
    }

    public Optional<String> getSrcdoc() {
        return (Optional)this.get(srcdocDescriptor);
    }

    public void setAllow(String allow) {
        this.set(allowDescriptor, allow);
    }

    public Optional<String> getAllow() {
        return (Optional)this.get(allowDescriptor);
    }

    public void setName(String name) {
        this.set(nameDescriptor, name);
    }

    public Optional<String> getName() {
        return (Optional)this.get(nameDescriptor);
    }

    public void setImportance(ImportanceType importance) {
        this.set(importanceDescriptor, importance != null ? importance.value : "");
    }

    public Optional<ImportanceType> getImportance() {
        return ((Optional)this.get(importanceDescriptor)).flatMap(ImportanceType::fromAttributeValue);
    }

    public void setSandbox(SandboxType ... types) {
        if (types == null || types.length == 0) {
            this.set(sandboxDescriptor, "allow-all");
        } else {
            this.set(sandboxDescriptor, Stream.of(types).map(SandboxType::getValue).collect(Collectors.joining(" ")));
        }
    }

    public Optional<SandboxType[]> getSandbox() {
        return ((Optional)this.get(sandboxDescriptor)).map(value -> Stream.of(value.split(" ")).map(SandboxType::fromAttributeValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).map(collection -> collection.toArray(new SandboxType[collection.size()]));
    }

    public void reload() {
        this.getElement().executeJs("this.src = this.src", new Serializable[0]);
    }

    public static enum ImportanceType {
        AUTO("auto"),
        HIGH("high"),
        LOW("low");

        private final String value;

        private ImportanceType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        private static Optional<ImportanceType> fromAttributeValue(String value) {
            return Stream.of(ImportanceType.values()).filter(type -> type.value.equals(value)).findFirst();
        }
    }

    public static enum SandboxType {
        RESTRICT_ALL(""),
        ALLOW_FORMS("allow-forms"),
        ALLOW_MODALS("allow-modals"),
        ALLOW_ORIENTATION_LOCK("allow-orientation-lock"),
        ALLOW_POINTER_LOCK("allow-pointer-lock"),
        ALLOW_POPUPS("allow-popups"),
        ALLOW_POPUPS_TO_ESCAPE_SANDBOX("allow-popups-to-escape-sandbox"),
        ALLOW_PRESENTATION("allow-presentation"),
        ALLOW_SAME_ORIGIN("allow-same-origin"),
        ALLOW_SCRIPTS("allow-scripts"),
        ALLOW_STORAGE_ACCESS_BY_USER_ACTIVATION("allow-storage-access-by-user-activation"),
        ALLOW_TOP_NAVIGATION("allow-top-navigation"),
        ALLOW_TOP_NAVIGATION_BY_USER_ACTIVATION("allow-top-navigation-by-user-activation");

        private final String value;

        private SandboxType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        private static Optional<SandboxType> fromAttributeValue(String value) {
            return Stream.of(SandboxType.values()).filter(type -> type.value.equals(value)).findFirst();
        }
    }
}

