/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import java.util.Optional;

@Tag(value="input")
public class Input
extends AbstractSinglePropertyField<Input, String>
implements Focusable<Input>,
HasSize,
HasStyle,
HasValueChangeMode,
HasAriaLabel {
    private static final PropertyDescriptor<String, Optional<String>> placeholderDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"placeholder", (String)"");
    private static final PropertyDescriptor<String, String> typeDescriptor = PropertyDescriptors.attributeWithDefault((String)"type", (String)"text");
    private int valueChangeTimeout = 400;
    private ValueChangeMode currentMode;

    public Input() {
        this(ValueChangeMode.ON_CHANGE);
    }

    public Input(ValueChangeMode valueChangeMode) {
        super("value", (Object)"", false);
        this.setValueChangeMode(valueChangeMode);
    }

    public void setPlaceholder(String placeholder) {
        this.set(placeholderDescriptor, placeholder);
    }

    public Optional<String> getPlaceholder() {
        return (Optional)this.get(placeholderDescriptor);
    }

    public void setType(String type) {
        this.set(typeDescriptor, type);
    }

    public String getType() {
        return (String)this.get(typeDescriptor);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"input"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.currentMode, (int)this.valueChangeTimeout, (DomListenerRegistration)this.getSynchronizationRegistration());
    }
}

