/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.io.Serializable;
import java.util.Locale;

public class StringToBooleanConverter
implements Converter<String, Boolean> {
    private final String trueString;
    private final String falseString;
    private ErrorMessageProvider errorMessageProvider;

    public StringToBooleanConverter(String errorMessage) {
        this(errorMessage, Boolean.TRUE.toString(), Boolean.FALSE.toString());
    }

    public StringToBooleanConverter(ErrorMessageProvider errorMessageProvider) {
        this(Boolean.TRUE.toString(), Boolean.FALSE.toString(), errorMessageProvider);
    }

    public StringToBooleanConverter(String errorMessage, String trueString, String falseString) {
        this(trueString, falseString, (ErrorMessageProvider & Serializable)(ValueContext ctx) -> errorMessage);
    }

    public StringToBooleanConverter(String trueString, String falseString, ErrorMessageProvider errorMessageProvider) {
        this.errorMessageProvider = errorMessageProvider;
        this.trueString = trueString;
        this.falseString = falseString;
    }

    @Override
    public Result<Boolean> convertToModel(String value, ValueContext context) {
        if (value == null) {
            return Result.ok(null);
        }
        value = value.trim();
        Locale locale = context.getLocale().orElse(null);
        if (this.getTrueString(locale).equals(value)) {
            return Result.ok(true);
        }
        if (this.getFalseString(locale).equals(value)) {
            return Result.ok(false);
        }
        if (value.isEmpty()) {
            return Result.ok(null);
        }
        return Result.error(this.errorMessageProvider.apply(context));
    }

    @Override
    public String convertToPresentation(Boolean value, ValueContext context) {
        if (value == null) {
            return null;
        }
        Locale locale = context.getLocale().orElse(null);
        if (value.booleanValue()) {
            return this.getTrueString(locale);
        }
        return this.getFalseString(locale);
    }

    protected String getFalseString(Locale locale) {
        return this.falseString;
    }

    protected String getTrueString(Locale locale) {
        return this.trueString;
    }
}

