/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.AbstractBeanPropertyDefinition;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.PropertyFilterDefinition;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.BeanUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BeanPropertySet<T>
implements PropertySet<T> {
    private static final ConcurrentMap<InstanceKey<?>, BeanPropertySet<?>> INSTANCES = new ConcurrentHashMap();
    private final InstanceKey<T> instanceKey;
    private final Map<String, PropertyDefinition<T, ?>> definitions;

    private BeanPropertySet(InstanceKey<T> instanceKey) {
        this.instanceKey = instanceKey;
        try {
            this.definitions = BeanUtil.getBeanPropertyDescriptors(instanceKey.type).stream().filter(BeanPropertySet::hasNonObjectReadMethod).map(descriptor -> new BeanPropertyDefinition(this, instanceKey.type, (PropertyDescriptor)descriptor)).collect(Collectors.toMap(PropertyDefinition::getName, Function.identity(), this::mergePropertyDefinitions));
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Cannot find property descriptors for " + instanceKey.type.getName(), e);
        }
    }

    private PropertyDefinition<T, ?> mergePropertyDefinitions(PropertyDefinition<T, ?> def1, PropertyDefinition<T, ?> def2) {
        if (!def1.getType().equals(def2.getType())) {
            throw new IllegalStateException(String.format("Two property definition for property %s are discovered with different types: %s and %s", def1.getName(), def1.getType(), def2.getType()));
        }
        if (!def1.getPropertyHolderType().equals(def2.getPropertyHolderType())) {
            throw new IllegalStateException(String.format("Two property definition for property %s are discovered with different holder types: %s and %s", def1.getName(), def1.getPropertyHolderType(), def2.getPropertyHolderType()));
        }
        return def1;
    }

    private BeanPropertySet(InstanceKey<T> instanceKey, Map<String, PropertyDefinition<T, ?>> definitions) {
        this.instanceKey = instanceKey;
        this.definitions = new HashMap(definitions);
    }

    private BeanPropertySet(InstanceKey<T> instanceKey, boolean checkNestedDefinitions, PropertyFilterDefinition propertyFilterDefinition) {
        this(instanceKey);
        if (checkNestedDefinitions) {
            Objects.requireNonNull(propertyFilterDefinition, "You must define a property filter callback if using nested property scan.");
            this.findNestedDefinitions(this.definitions, 0, propertyFilterDefinition);
        }
    }

    private void findNestedDefinitions(Map<String, PropertyDefinition<T, ?>> parentDefinitions, int depth, PropertyFilterDefinition filterCallback) {
        if (depth >= filterCallback.getMaxNestingDepth()) {
            return;
        }
        if (parentDefinitions == null) {
            return;
        }
        HashMap moreProps = new HashMap();
        for (String parentPropertyKey : parentDefinitions.keySet()) {
            PropertyDefinition<T, ?> parentProperty = parentDefinitions.get(parentPropertyKey);
            Class<?> type = parentProperty.getType();
            if (type.getPackage() == null || type.isEnum()) continue;
            String packageName = type.getPackage().getName();
            if (filterCallback.getIgnorePackageNamesStartingWith().stream().anyMatch(prefix -> packageName.startsWith((String)prefix))) continue;
            try {
                List descriptors = BeanUtil.getBeanPropertyDescriptors(type).stream().filter(BeanPropertySet::hasNonObjectReadMethod).collect(Collectors.toList());
                for (PropertyDescriptor descriptor : descriptors) {
                    String name = parentPropertyKey + "." + descriptor.getName();
                    PropertyDescriptor subDescriptor = BeanUtil.getPropertyDescriptor(this.instanceKey.type, (String)name);
                    moreProps.put(name, new NestedBeanPropertyDefinition(this, parentProperty, subDescriptor));
                }
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Error finding nested property descriptors for " + type.getName(), e);
            }
        }
        if (moreProps.size() > 0) {
            this.definitions.putAll(moreProps);
            this.findNestedDefinitions(moreProps, ++depth, filterCallback);
        }
    }

    public static <T> PropertySet<T> get(Class<? extends T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        InstanceKey key = new InstanceKey(beanType, false, 0, null);
        return INSTANCES.computeIfAbsent(key, ignored -> new BeanPropertySet(key)).copy();
    }

    private BeanPropertySet<T> copy() {
        return new BeanPropertySet<T>(this.instanceKey, this.definitions);
    }

    public static <T> PropertySet<T> get(Class<? extends T> beanType, boolean checkNestedDefinitions, PropertyFilterDefinition filterDefinition) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        InstanceKey key = new InstanceKey(beanType, false, filterDefinition.getMaxNestingDepth(), filterDefinition.getIgnorePackageNamesStartingWith());
        return INSTANCES.computeIfAbsent(key, k -> new BeanPropertySet(key, checkNestedDefinitions, filterDefinition)).copy();
    }

    @Override
    public Stream<PropertyDefinition<T, ?>> getProperties() {
        return this.definitions.values().stream();
    }

    @Override
    public Optional<PropertyDefinition<T, ?>> getProperty(String name) throws IllegalArgumentException {
        Optional<PropertyDefinition<T, ?>> definition = Optional.ofNullable(this.definitions.get(name));
        if (!definition.isPresent() && name.contains(".")) {
            try {
                String parentName = name.substring(0, name.lastIndexOf(46));
                Optional<PropertyDefinition<T, ?>> parent = this.getProperty(parentName);
                if (!parent.isPresent()) {
                    throw new IllegalArgumentException("Cannot find property descriptor [" + parentName + "] for " + this.instanceKey.type.getName());
                }
                Optional<PropertyDescriptor> descriptor = Optional.ofNullable(BeanUtil.getPropertyDescriptor(this.instanceKey.type, (String)name));
                if (descriptor.isPresent()) {
                    NestedBeanPropertyDefinition nestedDefinition = new NestedBeanPropertyDefinition(this, parent.get(), descriptor.get());
                    this.definitions.put(name, nestedDefinition);
                    return Optional.of(nestedDefinition);
                }
                throw new IllegalArgumentException("Cannot find property descriptor [" + name + "] for " + this.instanceKey.type.getName());
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Cannot find property descriptors for " + this.instanceKey.type.getName(), e);
            }
        }
        return definition;
    }

    public Class<T> getBeanType() {
        return this.instanceKey.type;
    }

    private static boolean hasNonObjectReadMethod(PropertyDescriptor descriptor) {
        Method readMethod = descriptor.getReadMethod();
        return readMethod != null && readMethod.getDeclaringClass() != Object.class;
    }

    private static Object invokeWrapExceptions(Method method, Object target, Object ... parameters) {
        try {
            return method.invoke(target, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "Property set for bean " + this.instanceKey.type.getName();
    }

    private Object writeReplace() {
        return new SerializedPropertySet<T>(this.instanceKey);
    }

    private static class InstanceKey<T>
    implements Serializable {
        private Class<T> type;
        private boolean checkNestedDefinitions;
        private int depth;
        private List<String> ignorePackageNames;

        public InstanceKey(Class<T> type, boolean checkNestedDefinitions, int depth, List<String> ignorePackageNames) {
            this.type = type;
            this.checkNestedDefinitions = checkNestedDefinitions;
            this.depth = depth;
            this.ignorePackageNames = ignorePackageNames;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.checkNestedDefinitions ? 1231 : 1237);
            result = 31 * result + this.depth;
            result = 31 * result + (this.ignorePackageNames == null ? 0 : this.ignorePackageNames.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceKey other = (InstanceKey)obj;
            if (this.checkNestedDefinitions != other.checkNestedDefinitions) {
                return false;
            }
            if (this.depth != other.depth) {
                return false;
            }
            if (this.ignorePackageNames == null ? other.ignorePackageNames != null : !this.ignorePackageNames.equals(other.ignorePackageNames)) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }
    }

    public static class NestedBeanPropertyDefinition<T, V>
    extends AbstractBeanPropertyDefinition<T, V> {
        protected static final int MAX_PROPERTY_NESTING_DEPTH = 10;
        private final PropertyDefinition<T, ?> parent;

        public NestedBeanPropertyDefinition(BeanPropertySet<T> propertySet, PropertyDefinition<T, ?> parent, PropertyDescriptor descriptor) {
            super(propertySet, parent.getType(), descriptor);
            this.parent = parent;
        }

        @Override
        public ValueProvider<T, V> getGetter() {
            return (ValueProvider & Serializable)bean -> {
                Method readMethod = this.getDescriptor().getReadMethod();
                Object value = BeanPropertySet.invokeWrapExceptions(readMethod, this.parent.getGetter().apply(bean), new Object[0]);
                return this.getType().cast(value);
            };
        }

        @Override
        public Optional<Setter<T, V>> getSetter() {
            if (this.getDescriptor().getWriteMethod() == null) {
                return Optional.empty();
            }
            Setter<Object, Object> setter = (bean, value) -> {
                Method innerSetter = this.getDescriptor().getWriteMethod();
                BeanPropertySet.invokeWrapExceptions(innerSetter, this.parent.getGetter().apply(bean), value);
            };
            return Optional.of(setter);
        }

        @Override
        public String getName() {
            return this.parent.getName() + "." + super.getName();
        }

        @Override
        public String getTopLevelName() {
            return super.getName();
        }

        private Object writeReplace() {
            return new SerializedPropertyDefinition(((BeanPropertySet)this.getPropertySet()).instanceKey.type, this.getName());
        }

        @Override
        public PropertyDefinition<T, ?> getParent() {
            return this.parent;
        }
    }

    private static class SerializedPropertySet<T>
    implements Serializable {
        private final InstanceKey<T> instanceKey;

        private SerializedPropertySet(InstanceKey<T> instanceKey) {
            this.instanceKey = instanceKey;
        }

        private Object readResolve() {
            return BeanPropertySet.get(this.instanceKey.type, this.instanceKey.checkNestedDefinitions, new PropertyFilterDefinition(this.instanceKey.depth, this.instanceKey.ignorePackageNames));
        }
    }

    private static class BeanPropertyDefinition<T, V>
    extends AbstractBeanPropertyDefinition<T, V> {
        public BeanPropertyDefinition(BeanPropertySet<T> propertySet, Class<T> propertyHolderType, PropertyDescriptor descriptor) {
            super(propertySet, propertyHolderType, descriptor);
        }

        @Override
        public ValueProvider<T, V> getGetter() {
            return (ValueProvider & Serializable)bean -> {
                Method readMethod = this.getDescriptor().getReadMethod();
                Object value = BeanPropertySet.invokeWrapExceptions(readMethod, bean, new Object[0]);
                return this.getType().cast(value);
            };
        }

        @Override
        public Optional<Setter<T, V>> getSetter() {
            if (this.getDescriptor().getWriteMethod() == null) {
                return Optional.empty();
            }
            Setter<Object, Object> setter = (bean, value) -> {
                Method innerSetter = this.getDescriptor().getWriteMethod();
                BeanPropertySet.invokeWrapExceptions(innerSetter, bean, value);
            };
            return Optional.of(setter);
        }

        private Object writeReplace() {
            return new SerializedPropertyDefinition(((BeanPropertySet)this.getPropertySet()).instanceKey.type, this.getName());
        }

        @Override
        public PropertyDefinition<T, ?> getParent() {
            return null;
        }
    }

    private static class SerializedPropertyDefinition
    implements Serializable {
        private final Class<?> beanType;
        private final String propertyName;

        private SerializedPropertyDefinition(Class<?> beanType, String propertyName) {
            this.beanType = beanType;
            this.propertyName = propertyName;
        }

        private Object readResolve() throws IOException {
            return BeanPropertySet.get(this.beanType).getProperty(this.propertyName).orElseThrow(() -> new IOException(this.beanType + " no longer has a property named " + this.propertyName));
        }
    }
}

