/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.BinderValidationErrorHandler;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.BinderValidationStatusHandler;
import com.vaadin.flow.data.binder.BindingValidationStatus;
import com.vaadin.flow.data.binder.BindingValidationStatusHandler;
import com.vaadin.flow.data.binder.DefaultBinderValidationErrorHandler;
import com.vaadin.flow.data.binder.ErrorLevel;
import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.PropertyFilterDefinition;
import com.vaadin.flow.data.binder.PropertyId;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.binder.StatusChangeEvent;
import com.vaadin.flow.data.binder.StatusChangeListener;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationResultWrap;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Binder<BEAN>
implements Serializable {
    private final PropertySet<BEAN> propertySet;
    private final Map<String, Binding<BEAN, ?>> boundProperties = new HashMap();
    private Map<HasValue<?, ?>, BindingBuilder<BEAN, ?>> incompleteMemberFieldBindings;
    private BEAN bean;
    private final Collection<Binding<BEAN, ?>> bindings = new ArrayList();
    private Map<HasValue<?, ?>, BindingBuilder<BEAN, ?>> incompleteBindings;
    private final List<Validator<? super BEAN>> validators = new ArrayList<Validator<? super BEAN>>();
    private final Map<HasValue<?, ?>, ConverterDelegate<?>> initialConverters = new IdentityHashMap(4);
    private HashMap<Class<?>, List<SerializableConsumer<?>>> listeners = new HashMap();
    private HasText statusLabel;
    private BinderValidationStatusHandler<BEAN> statusHandler;
    private BinderValidationErrorHandler errorHandler = new DefaultBinderValidationErrorHandler();
    private Set<Binding<BEAN, ?>> changedBindings = new LinkedHashSet();
    private boolean validatorsDisabled = false;

    protected Binder(PropertySet<BEAN> propertySet) {
        Objects.requireNonNull(propertySet, "propertySet cannot be null");
        this.propertySet = propertySet;
    }

    public Binder(Class<BEAN> beanType) {
        this(BeanPropertySet.get(beanType));
    }

    public Binder() {
        this(new PropertySet<BEAN>(){

            @Override
            public Stream<PropertyDefinition<BEAN, ?>> getProperties() {
                throw new IllegalStateException("This Binder instance was created using the default constructor. To be able to use property names and bind to instance fields, create the binder using the Binder(Class<BEAN> beanType) constructor instead.");
            }

            @Override
            public Optional<PropertyDefinition<BEAN, ?>> getProperty(String name) {
                throw new IllegalStateException("This Binder instance was created using the default constructor. To be able to use property names and bind to instance fields, create the binder using the Binder(Class<BEAN> beanType) constructor instead.");
            }
        });
    }

    public Binder(Class<BEAN> beanType, boolean scanNestedDefinitions) {
        this(BeanPropertySet.get(beanType, scanNestedDefinitions, PropertyFilterDefinition.getDefaultFilter()));
    }

    public static <BEAN> Binder<BEAN> withPropertySet(PropertySet<BEAN> propertySet) {
        return new Binder<BEAN>(propertySet);
    }

    protected void handleFieldValueChange(Binding<BEAN, ?> binding) {
        this.changedBindings.add(binding);
        if (this.getBean() != null) {
            this.doWriteIfValid(this.getBean(), this.changedBindings);
        } else {
            binding.validate();
        }
    }

    public BEAN getBean() {
        return this.bean;
    }

    public <FIELDVALUE> BindingBuilder<BEAN, FIELDVALUE> forField(HasValue<?, FIELDVALUE> field) {
        Objects.requireNonNull(field, "field cannot be null");
        this.clearError(field);
        this.getStatusLabel().ifPresent(label -> label.setText(""));
        return this.createBinding(field, this.createNullRepresentationAdapter(field), this::handleValidationStatus).withValidator(field instanceof HasValidator ? ((HasValidator)field).getDefaultValidator() : Validator.alwaysPass());
    }

    public <FIELDVALUE> BindingBuilder<BEAN, FIELDVALUE> forMemberField(HasValue<?, FIELDVALUE> field) {
        if (this.incompleteMemberFieldBindings == null) {
            this.incompleteMemberFieldBindings = new IdentityHashMap(8);
        }
        this.incompleteMemberFieldBindings.put(field, null);
        return this.forField(field);
    }

    public <FIELDVALUE> Binding<BEAN, FIELDVALUE> bind(HasValue<?, FIELDVALUE> field, ValueProvider<BEAN, FIELDVALUE> getter, Setter<BEAN, FIELDVALUE> setter) {
        return this.forField(field).bind(getter, setter);
    }

    public <FIELDVALUE> Binding<BEAN, FIELDVALUE> bind(HasValue<?, FIELDVALUE> field, String propertyName) {
        return this.forField(field).bind(propertyName);
    }

    public void setBean(BEAN bean) {
        this.checkBindingsCompleted("setBean");
        if (bean == null) {
            if (this.bean != null) {
                this.doRemoveBean(true);
                this.clearFields();
            }
        } else {
            this.doRemoveBean(false);
            this.bean = bean;
            this.getBindings().forEach(b -> ((BindingImpl)b).initFieldValue(bean, true));
            this.getValidationStatusHandler().statusChange(BinderValidationStatus.createUnresolvedStatus(this));
            this.fireStatusChangeEvent(false);
        }
    }

    public void removeBean() {
        this.setBean(null);
    }

    public void readBean(BEAN bean) {
        this.checkBindingsCompleted("readBean");
        if (bean == null) {
            this.clearFields();
        } else {
            this.changedBindings.clear();
            this.getBindings().forEach(binding -> {
                if (binding.getField() != null) {
                    ((BindingImpl)binding).initFieldValue(bean, false);
                }
            });
            this.getValidationStatusHandler().statusChange(BinderValidationStatus.createUnresolvedStatus(this));
            this.fireStatusChangeEvent(false);
        }
    }

    public void writeBean(BEAN bean) throws ValidationException {
        BinderValidationStatus<BEAN> status = this.doWriteIfValid(bean, this.bindings);
        if (status.hasErrors()) {
            throw new ValidationException(status.getFieldValidationErrors(), status.getBeanValidationErrors());
        }
    }

    public void writeBeanAsDraft(BEAN bean) {
        this.doWriteDraft(bean, new ArrayList(this.bindings), false);
    }

    public void writeBeanAsDraft(BEAN bean, boolean forced) {
        this.doWriteDraft(bean, new ArrayList(this.bindings), forced);
    }

    public boolean writeBeanIfValid(BEAN bean) {
        return this.doWriteIfValid(bean, this.bindings).isOk();
    }

    private BinderValidationStatus<BEAN> doWriteIfValid(BEAN bean, Collection<Binding<BEAN, ?>> bindings) {
        Objects.requireNonNull(bean, "bean cannot be null");
        List<ValidationResult> binderResults = Collections.emptyList();
        ArrayList currentBindings = new ArrayList(bindings);
        List<BindingValidationStatus<?>> bindingResults = currentBindings.stream().map(b -> b.validate(false)).collect(Collectors.toList());
        if (bindingResults.stream().noneMatch(BindingValidationStatus::isError)) {
            Map<Binding<BEAN, ?>, Object> oldValues = this.getBeanState(bean, currentBindings);
            currentBindings.forEach(binding -> ((BindingImpl)binding).writeFieldValue(bean));
            binderResults = this.validateBean(bean);
            if (binderResults.stream().anyMatch(ValidationResult::isError)) {
                this.restoreBeanState(bean, oldValues);
            } else if (bean.equals(this.getBean())) {
                this.changedBindings.clear();
            } else if (this.getBean() == null) {
                this.changedBindings.clear();
            }
        }
        BinderValidationStatus status = new BinderValidationStatus(this, bindingResults, binderResults);
        this.getValidationStatusHandler().statusChange(status);
        this.fireStatusChangeEvent(!status.isOk());
        return status;
    }

    private void doWriteDraft(BEAN bean, Collection<Binding<BEAN, ?>> bindings, boolean forced) {
        Objects.requireNonNull(bean, "bean cannot be null");
        if (!forced) {
            bindings.forEach(binding -> ((BindingImpl)binding).writeFieldValue(bean));
        } else {
            boolean isDisabled = this.isValidatorsDisabled();
            this.setValidatorsDisabled(true);
            bindings.forEach(binding -> ((BindingImpl)binding).writeFieldValue(bean));
            this.setValidatorsDisabled(isDisabled);
        }
    }

    protected void restoreBeanState(BEAN bean, Map<Binding<BEAN, ?>, Object> oldValues) {
        this.getBindings().stream().filter(oldValues::containsKey).forEach(binding -> {
            Setter setter = ((BindingImpl)binding).setter;
            if (setter != null) {
                setter.accept(bean, oldValues.get(binding));
            }
        });
    }

    protected Map<Binding<BEAN, ?>, Object> getBeanState(BEAN bean, Collection<Binding<BEAN, ?>> bindings) {
        HashMap oldValues = new HashMap();
        bindings.stream().map(binding -> (BindingImpl)binding).filter(binding -> ((BindingImpl)binding).setter != null).forEach(binding -> oldValues.put((Binding)binding, ((BindingImpl)binding).getter.apply(bean)));
        return oldValues;
    }

    public Binder<BEAN> withValidator(Validator<? super BEAN> validator) {
        Objects.requireNonNull(validator, "validator cannot be null");
        Validator<Object> wrappedValidator = (value, context) -> {
            if (this.isValidatorsDisabled()) {
                return ValidationResult.ok();
            }
            return validator.apply((BEAN)value, context);
        };
        this.validators.add(wrappedValidator);
        return this;
    }

    public Binder<BEAN> withValidator(SerializablePredicate<BEAN> predicate, String message) {
        return this.withValidator(Validator.from(predicate, message));
    }

    public Binder<BEAN> withValidator(SerializablePredicate<BEAN> predicate, ErrorMessageProvider errorMessageProvider) {
        return this.withValidator(Validator.from(predicate, errorMessageProvider));
    }

    private void clearFields() {
        this.bindings.forEach(binding -> {
            binding.getField().clear();
            this.clearError(binding.getField());
        });
        if (this.hasChanges()) {
            this.fireStatusChangeEvent(false);
        }
        this.changedBindings.clear();
    }

    public BinderValidationStatus<BEAN> validate() {
        return this.validate(true);
    }

    protected BinderValidationStatus<BEAN> validate(boolean fireEvent) {
        BinderValidationStatus validationStatus;
        if (this.getBean() == null && !this.validators.isEmpty()) {
            throw new IllegalStateException("Cannot validate binder: bean level validators have been configured but no bean is currently set");
        }
        List<BindingValidationStatus<?>> bindingStatuses = this.validateBindings();
        if (this.validators.isEmpty() || bindingStatuses.stream().anyMatch(BindingValidationStatus::isError)) {
            validationStatus = new BinderValidationStatus(this, bindingStatuses, Collections.emptyList());
        } else {
            Map<Binding<BEAN, ?>, Object> beanState = this.getBeanState(this.getBean(), this.changedBindings);
            this.changedBindings.forEach(binding -> ((BindingImpl)binding).writeFieldValue(this.getBean()));
            validationStatus = new BinderValidationStatus(this, bindingStatuses, this.validateBean(this.getBean()));
            this.restoreBeanState(this.getBean(), beanState);
        }
        if (fireEvent) {
            this.getValidationStatusHandler().statusChange(validationStatus);
            this.fireStatusChangeEvent(validationStatus.hasErrors());
        }
        return validationStatus;
    }

    public boolean isValid() {
        return this.validate(false).isOk();
    }

    private List<BindingValidationStatus<?>> validateBindings() {
        return this.getBindings().stream().map(rec$ -> ((BindingImpl)rec$).doValidation()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private List<ValidationResult> validateBean(BEAN bean) {
        Objects.requireNonNull(bean, "bean cannot be null");
        return this.validators.stream().map(validator -> validator.apply(bean, new ValueContext())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public void setStatusLabel(HasText statusLabel) {
        if (this.statusHandler != null) {
            throw new IllegalStateException("Cannot set status label if a " + BinderValidationStatusHandler.class.getSimpleName() + " has already been set.");
        }
        this.statusLabel = statusLabel;
    }

    public Optional<HasText> getStatusLabel() {
        return Optional.ofNullable(this.statusLabel);
    }

    public void setValidationStatusHandler(BinderValidationStatusHandler<BEAN> statusHandler) {
        Objects.requireNonNull(statusHandler, "Cannot set a null " + BinderValidationStatusHandler.class.getSimpleName());
        if (this.statusLabel != null) {
            throw new IllegalStateException("Cannot set " + BinderValidationStatusHandler.class.getSimpleName() + " if a status label has already been set.");
        }
        this.statusHandler = statusHandler;
    }

    public BinderValidationStatusHandler<BEAN> getValidationStatusHandler() {
        return Optional.ofNullable(this.statusHandler).orElse(this::handleBinderValidationStatus);
    }

    public BinderValidationErrorHandler getValidationErrorHandler() {
        return this.errorHandler;
    }

    public void setValidationErrorHandler(BinderValidationErrorHandler handler) {
        Objects.requireNonNull(handler, "Cannot set a null " + BinderValidationErrorHandler.class.getSimpleName());
        this.errorHandler = handler;
    }

    public Registration addStatusChangeListener(StatusChangeListener listener) {
        return this.addListener(StatusChangeEvent.class, listener::statusChange);
    }

    protected <T> Registration addListener(Class<T> eventType, SerializableConsumer<T> method) {
        List list = this.listeners.computeIfAbsent(eventType, key -> new ArrayList());
        return Registration.addAndRemove((Collection)list, method);
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<?>> listener) {
        return this.addListener(HasValue.ValueChangeEvent.class, arg_0 -> listener.valueChanged(arg_0));
    }

    protected <FIELDVALUE, TARGET> BindingBuilder<BEAN, TARGET> createBinding(HasValue<?, FIELDVALUE> field, Converter<FIELDVALUE, TARGET> converter, BindingValidationStatusHandler handler) {
        BindingBuilder<BEAN, TARGET> newBinding = this.doCreateBinding(field, converter, handler);
        if (this.incompleteMemberFieldBindings != null && this.incompleteMemberFieldBindings.containsKey(field)) {
            this.incompleteMemberFieldBindings.put(field, newBinding);
        }
        if (this.incompleteBindings == null) {
            this.incompleteBindings = new IdentityHashMap(8);
        }
        this.incompleteBindings.put(field, newBinding);
        return newBinding;
    }

    protected <FIELDVALUE, TARGET> BindingBuilder<BEAN, TARGET> doCreateBinding(HasValue<?, FIELDVALUE> field, Converter<FIELDVALUE, TARGET> converter, BindingValidationStatusHandler handler) {
        return new BindingBuilderImpl(this, field, converter, handler);
    }

    protected void handleError(HasValue<?, ?> field, ValidationResult result) {
        this.getValidationErrorHandler().handleError(field, result);
    }

    protected void clearError(HasValue<?, ?> field) {
        this.getValidationErrorHandler().clearError(field);
    }

    protected void handleValidationStatus(BindingValidationStatus<?> status) {
        HasValue<?, ?> source = status.getField();
        this.clearError(source);
        if (status.isError()) {
            Optional<ValidationResult> firstError = status.getValidationResults().stream().filter(ValidationResult::isError).findFirst();
            if (firstError.isPresent()) {
                this.handleError(source, firstError.get());
            } else {
                status.getResult().ifPresent(result -> this.handleError(source, (ValidationResult)result));
            }
        } else {
            status.getValidationResults().stream().filter(result -> result.getErrorLevel().isPresent()).findFirst().ifPresent(result -> this.handleError(source, (ValidationResult)result));
        }
    }

    protected Collection<BindingImpl<BEAN, ?, ?>> getBindings() {
        return this.bindings.stream().map(b -> (BindingImpl)b).collect(Collectors.toList());
    }

    protected void handleBinderValidationStatus(BinderValidationStatus<BEAN> binderStatus) {
        binderStatus.notifyBindingValidationStatusHandlers();
        if (this.getStatusLabel().isPresent()) {
            String statusMessage = binderStatus.getBeanValidationErrors().stream().findFirst().map(ValidationResult::getErrorMessage).orElse("");
            this.getStatusLabel().get().setText(statusMessage);
        }
    }

    public boolean hasChanges() {
        return !this.changedBindings.isEmpty();
    }

    public void setReadOnly(boolean readOnly) {
        this.getBindings().stream().filter(binding -> binding.getSetter() != null).forEach(field -> field.setReadOnly(readOnly));
    }

    protected BindingBuilder<BEAN, ?> configureBinding(BindingBuilder<BEAN, ?> binding, PropertyDefinition<BEAN, ?> definition) {
        return binding;
    }

    private void doRemoveBean(boolean fireStatusEvent) {
        this.changedBindings.clear();
        if (this.bean != null) {
            this.bean = null;
        }
        this.getValidationStatusHandler().statusChange(BinderValidationStatus.createUnresolvedStatus(this));
        if (fireStatusEvent) {
            this.fireStatusChangeEvent(false);
        }
    }

    private void fireStatusChangeEvent(boolean hasValidationErrors) {
        StatusChangeEvent event = new StatusChangeEvent(this, hasValidationErrors);
        this.fireEvent(event);
    }

    private void fireEvent(Object event) {
        new HashMap(this.listeners).entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(event.getClass())).forEach(entry -> {
            for (Consumer consumer : new ArrayList((Collection)entry.getValue())) {
                consumer.accept(event);
            }
        });
    }

    private <FIELDVALUE> Converter<FIELDVALUE, FIELDVALUE> createNullRepresentationAdapter(HasValue<?, FIELDVALUE> field) {
        Converter nullRepresentationConverter = Converter.from((SerializableFunction & Serializable)fieldValue -> fieldValue, (SerializableFunction & Serializable)modelValue -> Objects.isNull(modelValue) ? field.getEmptyValue() : modelValue, (SerializableFunction<Exception, String>)((SerializableFunction & Serializable)Throwable::getMessage));
        ConverterDelegate converter = new ConverterDelegate(nullRepresentationConverter);
        this.initialConverters.put(field, converter);
        return converter;
    }

    private void checkBindingsCompleted(String methodName) {
        if (this.incompleteMemberFieldBindings != null && !this.incompleteMemberFieldBindings.isEmpty()) {
            throw new IllegalStateException("All bindings created with forMemberField must be completed with bindInstanceFields before calling " + methodName);
        }
        if (this.incompleteBindings != null && !this.incompleteBindings.isEmpty()) {
            throw new IllegalStateException("All bindings created with forField must be completed before calling " + methodName);
        }
    }

    public void bindInstanceFields(Object objectWithMemberFields) {
        Class<?> objectClass = objectWithMemberFields.getClass();
        Integer numberOfBoundFields = this.getFieldsInDeclareOrder(objectClass).stream().filter(memberField -> HasValue.class.isAssignableFrom(memberField.getType())).filter(memberField -> !this.isFieldBound((Field)memberField, objectWithMemberFields)).map(memberField -> this.handleProperty((Field)memberField, objectWithMemberFields, (property, type) -> this.bindProperty(objectWithMemberFields, (Field)memberField, (String)property, (Class<?>)type))).reduce(0, this::accumulate, Integer::sum);
        if (numberOfBoundFields == 0 && this.bindings.isEmpty() && (this.incompleteBindings == null || this.incompleteBindings.isEmpty())) {
            throw new IllegalStateException("There are no instance fields found for automatic binding");
        }
    }

    private boolean isFieldBound(Field memberField, Object objectWithMemberFields) {
        try {
            HasValue field = (HasValue)this.getMemberFieldValue(memberField, objectWithMemberFields);
            return this.bindings.stream().anyMatch(binding -> binding.getField() == field);
        }
        catch (Exception e) {
            return false;
        }
    }

    private int accumulate(int count, boolean value) {
        return value ? count + 1 : count;
    }

    private BindingBuilder<BEAN, ?> getIncompleteMemberFieldBinding(Field memberField, Object objectWithMemberFields) {
        if (this.incompleteMemberFieldBindings == null) {
            return null;
        }
        return this.incompleteMemberFieldBindings.get(this.getMemberFieldValue(memberField, objectWithMemberFields));
    }

    private Object getMemberFieldValue(Field memberField, Object objectWithMemberFields) {
        memberField.setAccessible(true);
        try {
            Object object = memberField.get(objectWithMemberFields);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        finally {
            memberField.setAccessible(false);
        }
    }

    private boolean bindProperty(Object objectWithMemberFields, Field memberField, String property, Class<?> propertyType) {
        Type valueType = GenericTypeReflector.getTypeParameter((Type)memberField.getGenericType(), HasValue.class.getTypeParameters()[1]);
        if (valueType == null) {
            throw new IllegalStateException(String.format("Unable to detect value type for the member '%s' in the class '%s'.", memberField.getName(), objectWithMemberFields.getClass().getName()));
        }
        if (propertyType.equals(GenericTypeReflector.erase((Type)valueType))) {
            HasValue<?, ?> field;
            try {
                field = (HasValue<?, ?>)ReflectTools.getJavaFieldValue((Object)objectWithMemberFields, (Field)memberField, HasValue.class);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return false;
            }
            if (field == null) {
                field = this.makeFieldInstance(memberField.getType());
                this.initializeField(objectWithMemberFields, memberField, field);
            }
            this.forField(field).bind(property);
            return true;
        }
        throw new IllegalStateException(String.format("Property type '%s' doesn't match the field type '%s'. Binding should be configured manually using converter.", propertyType.getName(), valueType.getTypeName()));
    }

    private HasValue<?, ?> makeFieldInstance(Class<? extends HasValue<?, ?>> fieldClass) {
        try {
            return (HasValue)ReflectTools.createInstance(fieldClass);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<Field> getFieldsInDeclareOrder(Class<?> searchClass) {
        ArrayList<Field> memberFieldInOrder = new ArrayList<Field>();
        while (searchClass != null) {
            memberFieldInOrder.addAll(Arrays.asList(searchClass.getDeclaredFields()));
            searchClass = searchClass.getSuperclass();
        }
        return memberFieldInOrder;
    }

    private void initializeField(Object objectWithMemberFields, Field memberField, HasValue<?, ?> value) {
        try {
            ReflectTools.setJavaFieldValue((Object)objectWithMemberFields, (Field)memberField, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Could not assign value to field '%s'", memberField.getName()), e);
        }
    }

    private boolean handleProperty(Field field, Object objectWithMemberFields, BiFunction<String, Class<?>, Boolean> propertyHandler) {
        Optional<PropertyDefinition<BEAN, ?>> descriptor = this.getPropertyDescriptor(field);
        if (!descriptor.isPresent()) {
            return false;
        }
        String propertyName = descriptor.get().getName();
        if (this.boundProperties.containsKey(propertyName)) {
            return false;
        }
        BindingBuilder<BEAN, ?> tentativeBinding = this.getIncompleteMemberFieldBinding(field, objectWithMemberFields);
        if (tentativeBinding != null) {
            tentativeBinding.bind(propertyName);
            return false;
        }
        Boolean isPropertyBound = propertyHandler.apply(propertyName, descriptor.get().getType());
        assert (this.boundProperties.containsKey(propertyName));
        return isPropertyBound;
    }

    public Optional<Binding<BEAN, ?>> getBinding(String propertyName) {
        return Optional.ofNullable(this.boundProperties.get(propertyName));
    }

    private Optional<PropertyDefinition<BEAN, ?>> getPropertyDescriptor(Field field) {
        PropertyId propertyIdAnnotation = field.getAnnotation(PropertyId.class);
        String propertyId = propertyIdAnnotation != null ? propertyIdAnnotation.value() : field.getName();
        String minifiedFieldName = this.minifyFieldName(propertyId);
        return this.propertySet.getProperties().map(PropertyDefinition::getName).filter(name -> this.minifyFieldName((String)name).equals(minifiedFieldName)).findFirst().flatMap(this.propertySet::getProperty);
    }

    private String minifyFieldName(String fieldName) {
        return fieldName.toLowerCase(Locale.ENGLISH).replace("_", "");
    }

    public Stream<HasValue<?, ?>> getFields() {
        return this.bindings.stream().map(Binding::getField);
    }

    private static void setVisible(HasText label, boolean visible) {
        if (visible) {
            label.getElement().getStyle().remove("display");
        } else {
            label.getElement().getStyle().set("display", "none");
        }
    }

    public void removeBinding(HasValue<?, ?> field) {
        Objects.requireNonNull(field, "Field may not be null");
        Set<BindingImpl> toRemove = this.getBindings().stream().filter(binding -> field.equals(binding.getField())).collect(Collectors.toSet());
        toRemove.forEach(Binding::unbind);
    }

    public void removeBinding(Binding<BEAN, ?> binding) {
        Objects.requireNonNull(binding, "Binding may not be null");
        binding.unbind();
    }

    protected void removeBindingInternal(Binding<BEAN, ?> binding) {
        if (this.bindings.remove(binding)) {
            this.boundProperties.entrySet().removeIf(entry -> ((Binding)entry.getValue()).equals(binding));
            this.changedBindings.remove(binding);
        }
    }

    public void removeBinding(String propertyName) {
        Objects.requireNonNull(propertyName, "Property name may not be null");
        Optional.ofNullable(this.boundProperties.get(propertyName)).ifPresent(Binding::unbind);
    }

    public void setValidatorsDisabled(boolean validatorsDisabled) {
        this.validatorsDisabled = validatorsDisabled;
    }

    public boolean isValidatorsDisabled() {
        return this.validatorsDisabled;
    }

    private static class ConverterDelegate<FIELDVALUE>
    implements Converter<FIELDVALUE, FIELDVALUE> {
        private Converter<FIELDVALUE, FIELDVALUE> delegate;

        private ConverterDelegate(Converter<FIELDVALUE, FIELDVALUE> converter) {
            this.delegate = converter;
        }

        @Override
        public Result<FIELDVALUE> convertToModel(FIELDVALUE value, ValueContext context) {
            if (this.delegate == null) {
                return Result.ok(value);
            }
            return this.delegate.convertToModel(value, context);
        }

        @Override
        public FIELDVALUE convertToPresentation(FIELDVALUE value, ValueContext context) {
            if (this.delegate == null) {
                return value;
            }
            return this.delegate.convertToPresentation(value, context);
        }

        void setIdentity() {
            this.delegate = null;
        }
    }

    private static class ValidatorAsConverter<T>
    implements Converter<T, T> {
        private final Validator<? super T> validator;

        public ValidatorAsConverter(Validator<? super T> validator) {
            this.validator = validator;
        }

        @Override
        public Result<T> convertToModel(T value, ValueContext context) {
            ValidationResult validationResult = this.validator.apply(value, context);
            return new ValidationResultWrap<T>(value, validationResult);
        }

        @Override
        public T convertToPresentation(T value, ValueContext context) {
            return value;
        }
    }

    protected static class BindingImpl<BEAN, FIELDVALUE, TARGET>
    implements Binding<BEAN, TARGET> {
        private Binder<BEAN> binder;
        private HasValue<?, FIELDVALUE> field;
        private final BindingValidationStatusHandler statusHandler;
        private final ValueProvider<BEAN, TARGET> getter;
        private final Setter<BEAN, TARGET> setter;
        private boolean readOnly;
        private Registration onValueChange;
        private boolean valueInit = false;
        private final Converter<FIELDVALUE, TARGET> converterValidatorChain;
        private final boolean asRequiredSet;
        private boolean validatorsDisabled = false;
        private boolean convertBackToPresentation = false;

        public BindingImpl(BindingBuilderImpl<BEAN, FIELDVALUE, TARGET> builder, ValueProvider<BEAN, TARGET> getter, Setter<BEAN, TARGET> setter) {
            this.binder = builder.getBinder();
            this.field = ((BindingBuilderImpl)builder).field;
            this.statusHandler = ((BindingBuilderImpl)builder).statusHandler;
            this.asRequiredSet = ((BindingBuilderImpl)builder).asRequiredSet;
            this.converterValidatorChain = ((BindingBuilderImpl)builder).converterValidatorChain;
            this.onValueChange = this.getField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.handleFieldValueChange(event));
            this.getter = getter;
            this.setter = setter;
            this.readOnly = setter == null;
        }

        @Override
        public HasValue<?, FIELDVALUE> getField() {
            return this.field;
        }

        protected static Locale findLocale() {
            Locale locale = null;
            if (UI.getCurrent() != null) {
                locale = UI.getCurrent().getLocale();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return locale;
        }

        @Override
        public BindingValidationStatus<TARGET> validate(boolean fireEvent) {
            Objects.requireNonNull(this.binder, "This Binding is no longer attached to a Binder");
            BindingValidationStatus<TARGET> status = this.doValidation();
            if (fireEvent) {
                this.getBinder().getValidationStatusHandler().statusChange(new BinderValidationStatus<BEAN>(this.getBinder(), Collections.singletonList(status), Collections.emptyList()));
                ((Binder)this.getBinder()).fireStatusChangeEvent(status.isError());
            }
            return status;
        }

        @Override
        public void unbind() {
            if (this.onValueChange != null) {
                this.onValueChange.remove();
                this.onValueChange = null;
            }
            if (this.binder != null) {
                this.binder.removeBindingInternal(this);
                this.binder = null;
            }
            this.field = null;
        }

        private Result<TARGET> doConversion() {
            Object fieldValue = this.field.getValue();
            return this.converterValidatorChain.convertToModel(fieldValue, this.createValueContext());
        }

        private BindingValidationStatus<TARGET> toValidationStatus(Result<TARGET> result) {
            return new BindingValidationStatus<TARGET>(result, this);
        }

        private BindingValidationStatus<TARGET> doValidation() {
            return this.toValidationStatus(this.doConversion());
        }

        protected ValueContext createValueContext() {
            return BindingImpl.createValueContext(this.field);
        }

        static ValueContext createValueContext(HasValue<?, ?> field) {
            if (field instanceof Component) {
                return new ValueContext((Component)field, field);
            }
            return new ValueContext(null, field, BindingImpl.findLocale());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initFieldValue(BEAN bean, boolean writeBackChangedValues) {
            assert (bean != null);
            assert (this.onValueChange != null);
            this.valueInit = true;
            try {
                Object originalValue = this.getter.apply(bean);
                this.convertAndSetFieldValue(originalValue);
                if (writeBackChangedValues && this.setter != null && !this.readOnly) {
                    this.doConversion().ifOk((SerializableConsumer & Serializable)convertedValue -> {
                        if (!Objects.equals(originalValue, convertedValue)) {
                            this.setter.accept(bean, (TARGET)convertedValue);
                        }
                    });
                }
            }
            finally {
                this.valueInit = false;
            }
        }

        private FIELDVALUE convertToFieldType(TARGET target) {
            ValueContext valueContext = this.createValueContext();
            return this.converterValidatorChain.convertToPresentation(target, valueContext);
        }

        private void handleFieldValueChange(HasValue.ValueChangeEvent<FIELDVALUE> event) {
            if (this.valueInit) {
                return;
            }
            if (this.binder != null) {
                this.getBinder().handleFieldValueChange(this);
                ((Binder)this.getBinder()).fireEvent(event);
            }
        }

        private BindingValidationStatus<TARGET> writeFieldValue(BEAN bean) {
            assert (bean != null);
            Result<TARGET> result = this.doConversion();
            if (!this.isReadOnly()) {
                result.ifOk((SerializableConsumer & Serializable)value -> {
                    this.setter.accept(bean, (TARGET)value);
                    if (this.convertBackToPresentation && value != null) {
                        FIELDVALUE converted = this.convertToFieldType(value);
                        if (!Objects.equals(this.field.getValue(), converted)) {
                            this.getField().setValue(converted);
                        }
                    }
                });
            }
            return this.toValidationStatus(result);
        }

        protected Binder<BEAN> getBinder() {
            return this.binder;
        }

        @Override
        public BindingValidationStatusHandler getValidationStatusHandler() {
            return this.statusHandler;
        }

        @Override
        public void read(BEAN bean) {
            this.convertAndSetFieldValue(this.getter.apply(bean));
        }

        private void convertAndSetFieldValue(TARGET modelValue) {
            FIELDVALUE convertedValue = this.convertToFieldType(modelValue);
            try {
                this.field.setValue(convertedValue);
            }
            catch (RuntimeException e) {
                if (convertedValue == null && this.field.getEmptyValue() != null) {
                    throw new IllegalStateException(String.format("A field of type %s didn't accept a null value. If null values are expected, then configure a null representation for the binding.", this.field.getClass().getName()), e);
                }
                throw e;
            }
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            if (this.setter == null && !readOnly) {
                throw new IllegalStateException("Binding with a null setter has to be read-only");
            }
            this.readOnly = readOnly;
            this.getField().setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public ValueProvider<BEAN, TARGET> getGetter() {
            return this.getter;
        }

        @Override
        public Setter<BEAN, TARGET> getSetter() {
            return this.setter;
        }

        @Override
        public void setAsRequiredEnabled(boolean asRequiredEnabled) {
            if (!this.asRequiredSet) {
                throw new IllegalStateException("Unable to toggle asRequired validation since asRequired has not been set.");
            }
            if (asRequiredEnabled != this.isAsRequiredEnabled()) {
                this.field.setRequiredIndicatorVisible(asRequiredEnabled);
                this.validate();
            }
        }

        @Override
        public boolean isAsRequiredEnabled() {
            return this.field.isRequiredIndicatorVisible();
        }

        @Override
        public void setValidatorsDisabled(boolean validatorsDisabled) {
            this.validatorsDisabled = validatorsDisabled;
        }

        @Override
        public boolean isValidatorsDisabled() {
            return this.validatorsDisabled;
        }

        @Override
        public void setConvertBackToPresentation(boolean convertBackToPresentation) {
            this.convertBackToPresentation = convertBackToPresentation;
        }

        @Override
        public boolean isConvertBackToPresentation() {
            return this.convertBackToPresentation;
        }
    }

    protected static class BindingBuilderImpl<BEAN, FIELDVALUE, TARGET>
    implements BindingBuilder<BEAN, TARGET> {
        private Binder<BEAN> binder;
        private final HasValue<?, FIELDVALUE> field;
        private BindingValidationStatusHandler statusHandler;
        private boolean isStatusHandlerChanged;
        private Binding<BEAN, TARGET> binding;
        private boolean bound;
        private Converter<FIELDVALUE, ?> converterValidatorChain;
        private boolean asRequiredSet;

        protected BindingBuilderImpl(Binder<BEAN> binder, HasValue<?, FIELDVALUE> field, Converter<FIELDVALUE, TARGET> converterValidatorChain, BindingValidationStatusHandler statusHandler) {
            this.field = field;
            this.binder = binder;
            this.converterValidatorChain = converterValidatorChain;
            this.statusHandler = statusHandler;
        }

        Converter<FIELDVALUE, ?> getConverterValidatorChain() {
            return this.converterValidatorChain;
        }

        @Override
        public Binding<BEAN, TARGET> bind(ValueProvider<BEAN, TARGET> getter, Setter<BEAN, TARGET> setter) {
            this.checkUnbound();
            Objects.requireNonNull(getter, "getter cannot be null");
            BindingImpl binding = new BindingImpl(this, getter, setter);
            ((Binder)this.getBinder()).bindings.add(binding);
            if (this.getBinder().getBean() != null) {
                binding.initFieldValue(this.getBinder().getBean(), true);
            }
            if (setter == null) {
                binding.getField().setReadOnly(true);
            }
            ((Binder)this.getBinder()).fireStatusChangeEvent(false);
            this.bound = true;
            if (((Binder)this.getBinder()).incompleteBindings != null) {
                ((Binder)this.getBinder()).incompleteBindings.remove(this.getField());
            }
            this.binding = binding;
            return binding;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Binding<BEAN, TARGET> bind(String propertyName) {
            Objects.requireNonNull(propertyName, "Property name cannot be null");
            this.checkUnbound();
            PropertyDefinition definition = ((Binder)this.getBinder()).propertySet.getProperty(propertyName).orElseThrow(() -> new IllegalArgumentException("Could not resolve property name " + propertyName + " from " + ((Binder)this.getBinder()).propertySet));
            ValueProvider getter = definition.getGetter();
            Setter setter = definition.getSetter().orElse(null);
            if (setter == null) {
                BindingBuilderImpl.getLogger().info(propertyName + " does not have an accessible setter");
            }
            BindingBuilder finalBinding = this.withConverter(this.createConverter(definition.getType()), false);
            finalBinding = this.getBinder().configureBinding(finalBinding, definition);
            try {
                Binding<BEAN, Object> binding = finalBinding.bind(getter, setter);
                ((Binder)this.getBinder()).boundProperties.put(propertyName, binding);
                this.binding = binding;
                Binding<BEAN, Object> binding2 = binding;
                return binding2;
            }
            finally {
                if (((Binder)this.getBinder()).incompleteMemberFieldBindings != null) {
                    ((Binder)this.getBinder()).incompleteMemberFieldBindings.remove(this.getField());
                }
            }
        }

        private Converter<TARGET, Object> createConverter(Class<?> getterType) {
            return Converter.from(getterType::cast, (SerializableFunction & Serializable)propertyValue -> propertyValue, (SerializableFunction<Exception, String>)(SerializableFunction & Serializable)exception -> {
                throw new RuntimeException((Throwable)exception);
            });
        }

        @Override
        public BindingBuilder<BEAN, TARGET> withValidator(Validator<? super TARGET> validator) {
            this.checkUnbound();
            Objects.requireNonNull(validator, "validator cannot be null");
            Validator<Object> wrappedValidator = (value, context) -> {
                if (this.getBinder().isValidatorsDisabled() || this.binding != null && this.binding.isValidatorsDisabled()) {
                    return ValidationResult.ok();
                }
                return validator.apply((TARGET)value, context);
            };
            this.converterValidatorChain = this.converterValidatorChain.chain(new ValidatorAsConverter<Object>(wrappedValidator));
            return this;
        }

        @Override
        public <NEWTARGET> BindingBuilder<BEAN, NEWTARGET> withConverter(Converter<TARGET, NEWTARGET> converter) {
            return this.withConverter(converter, true);
        }

        @Override
        public BindingBuilder<BEAN, TARGET> withValidationStatusHandler(BindingValidationStatusHandler handler) {
            this.checkUnbound();
            Objects.requireNonNull(handler, "handler cannot be null");
            if (this.isStatusHandlerChanged) {
                throw new IllegalStateException("A " + BindingValidationStatusHandler.class.getSimpleName() + " has already been set");
            }
            this.isStatusHandlerChanged = true;
            this.statusHandler = handler;
            return this;
        }

        @Override
        public BindingBuilder<BEAN, TARGET> asRequired(ErrorMessageProvider errorMessageProvider) {
            return this.asRequired(Validator.from((SerializablePredicate & Serializable)value -> !Objects.equals(value, this.field.getEmptyValue()), errorMessageProvider));
        }

        @Override
        public BindingBuilder<BEAN, TARGET> asRequired(Validator<TARGET> customRequiredValidator) {
            this.checkUnbound();
            this.asRequiredSet = true;
            this.field.setRequiredIndicatorVisible(true);
            return this.withValidator((value, context) -> {
                if (!this.field.isRequiredIndicatorVisible()) {
                    return ValidationResult.ok();
                }
                return customRequiredValidator.apply(value, context);
            });
        }

        protected <NEWTARGET> BindingBuilder<BEAN, NEWTARGET> withConverter(Converter<TARGET, NEWTARGET> converter, boolean resetNullRepresentation) {
            this.checkUnbound();
            Objects.requireNonNull(converter, "converter cannot be null");
            if (resetNullRepresentation) {
                ((ConverterDelegate)((Binder)this.getBinder()).initialConverters.get(this.field)).setIdentity();
            }
            this.converterValidatorChain = this.converterValidatorChain.chain(converter);
            return this;
        }

        protected Binder<BEAN> getBinder() {
            return this.binder;
        }

        protected void checkUnbound() {
            if (this.bound) {
                throw new IllegalStateException("cannot modify binding: already bound to a property");
            }
        }

        @Override
        public HasValue<?, FIELDVALUE> getField() {
            return this.field;
        }

        private static final Logger getLogger() {
            return LoggerFactory.getLogger((String)Binder.class.getName());
        }
    }

    public static interface BindingBuilder<BEAN, TARGET>
    extends Serializable {
        public HasValue<?, ?> getField();

        public Binding<BEAN, TARGET> bind(ValueProvider<BEAN, TARGET> var1, Setter<BEAN, TARGET> var2);

        public Binding<BEAN, TARGET> bind(String var1);

        public BindingBuilder<BEAN, TARGET> withValidator(Validator<? super TARGET> var1);

        default public BindingBuilder<BEAN, TARGET> withValidator(SerializablePredicate<? super TARGET> predicate, String message) {
            return this.withValidator(Validator.from(predicate, message));
        }

        default public BindingBuilder<BEAN, TARGET> withValidator(SerializablePredicate<? super TARGET> predicate, String message, ErrorLevel errorLevel) {
            return this.withValidator(Validator.from(predicate, message, errorLevel));
        }

        default public BindingBuilder<BEAN, TARGET> withValidator(SerializablePredicate<? super TARGET> predicate, ErrorMessageProvider errorMessageProvider) {
            return this.withValidator(Validator.from(predicate, errorMessageProvider));
        }

        default public BindingBuilder<BEAN, TARGET> withValidator(SerializablePredicate<? super TARGET> predicate, ErrorMessageProvider errorMessageProvider, ErrorLevel errorLevel) {
            return this.withValidator(Validator.from(predicate, errorMessageProvider, errorLevel));
        }

        public <NEWTARGET> BindingBuilder<BEAN, NEWTARGET> withConverter(Converter<TARGET, NEWTARGET> var1);

        default public <NEWTARGET> BindingBuilder<BEAN, NEWTARGET> withConverter(SerializableFunction<TARGET, NEWTARGET> toModel, SerializableFunction<NEWTARGET, TARGET> toPresentation) {
            return this.withConverter(Converter.from(toModel, toPresentation, (SerializableFunction<Exception, String>)((SerializableFunction & Serializable)Throwable::getMessage)));
        }

        default public <NEWTARGET> BindingBuilder<BEAN, NEWTARGET> withConverter(SerializableFunction<TARGET, NEWTARGET> toModel, SerializableFunction<NEWTARGET, TARGET> toPresentation, String errorMessage) {
            return this.withConverter(Converter.from(toModel, toPresentation, (SerializableFunction<Exception, String>)(SerializableFunction & Serializable)exception -> errorMessage));
        }

        default public BindingBuilder<BEAN, TARGET> withNullRepresentation(TARGET nullRepresentation) {
            return this.withConverter((SerializableFunction & Serializable)fieldValue -> Objects.equals(fieldValue, nullRepresentation) ? null : fieldValue, (SerializableFunction & Serializable)modelValue -> Objects.isNull(modelValue) ? nullRepresentation : modelValue);
        }

        default public BindingBuilder<BEAN, TARGET> withStatusLabel(HasText label) {
            return this.withValidationStatusHandler((BindingValidationStatusHandler & Serializable)status -> {
                label.setText(status.getMessage().orElse(""));
                Binder.setVisible(label, status.isError());
            });
        }

        public BindingBuilder<BEAN, TARGET> withValidationStatusHandler(BindingValidationStatusHandler var1);

        default public BindingBuilder<BEAN, TARGET> asRequired(String errorMessage) {
            return this.asRequired((ErrorMessageProvider & Serializable)(ValueContext context) -> errorMessage);
        }

        default public BindingBuilder<BEAN, TARGET> asRequired() {
            return this.asRequired((ErrorMessageProvider & Serializable)(ValueContext context) -> "");
        }

        public BindingBuilder<BEAN, TARGET> asRequired(ErrorMessageProvider var1);

        public BindingBuilder<BEAN, TARGET> asRequired(Validator<TARGET> var1);
    }

    public static interface Binding<BEAN, TARGET>
    extends Serializable {
        public HasValue<?, ?> getField();

        default public BindingValidationStatus<TARGET> validate() {
            return this.validate(true);
        }

        public BindingValidationStatus<TARGET> validate(boolean var1);

        public BindingValidationStatusHandler getValidationStatusHandler();

        public void unbind();

        public void read(BEAN var1);

        public void setReadOnly(boolean var1);

        public boolean isReadOnly();

        public ValueProvider<BEAN, TARGET> getGetter();

        public Setter<BEAN, TARGET> getSetter();

        public void setAsRequiredEnabled(boolean var1);

        public boolean isAsRequiredEnabled();

        public void setValidatorsDisabled(boolean var1);

        public boolean isValidatorsDisabled();

        public void setConvertBackToPresentation(boolean var1);

        public boolean isConvertBackToPresentation();
    }
}

