/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.QueryTrace;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.Range;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class DataCommunicator<T>
implements Serializable {
    private final DataGenerator<T> dataGenerator;
    private final ArrayUpdater arrayUpdater;
    private final SerializableConsumer<JsonArray> dataUpdater;
    private final StateNode stateNode;
    private DataKeyMapper<T> keyMapper = new KeyMapper<T>();
    private Range requestedRange = Range.between((int)0, (int)0);
    private int activeStart = 0;
    private List<String> activeKeyOrder = Collections.emptyList();
    private int assumedSize;
    private boolean resendEntireRange = true;
    private boolean assumeEmptyClient = true;
    private int nextUpdateId = 0;
    private final HashMap<Integer, Set<String>> passivatedByUpdate = new HashMap();
    private final HashSet<Integer> confirmedUpdates = new HashSet();
    private DataProvider<T, ?> dataProvider = DataProvider.ofItems(new Object[0]);
    private Object filter;
    private SerializableComparator<T> inMemorySorting;
    private final ArrayList<QuerySortOrder> backEndSorting = new ArrayList();
    private Registration dataProviderUpdateRegistration;
    private HashSet<T> updatedData = new HashSet();
    private SerializableConsumer<ExecutionContext> flushRequest;
    private SerializableConsumer<ExecutionContext> flushUpdatedDataRequest;

    public DataCommunicator(DataGenerator<T> dataGenerator, ArrayUpdater arrayUpdater, SerializableConsumer<JsonArray> dataUpdater, StateNode stateNode) {
        this.dataGenerator = dataGenerator;
        this.arrayUpdater = arrayUpdater;
        this.dataUpdater = dataUpdater;
        this.stateNode = stateNode;
        stateNode.addAttachListener(this::handleAttach);
        stateNode.addDetachListener(this::handleDetach);
        this.requestFlush();
    }

    public void setRequestedRange(int start, int length) {
        this.requestedRange = Range.withLength((int)start, (int)length);
        this.requestFlush();
    }

    public void reset() {
        this.resendEntireRange = true;
        this.dataGenerator.destroyAllData();
        this.updatedData.clear();
        this.requestFlush();
    }

    public void refresh(T data) {
        Objects.requireNonNull(data, "DataCommunicator can not refresh null object");
        this.getKeyMapper().refresh(data);
        this.dataGenerator.refreshData(data);
        this.updatedData.add(data);
        this.requestFlushUpdatedData();
    }

    public void confirmUpdate(int updateId) {
        this.confirmedUpdates.add(updateId);
        this.requestFlush();
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    public <F> SerializableConsumer<F> setDataProvider(DataProvider<T, F> dataProvider, F initialFilter) {
        Objects.requireNonNull(dataProvider, "data provider cannot be null");
        this.filter = initialFilter;
        this.handleDetach();
        this.reset();
        this.getKeyMapper().removeAll();
        this.dataProvider = dataProvider;
        this.getKeyMapper().setIdentifierGetter(dataProvider::getId);
        this.handleAttach();
        return (SerializableConsumer & Serializable)filter -> {
            if (this.dataProvider != dataProvider) {
                throw new IllegalStateException("Filter slot is no longer valid after data provider has been changed");
            }
            if (!Objects.equals(this.filter, filter)) {
                this.filter = filter;
                this.reset();
            }
        };
    }

    public DataKeyMapper<T> getKeyMapper() {
        return this.keyMapper;
    }

    protected void setKeyMapper(DataKeyMapper<T> keyMapper) {
        this.keyMapper = keyMapper;
    }

    public void setInMemorySorting(SerializableComparator<T> comparator) {
        this.inMemorySorting = comparator;
        this.reset();
    }

    public SerializableComparator<T> getInMemorySorting() {
        return this.inMemorySorting;
    }

    public void setBackEndSorting(List<QuerySortOrder> sortOrder) {
        this.backEndSorting.clear();
        this.backEndSorting.addAll(sortOrder);
        this.reset();
    }

    public List<QuerySortOrder> getBackEndSorting() {
        return Collections.unmodifiableList(this.backEndSorting);
    }

    protected int getDataProviderSize() {
        return this.getDataProvider().size(new Query(this.getFilter()));
    }

    protected Object getFilter() {
        return this.filter;
    }

    protected Stream<T> fetchFromProvider(int offset, int limit) {
        QueryTrace<T, Object> query = new QueryTrace<T, Object>(offset, limit, (List<QuerySortOrder>)this.backEndSorting, this.inMemorySorting, this.filter);
        Stream<Object> stream = this.getDataProvider().fetch(query);
        if (stream.isParallel()) {
            LoggerFactory.getLogger(DataCommunicator.class).debug("Data provider {} has returned parallel stream on 'fetch' call", this.getDataProvider().getClass());
            stream = stream.collect(Collectors.toList()).stream();
            assert (!stream.isParallel());
        }
        SizeVerifier verifier = new SizeVerifier(limit);
        stream = stream.peek(verifier);
        if (!query.isLimitCalled()) {
            throw new IllegalStateException(this.getInvalidContractMessage("getLimit"));
        }
        if (!query.isOffsetCalled()) {
            throw new IllegalStateException(this.getInvalidContractMessage("getOffset"));
        }
        return stream;
    }

    private String getInvalidContractMessage(String method) {
        return String.format("The data provider hasn't ever called %s() method on the provided query. It means that the the data provider breaks the contract and the returned stream contains unxpected data.", method);
    }

    private void handleAttach() {
        this.dataProviderUpdateRegistration = this.getDataProvider().addDataProviderListener(event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                this.handleDataRefreshEvent((DataChangeEvent.DataRefreshEvent)event);
            } else {
                this.reset();
            }
        });
        this.requestFlush();
    }

    protected void handleDataRefreshEvent(DataChangeEvent.DataRefreshEvent<T> event) {
        this.refresh(event.getItem());
    }

    private void handleDetach() {
        this.dataGenerator.destroyAllData();
        if (this.dataProviderUpdateRegistration != null) {
            this.dataProviderUpdateRegistration.remove();
            this.dataProviderUpdateRegistration = null;
        }
    }

    private void requestFlush() {
        if (this.flushRequest == null) {
            this.flushRequest = (SerializableConsumer & Serializable)context -> {
                if (!context.isClientSideInitialized()) {
                    this.reset();
                    this.arrayUpdater.initialize();
                }
                this.flush();
                this.flushRequest = null;
            };
            this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, this.flushRequest));
        }
    }

    private void requestFlushUpdatedData() {
        if (this.flushUpdatedDataRequest == null) {
            this.flushUpdatedDataRequest = (SerializableConsumer & Serializable)context -> {
                this.flushUpdatedData();
                this.flushUpdatedDataRequest = null;
            };
            this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, this.flushUpdatedDataRequest));
        }
    }

    private void flush() {
        Range effectiveRequested;
        HashSet<String> oldActive = new HashSet<String>(this.activeKeyOrder);
        Range previousActive = Range.withLength((int)this.activeStart, (int)this.activeKeyOrder.size());
        if (this.resendEntireRange) {
            this.assumedSize = this.getDataProviderSize();
        }
        this.resendEntireRange |= !previousActive.intersects(effectiveRequested = this.requestedRange.restrictTo(Range.withLength((int)0, (int)this.assumedSize))) && (!previousActive.isEmpty() || !effectiveRequested.isEmpty());
        Activation activation = this.collectKeysToFlush(previousActive, effectiveRequested);
        if (activation.isSizeRecheckNeeded()) {
            this.assumedSize = this.getDataProviderSize();
            effectiveRequested = this.requestedRange.restrictTo(Range.withLength((int)0, (int)this.assumedSize));
        }
        this.activeKeyOrder = activation.getActiveKeys();
        this.activeStart = effectiveRequested.getStart();
        ArrayUpdater.Update update = this.arrayUpdater.startUpdate(this.assumedSize);
        boolean updated = this.collectChangesToSend(previousActive, effectiveRequested, update);
        this.resendEntireRange = false;
        this.assumeEmptyClient = false;
        this.passivateInactiveKeys(oldActive, update, updated);
        this.unregisterPassivatedKeys();
    }

    private void flushUpdatedData() {
        if (this.updatedData.isEmpty()) {
            return;
        }
        this.dataUpdater.accept(this.updatedData.stream().map(this::generateJson).collect(JsonUtils.asArray()));
        this.updatedData.clear();
    }

    private void unregisterPassivatedKeys() {
        if (!this.confirmedUpdates.isEmpty()) {
            this.confirmedUpdates.forEach(this::doUnregister);
            this.confirmedUpdates.clear();
        }
    }

    private void doUnregister(Integer updateId) {
        Set<String> passivated = this.passivatedByUpdate.remove(updateId);
        if (passivated != null) {
            passivated.forEach(key -> {
                T item = this.keyMapper.get((String)key);
                if (item != null) {
                    this.dataGenerator.destroyData(item);
                    this.keyMapper.remove(item);
                }
            });
        }
    }

    private void passivateInactiveKeys(Set<String> oldActive, ArrayUpdater.Update update, boolean updated) {
        if (updated) {
            int updateId = this.nextUpdateId++;
            update.commit(updateId);
            oldActive.removeAll(this.activeKeyOrder);
            if (!oldActive.isEmpty()) {
                this.passivatedByUpdate.put(updateId, oldActive);
            }
        }
    }

    private boolean collectChangesToSend(Range previousActive, Range effectiveRequested, ArrayUpdater.Update update) {
        boolean updated = false;
        if (this.assumeEmptyClient || this.resendEntireRange) {
            if (!this.assumeEmptyClient) {
                update.clear(previousActive.getStart(), previousActive.length());
            }
            update.set(this.activeStart, this.getJsonItems(effectiveRequested));
            updated = true;
        } else if (!previousActive.equals((Object)effectiveRequested)) {
            DataCommunicator.withMissing(previousActive, effectiveRequested, range -> update.clear(range.getStart(), range.length()));
            DataCommunicator.withMissing(effectiveRequested, previousActive, range -> update.set(range.getStart(), this.getJsonItems((Range)range)));
            updated = true;
        }
        return updated;
    }

    private Activation collectKeysToFlush(Range previousActive, Range effectiveRequested) {
        if (this.resendEntireRange) {
            return this.activate(effectiveRequested);
        }
        ArrayList<String> newActiveKeyOrder = new ArrayList<String>();
        boolean sizeRecheckNeeded = false;
        Range[] partitionWith = effectiveRequested.partitionWith(previousActive);
        Activation activation = this.activate(partitionWith[0]);
        newActiveKeyOrder.addAll(activation.getActiveKeys());
        sizeRecheckNeeded |= activation.isSizeRecheckNeeded();
        Range overlap = partitionWith[1].offsetBy(-this.activeStart);
        if (overlap.getStart() < 0) {
            return Activation.empty();
        }
        newActiveKeyOrder.addAll(this.activeKeyOrder.subList(overlap.getStart(), overlap.getEnd()));
        activation = this.activate(partitionWith[2]);
        newActiveKeyOrder.addAll(activation.getActiveKeys());
        return new Activation(newActiveKeyOrder, sizeRecheckNeeded |= activation.isSizeRecheckNeeded());
    }

    private List<JsonValue> getJsonItems(Range range) {
        return range.stream().mapToObj(index -> this.activeKeyOrder.get(index - this.activeStart)).map(this.keyMapper::get).map(this::generateJson).collect(Collectors.toList());
    }

    private static final void withMissing(Range expected, Range actual, Consumer<Range> action) {
        Range[] partition = expected.partitionWith(actual);
        DataCommunicator.applyIfNotEmpty(partition[0], action);
        DataCommunicator.applyIfNotEmpty(partition[2], action);
    }

    private static final void applyIfNotEmpty(Range range, Consumer<Range> action) {
        if (!range.isEmpty()) {
            action.accept(range);
        }
    }

    private Activation activate(Range range) {
        if (range.isEmpty()) {
            return Activation.empty();
        }
        ArrayList<String> activeKeys = new ArrayList<String>(range.length());
        this.fetchFromProvider(range.getStart(), range.length()).forEach(bean -> {
            boolean mapperHasKey = this.keyMapper.has(bean);
            String key = this.keyMapper.key(bean);
            if (mapperHasKey) {
                this.keyMapper.refresh(bean);
                this.passivatedByUpdate.values().stream().forEach(set -> set.remove(key));
            }
            activeKeys.add(key);
        });
        boolean needsSizeRecheck = activeKeys.size() < range.length();
        return new Activation(activeKeys, needsSizeRecheck);
    }

    private JsonValue generateJson(T item) {
        JsonObject json = Json.createObject();
        json.put("key", this.getKeyMapper().key(item));
        this.dataGenerator.generateData(item, json);
        return json;
    }

    private static class Activation
    implements Serializable {
        private final List<String> activeKeys;
        private final boolean sizeRecheckNeeded;

        public Activation(List<String> activeKeys, boolean sizeRecheckNeeded) {
            this.activeKeys = activeKeys;
            this.sizeRecheckNeeded = sizeRecheckNeeded;
        }

        public List<String> getActiveKeys() {
            return this.activeKeys;
        }

        public boolean isSizeRecheckNeeded() {
            return this.sizeRecheckNeeded;
        }

        public static Activation empty() {
            return new Activation(Collections.emptyList(), false);
        }
    }

    private static class SizeVerifier<T>
    implements Consumer<T>,
    Serializable {
        private int size;
        private final int limit;

        private SizeVerifier(int limit) {
            this.limit = limit;
        }

        @Override
        public void accept(T t) {
            ++this.size;
            if (this.size > this.limit) {
                throw new IllegalStateException(String.format("The number of items returned by the data provider exceeds the limit specified by the query (%d).", this.limit));
            }
        }
    }
}

