/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.AbstractComponentDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.RendererUtil;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public abstract class BasicRenderer<SOURCE, TARGET>
extends ComponentRenderer<Component, SOURCE> {
    private final ValueProvider<SOURCE, TARGET> valueProvider;

    protected BasicRenderer(ValueProvider<SOURCE, TARGET> valueProvider) {
        if (valueProvider == null) {
            throw new IllegalArgumentException("valueProvider may not be null");
        }
        this.valueProvider = valueProvider;
    }

    protected ValueProvider<SOURCE, TARGET> getValueProvider() {
        return this.valueProvider;
    }

    @Override
    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, Element contentTemplate) {
        SimpleValueRendering rendering = new SimpleValueRendering(keyMapper == null ? null : keyMapper::key);
        rendering.setTemplateElement(contentTemplate);
        this.setupTemplate(container, rendering, keyMapper);
        return rendering;
    }

    private void setupTemplate(Element owner, SimpleValueRendering rendering, DataKeyMapper<SOURCE> keyMapper) {
        owner.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> this.setupTemplateWhenAttached(owner, rendering, keyMapper));
    }

    private void setupTemplateWhenAttached(Element owner, SimpleValueRendering rendering, DataKeyMapper<SOURCE> keyMapper) {
        Element templateElement = rendering.getTemplateElement();
        owner.appendChild(new Element[]{templateElement});
        if (keyMapper != null) {
            String propertyName = this.getTemplatePropertyName(rendering);
            templateElement.setProperty("innerHTML", this.getTemplateForProperty("[[item." + propertyName + "]]", rendering));
            rendering.setPropertyName(propertyName);
            RendererUtil.registerEventHandlers(this, templateElement, owner, keyMapper::get);
        } else {
            String value = this.getFormattedValue(null);
            templateElement.setProperty("innerHTML", this.getTemplateForProperty(value, rendering));
            rendering.setContainer(owner);
        }
    }

    protected String getTemplatePropertyName(Rendering<SOURCE> context) {
        Objects.requireNonNull(context, "The context should not be null");
        Element templateElement = context.getTemplateElement();
        if (templateElement == null) {
            throw new IllegalArgumentException("The provided rendering doesn't contain a template element");
        }
        return "_" + this.getClass().getSimpleName() + "_" + templateElement.getNode().getId();
    }

    protected String getTemplateForProperty(String property, Rendering<SOURCE> context) {
        return property == null ? "" : property;
    }

    @Override
    public Component createComponent(SOURCE item) {
        Element span = ElementFactory.createSpan((String)this.getFormattedValue(this.valueProvider.apply(item)));
        return ComponentUtil.componentFromElement((Element)span, Component.class, (boolean)true);
    }

    protected String getFormattedValue(TARGET object) {
        return String.valueOf(object);
    }

    class SimpleValueRendering
    extends AbstractComponentDataGenerator<SOURCE>
    implements Rendering<SOURCE> {
        private final ValueProvider<SOURCE, String> keyMapper;
        private Element templateElement;
        private String propertyName;
        private Element container;

        public SimpleValueRendering(ValueProvider<SOURCE, String> keyMapper) {
            this.keyMapper = keyMapper;
        }

        public void setContainer(Element container) {
            this.container = container;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public void setTemplateElement(Element templateElement) {
            this.templateElement = templateElement;
        }

        @Override
        public Element getTemplateElement() {
            return this.templateElement;
        }

        @Override
        public Optional<DataGenerator<SOURCE>> getDataGenerator() {
            return Optional.of(this);
        }

        @Override
        public void generateData(SOURCE item, JsonObject jsonObject) {
            if (this.propertyName != null) {
                String value = BasicRenderer.this.getFormattedValue(BasicRenderer.this.valueProvider.apply(item));
                if (value != null) {
                    jsonObject.put(this.propertyName, value);
                }
                jsonObject.put(this.propertyName + "_disabled", !this.templateElement.isEnabled());
            } else if (this.container != null) {
                String itemKey = this.getItemKey((SOURCE)item);
                Component component = this.createComponent((SOURCE)item);
                this.registerRenderedComponent(itemKey, component);
            }
        }

        @Override
        public void refreshData(SOURCE item) {
            if (this.propertyName != null) {
                return;
            }
            super.refreshData(item);
        }

        @Override
        protected String getItemKey(SOURCE item) {
            if (this.keyMapper == null) {
                return null;
            }
            return (String)this.keyMapper.apply(item);
        }

        @Override
        protected Component createComponent(SOURCE item) {
            return BasicRenderer.this.createComponent(item);
        }

        @Override
        protected Element getContainer() {
            return this.container;
        }
    }
}

