/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.selection;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.shared.Registration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MultiSelect<C extends Component, T>
extends HasValueAndElement<AbstractField.ComponentValueChangeEvent<C, Set<T>>, Set<T>> {
    default public void select(T ... items) {
        Objects.requireNonNull(items);
        Stream.of(items).forEach(Objects::requireNonNull);
        this.updateSelection(new LinkedHashSet<T>(Arrays.asList(items)), Collections.emptySet());
    }

    default public void deselect(T ... items) {
        Objects.requireNonNull(items);
        Stream.of(items).forEach(Objects::requireNonNull);
        this.updateSelection(Collections.emptySet(), new LinkedHashSet<T>(Arrays.asList(items)));
    }

    public void updateSelection(Set<T> var1, Set<T> var2);

    public Set<T> getSelectedItems();

    default public void deselectAll() {
        this.getSelectedItems().forEach(xva$0 -> this.deselect(xva$0));
    }

    default public boolean isSelected(T item) {
        return this.getSelectedItems().contains(item);
    }

    public Registration addSelectionListener(MultiSelectionListener<C, T> var1);

    default public Set<T> getEmptyValue() {
        return Collections.emptySet();
    }

    default public Set<T> getValue() {
        return this.getSelectedItems();
    }

    default public void setValue(Set<T> value) {
        Objects.requireNonNull(value);
        Set copy = value.stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        this.updateSelection(copy, new LinkedHashSet<T>(this.getSelectedItems()));
    }
}

