import { ElementPart, PropertyPart } from 'lit';
import { PartInfo } from 'lit/directive.js';
import { AbstractModel } from './Models';
interface Field {
    required: boolean;
    invalid: boolean;
    errorMessage: string;
    value: any;
}
interface FieldState extends Field {
    name: string;
    strategy: FieldStrategy;
}
export interface FieldStrategy extends Field {
    element: Element;
}
export declare abstract class AbstractFieldStrategy implements FieldStrategy {
    element: Element & Field;
    abstract required: boolean;
    abstract invalid: boolean;
    constructor(element: Element & Field);
    validate: () => Promise<never[]>;
    get value(): any;
    set value(value: any);
    set errorMessage(_: string);
    setAttribute(key: string, val: any): void;
}
export declare class VaadinFieldStrategy extends AbstractFieldStrategy {
    set required(value: boolean);
    set invalid(value: boolean);
    set errorMessage(value: string);
}
export declare class GenericFieldStrategy extends AbstractFieldStrategy {
    set required(value: boolean);
    set invalid(value: boolean);
}
export declare class CheckedFieldStrategy extends GenericFieldStrategy {
    set value(val: any);
    get value(): any;
}
export declare class ComboBoxFieldStrategy extends VaadinFieldStrategy {
    get value(): any;
    set value(val: any);
}
export declare class SelectedFieldStrategy extends GenericFieldStrategy {
    set value(val: any);
    get value(): any;
}
export declare function getDefaultFieldStrategy(elm: any): FieldStrategy;
/**
 * Binds a form field component into a model.
 *
 * Example usage:
 *
 * ```
 * <vaadin-text-field ...="${field(model.name)}">
 * </vaadin-text-field>
 * ```
 */
export declare const field: (model: AbstractModel<any>, effect?: ((element: Element) => void) | undefined) => import("lit-html/directive").DirectiveResult<{
    new (partInfo: PartInfo): {
        fieldState?: FieldState | undefined;
        render(model: AbstractModel<any>, effect?: ((element: Element) => void) | undefined): symbol;
        update(part: PropertyPart | ElementPart, [model, effect]: [model: AbstractModel<any>, effect?: ((element: Element) => void) | undefined]): symbol;
        readonly _$isConnected: boolean;
    };
}>;
export {};
