package VIEW_PACKAGE;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.theme.lumo.LumoUtility;

import java.util.Arrays;
import java.util.List;

public class StubView extends Div implements AfterNavigationObserver {

    Grid<Person> grid = new Grid<>();

    public StubView() {
        setSizeFull();
        grid.setHeight("100%");
        grid.addThemeVariants(GridVariant.LUMO_NO_BORDER, GridVariant.LUMO_NO_ROW_BORDERS);
        grid.addComponentColumn(person -> createCard(person));
        add(grid);
    }

    private HorizontalLayout createCard(Person person) {
        HorizontalLayout card = new HorizontalLayout();
        card.addClassName("card");
        card.setSpacing(false);
        card.addClassNames(LumoUtility.Background.BASE, LumoUtility.BorderRadius.MEDIUM, LumoUtility.BoxShadow.XSMALL, LumoUtility.Padding.MEDIUM, LumoUtility.Gap.SMALL);

        Image image = new Image();
        image.setSrc(person.getImage());
        image.addClassNames(LumoUtility.Flex.SHRINK_NONE);
        image.getStyle().setWidth("var(--lumo-size-m)")
                .setHeight("var(--lumo-size-m)")
                .setMarginRight("calc(var(--lumo-space-s) * 1.5)")
                .setBorderRadius("50%");

        VerticalLayout description = new VerticalLayout();
        description.addClassName("description");
        description.setSpacing(false);
        description.setPadding(false);
        HorizontalLayout header = new HorizontalLayout();
        header.setSpacing(false);
        header.getThemeList().add("spacing-s");
        header.addClassName(LumoUtility.AlignItems.BASELINE);
        Span name = new Span(person.getName());
        name.addClassNames(LumoUtility.FontSize.SMALL, LumoUtility.FontWeight.NORMAL, LumoUtility.Margin.Right.SMALL);
        Span date = new Span(person.getDate());
        date.addClassNames(LumoUtility.TextColor.TERTIARY, LumoUtility.FontSize.XSMALL);
        header.add(name, date);
        Span post = new Span(person.getPost());
        post.addClassNames(LumoUtility.FontSize.SMALL, LumoUtility.FontSize.SMALL, LumoUtility.Margin.Bottom.SMALL, LumoUtility.Whitespace.NORMAL, LumoUtility.TextColor.SECONDARY);
        HorizontalLayout actions = new HorizontalLayout();
        actions.addClassNames(LumoUtility.AlignItems.CENTER, LumoUtility.Gap.SMALL, LumoUtility.TextColor.SECONDARY, LumoUtility.FontSize.SMALL, LumoUtility.Gap.SMALL);
        Icon likeIcon = VaadinIcon.HEART.create();
        likeIcon.addClassName("icon");
        Span likes = new Span(person.getLikes());
        likes.addClassName("likes");
        Icon commentIcon = VaadinIcon.COMMENT.create();
        commentIcon.addClassName("icon");
        Span comments = new Span(person.getComments());
        comments.addClassName("comments");
        Icon shareIcon = VaadinIcon.CONNECT.create();
        shareIcon.addClassName("icon");
        Span shares = new Span(person.getShares());
        shares.addClassName("shares");
        actions.add(likeIcon, likes, commentIcon, comments, shareIcon, shares);
        description.add(header, post, actions);
        card.add(image, description);
        return card;
    }

    @Override
    public void afterNavigation(AfterNavigationEvent event) {
        // Set some data when this view is displayed.
        List<Person> persons = //
                Arrays.//
                        asList(createPerson("https://randomuser.me/api/portraits/men/42.jpg", "John Smith", "May 8", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/women/42.jpg", "Abagail Libbie", "May 3", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/men/24.jpg", "Alberto Raya", "May 3", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/women/24.jpg", "Emmy Elsner", "Apr 22", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/men/76.jpg", "Alf Huncoot", "Apr 21", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/women/76.jpg", "Lidmila Vilensky", "Apr 17", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/men/94.jpg", "Jarrett Cawsey", "Apr 17", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/women/94.jpg", "Tania Perfilyeva", "Mar 8", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/men/16.jpg", "Ivan Polo", "Mar 5", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/women/16.jpg", "Emelda Scandroot", "Mar 5", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/men/67.jpg", "Marcos Sá", "Mar 4", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"), createPerson("https://randomuser.me/api/portraits/women/67.jpg", "Jacqueline Asong", "Mar 2", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"));
        grid.setItems(persons);
    }

    private static Person createPerson(String image, String name, String date, String post, String likes, String comments, String shares) {
        Person p = new Person();
        p.setImage(image);
        p.setName(name);
        p.setDate(date);
        p.setPost(post);
        p.setLikes(likes);
        p.setComments(comments);
        p.setShares(shares);
        return p;
    }

    public static class Person {

        private String image;

        private String name;

        private String date;

        private String post;

        private String likes;

        private String comments;

        private String shares;

        public Person() {
        }

        public String getImage() {
            return image;
        }

        public void setImage(String image) {
            this.image = image;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDate() {
            return date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getPost() {
            return post;
        }

        public void setPost(String post) {
            this.post = post;
        }

        public String getLikes() {
            return likes;
        }

        public void setLikes(String likes) {
            this.likes = likes;
        }

        public String getComments() {
            return comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getShares() {
            return shares;
        }

        public void setShares(String shares) {
            this.shares = shares;
        }
    }
}
