/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.dom.ElementStateProvider;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRewriterCopyPasteHandler {
    private static final String COMBOBOX_CLASS_NAME = "com.vaadin.flow.component.combobox.ComboBox";
    private static final String MENU_BAR_COMPONENT_CLASS_NAME = "com.vaadin.flow.component.menubar.MenuBar";
    private static final String MENU_BAR_ROOT_ITEM_CLASS_NAME = "com.vaadin.flow.component.menubar.MenuBarRootItem";
    private static final String ACCORDION_PANEL_CLASS_NAME = "com.vaadin.flow.component.accordion.AccordionPanel";
    private static final String VALUE_PROPERTY_KEY = "value";
    private static final String INVALID_PROPERTY_KEY = "invalid";
    private static final String ERROR_MESSAGE_PROPERTY_KEY = "errorMessage";
    private static final String ENABLED_PROPERTY_KEY = "enabled";
    private static final String INDETERMINATE_PROPERTY_KEY = "indeterminate";
    private static final String CHECKED_PROPERTY_KEY = "checked";
    private static final String AUTO_FOCUS_PROPERTY_KEY = "autofocus";
    private static final String REQUIRED_PROPERTY_KEY = "required";
    private static final String OPENED_PROPERTY_KEY = "opened";
    private static final String ACCESSIBLE_NAME_REF = "accessibleNameRef";
    private static final String ACCESSIBLE_NAME = "accessibleName";
    private static final String REQUIRED_INDICATOR_VISIBLE = "requiredIndicatorVisible";
    private static final String READONLY = "readonly";
    private static final String READ_ONLY_CAMEL_CASE = "readOnly";
    private static final String MAX_ITEMS_VISIBLE = "maxItemsVisible";
    private final ProjectManager projectManager;

    public JavaRewriterCopyPasteHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public JavaComponent getCopiedJavaComponent(ComponentTypeAndSourceLocation componentTypeAndSourceLocation) throws IOException {
        Component component = componentTypeAndSourceLocation.component();
        ElementStateProvider stateProvider = component.getElement().getStateProvider();
        Map<String, Object> properties = stateProvider.getPropertyNames(component.getElement().getNode()).collect(Collectors.toMap(k -> k, k -> stateProvider.getProperty(component.getElement().getNode(), k)));
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        this.addSuffixOrPrefixAttributes(component, properties);
        this.handleAccordionPanel(component, properties);
        this.addExtraProperties(component, properties);
        this.filterOutProperties(component, componentInfo, componentTypeAndSourceLocation.inheritanceChain(), properties);
        JavaComponent.Metadata copyMetadata = new JavaComponent.Metadata();
        try {
            copyMetadata = this.getCopyMetadata(componentTypeAndSourceLocation, componentInfo);
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
        }
        List<JavaComponent> childrenList = this.childrenFilter(componentTypeAndSourceLocation);
        return new JavaComponent(this.getTag(componentTypeAndSourceLocation.inheritanceChain()), this.getFlowComponentClassName(componentTypeAndSourceLocation.inheritanceChain()), properties, childrenList, copyMetadata);
    }

    private void handleAccordionPanel(Component component, Map<String, Object> properties) {
        boolean isAccordionPanel = ACCORDION_PANEL_CLASS_NAME.equals(component.getClass().getName());
        if (!isAccordionPanel) {
            return;
        }
        Class<?> detailsClass = component.getClass();
        Method getSummaryTextMethod = null;
        try {
            getSummaryTextMethod = detailsClass.getMethod("getSummaryText", new Class[0]);
            String summaryText = (String)getSummaryTextMethod.invoke((Object)component, new Object[0]);
            properties.put("summary", summaryText);
        }
        catch (IllegalAccessException e) {
            this.getLogger().debug("Could not access the method {}", (Object)getSummaryTextMethod.getName(), (Object)e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().debug("Could not invoke the method {}", (Object)getSummaryTextMethod.getName(), (Object)e);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().debug("Could not find the method getSummaryText", (Throwable)e);
        }
    }

    private List<JavaComponent> childrenFilter(ComponentTypeAndSourceLocation componentTypeAndSourceLocation) throws IOException {
        Component component = componentTypeAndSourceLocation.component();
        boolean isDateTimePicker = "com.vaadin.flow.component.datetimepicker.DateTimePicker".equals(component.getClass().getName());
        boolean isMenuBar = MENU_BAR_COMPONENT_CLASS_NAME.equals(component.getClass().getName());
        boolean isAccordionPanel = ACCORDION_PANEL_CLASS_NAME.equals(component.getClass().getName());
        if (isDateTimePicker) {
            return new ArrayList<JavaComponent>();
        }
        if (isMenuBar) {
            return new ArrayList<JavaComponent>();
        }
        if (isAccordionPanel) {
            ArrayList<JavaComponent> childrenListForAccordionPanel = new ArrayList<JavaComponent>();
            ComponentTypeAndSourceLocation divComponentTypeAndSourceLocation = componentTypeAndSourceLocation.children().stream().filter(c -> c.component().getClass().getName().equals("com.vaadin.flow.component.html.Div")).toList().get(0);
            for (ComponentTypeAndSourceLocation typeAndSourceLocation : divComponentTypeAndSourceLocation.children()) {
                JavaComponent copiedJavaComponent = this.getCopiedJavaComponent(typeAndSourceLocation);
                childrenListForAccordionPanel.add(copiedJavaComponent);
            }
            return childrenListForAccordionPanel;
        }
        ArrayList<JavaComponent> childrenList = new ArrayList<JavaComponent>();
        for (ComponentTypeAndSourceLocation typeAndSourceLocation : componentTypeAndSourceLocation.children()) {
            JavaComponent copiedJavaComponent = this.getCopiedJavaComponent(typeAndSourceLocation);
            childrenList.add(copiedJavaComponent);
        }
        return childrenList;
    }

    private String getFlowComponentClassName(List<Class<?>> inheritanceChain) {
        for (Class<?> aClass : inheritanceChain) {
            if (!aClass.getName().startsWith("com.vaadin.flow")) continue;
            return aClass.getName();
        }
        return inheritanceChain.get(0).getName();
    }

    private String getTag(List<Class<?>> inheritanceChain) {
        for (Class<?> aClass : inheritanceChain) {
            if (!aClass.getName().startsWith("com.vaadin.flow")) continue;
            return this.getTemplateTag(aClass.getSimpleName());
        }
        return this.getTemplateTag(inheritanceChain.get(0).getSimpleName());
    }

    private String getTemplateTag(String originalTag) {
        if ("RadioButtonGroup".equals(originalTag)) {
            return "RadioGroup";
        }
        if ("CheckBoxItem".equals(originalTag)) {
            return "Checkbox";
        }
        return originalTag;
    }

    private JavaComponent.Metadata getCopyMetadata(ComponentTypeAndSourceLocation componentTypeAndSourceLocation, ComponentInfo componentInfo) {
        JavaComponent.Metadata metadata = new JavaComponent.Metadata();
        if (componentTypeAndSourceLocation.getCreateLocationOrThrow().className().startsWith("com.vaadin.flow.data")) {
            return metadata;
        }
        Optional.ofNullable(componentInfo.localVariableName()).ifPresent(metadata::setLocalVariableName);
        Optional.ofNullable(componentInfo.fieldName()).ifPresent(metadata::setFieldVariableName);
        metadata.setOriginalClassName(componentTypeAndSourceLocation.component().getClass().getName());
        return metadata;
    }

    private void addExtraProperties(Component component, Map<String, Object> properties) {
        HasTheme hasTheme;
        HasText hasText;
        if (component.getClassName() != null && !component.getClassName().isEmpty()) {
            properties.put("className", component.getClassName());
        }
        if (component.getElement().hasAttribute("disabled")) {
            properties.put(ENABLED_PROPERTY_KEY, false);
        }
        if (component instanceof HasText && !"".equals((hasText = (HasText)component).getText())) {
            properties.put("text", hasText.getText());
        }
        if (component instanceof HasTheme && null != (hasTheme = (HasTheme)component).getThemeName()) {
            properties.put("themeName", hasTheme.getThemeName());
        }
        if (component instanceof HasEnabled) {
            HasEnabled hasEnabled = (HasEnabled)component;
            properties.put(ENABLED_PROPERTY_KEY, hasEnabled.isEnabled());
        }
        if (!component.getElement().getThemeList().isEmpty()) {
            properties.put("theme", String.join((CharSequence)" ", (Iterable<? extends CharSequence>)component.getElement().getThemeList()));
        }
        if ("com.vaadin.flow.component.html.Image".equals(component.getClass().getName())) {
            if (!properties.containsKey("src") && component.getElement().hasAttribute("src")) {
                properties.put("src", component.getElement().getAttribute("src"));
            }
            if (!properties.containsKey("alt") && component.getElement().hasAttribute("alt")) {
                properties.put("alt", component.getElement().getAttribute("alt"));
            }
        }
        if ("com.vaadin.flow.component.radiobutton.RadioButton".equals(component.getClass().getName()) && !properties.containsKey("label")) {
            component.getChildren().filter(child -> child.getClass().getName().equals("com.vaadin.flow.component.html.Label")).findFirst().ifPresent(label -> properties.put("label", label.getElement().getTextRecursively()));
        }
        if ("com.vaadin.flow.component.richtexteditor.RichTextEditor".equals(component.getClass().getName())) {
            this.getFieldValue(component, "currentMode").ifPresent(currentModeValue -> properties.put("valueChangeMode", currentModeValue));
        }
        if ("com.vaadin.flow.component.avatar.Avatar".equals(component.getClass().getName()) && component.getElement().hasAttribute("img")) {
            properties.put("img", component.getElement().getAttribute("img"));
        }
        if ("com.vaadin.flow.component.icon.Icon".equals(component.getClass().getName()) && component.getElement().hasAttribute("icon")) {
            properties.put("icon", component.getElement().getAttribute("icon"));
        }
        if ("com.vaadin.flow.component.html.Anchor".equals(component.getClass().getName()) && component.getElement().hasAttribute("href")) {
            properties.put("href", component.getElement().getAttribute("href"));
        }
        if ("com.vaadin.flow.component.avatar.AvatarGroup".equals(component.getClass().getName()) && properties.containsKey(MAX_ITEMS_VISIBLE)) {
            properties.put(MAX_ITEMS_VISIBLE, ((Double)properties.get(MAX_ITEMS_VISIBLE)).intValue());
        }
        this.addHasSizeProperties(component, properties);
        this.addMenuBarProperties(component, properties);
    }

    private void addHasSizeProperties(Component component, Map<String, Object> properties) {
        if (component instanceof HasSize) {
            HasSize hasSize = (HasSize)component;
            if (hasSize.getMaxHeight() != null) {
                properties.put("maxHeight", hasSize.getMaxHeight());
            }
            if (hasSize.getMinHeight() != null) {
                properties.put("minHeight", hasSize.getMinHeight());
            }
            if (hasSize.getMinWidth() != null) {
                properties.put("minWidth", hasSize.getMinWidth());
            }
            if (hasSize.getMaxWidth() != null) {
                properties.put("maxWidth", hasSize.getMaxWidth());
            }
            if (hasSize.getWidth() != null) {
                properties.put("width", hasSize.getWidth());
            }
            if (hasSize.getHeight() != null) {
                properties.put("height", hasSize.getHeight());
            }
        }
    }

    private void filterOutProperties(Component component, ComponentInfo componentInfo, List<Class<?>> inheritanceChain, Map<String, Object> properties) {
        HasEnabled hasEnabled;
        boolean textFieldBase = inheritanceChain.stream().anyMatch(clazz -> clazz.getName().equals("com.vaadin.flow.component.textfield.TextFieldBase"));
        boolean select = "com.vaadin.flow.component.select.Select".equals(component.getClass().getName());
        boolean checkboxGroup = "com.vaadin.flow.component.checkbox.CheckboxGroup".equals(component.getClass().getName());
        boolean radioButtonGroup = "com.vaadin.flow.component.radiobutton.RadioButtonGroup".equals(component.getClass().getName());
        boolean richTextEditor = "com.vaadin.flow.component.richtexteditor.RichTextEditor".equals(component.getClass().getName());
        boolean timePicker = "com.vaadin.flow.component.timepicker.TimePicker".equals(component.getClass().getName());
        boolean dateTimePicker = "com.vaadin.flow.component.datetimepicker.DateTimePicker".equals(component.getClass().getName());
        boolean checkbox = "com.vaadin.flow.component.checkbox.Checkbox".equals(component.getClass().getName());
        boolean accordion = "com.vaadin.flow.component.accordion.Accordion".equals(component.getClass().getName());
        boolean accordionPanel = ACCORDION_PANEL_CLASS_NAME.equals(component.getClass().getName());
        if (accordion || accordionPanel) {
            properties.remove(OPENED_PROPERTY_KEY);
        }
        if (textFieldBase || select || checkboxGroup || radioButtonGroup || timePicker || dateTimePicker) {
            properties.remove(VALUE_PROPERTY_KEY);
            properties.remove(INVALID_PROPERTY_KEY);
            properties.remove(ERROR_MESSAGE_PROPERTY_KEY);
            if (select) {
                properties.remove(OPENED_PROPERTY_KEY);
            }
        }
        if (richTextEditor) {
            properties.remove("htmlValue");
            properties.remove(VALUE_PROPERTY_KEY);
        }
        if ("com.vaadin.flow.component.checkbox.CheckboxGroup$CheckBoxItem".equals(component.getClass().getName())) {
            properties.remove(CHECKED_PROPERTY_KEY);
            properties.remove("disabled");
        }
        if ("com.vaadin.flow.component.progressbar.ProgressBar".equals(component.getClass().getName())) {
            this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, "max");
            this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, "min");
            this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, VALUE_PROPERTY_KEY);
        }
        if (properties.containsKey(ACCESSIBLE_NAME_REF)) {
            properties.put("ariaLabelledBy", properties.get(ACCESSIBLE_NAME_REF));
            properties.remove(ACCESSIBLE_NAME_REF);
        }
        if (properties.containsKey(ACCESSIBLE_NAME)) {
            properties.put("ariaLabel", properties.get(ACCESSIBLE_NAME));
            properties.remove(ACCESSIBLE_NAME);
        }
        if (checkbox) {
            if (properties.containsKey(INDETERMINATE_PROPERTY_KEY) && properties.get(INDETERMINATE_PROPERTY_KEY).equals(Boolean.FALSE)) {
                this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, INDETERMINATE_PROPERTY_KEY);
            }
            if (properties.containsKey(CHECKED_PROPERTY_KEY) && properties.get(CHECKED_PROPERTY_KEY).equals(Boolean.FALSE)) {
                this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, CHECKED_PROPERTY_KEY);
            }
            if (properties.containsKey(AUTO_FOCUS_PROPERTY_KEY) && properties.get(AUTO_FOCUS_PROPERTY_KEY).equals(Boolean.FALSE)) {
                this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, AUTO_FOCUS_PROPERTY_KEY);
            }
            this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, VALUE_PROPERTY_KEY);
        }
        if (component instanceof HasEnabled && (hasEnabled = (HasEnabled)component).isEnabled()) {
            this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, ENABLED_PROPERTY_KEY);
        }
        if (component instanceof HasValueAndElement) {
            if (properties.containsKey(READONLY)) {
                properties.put(READ_ONLY_CAMEL_CASE, properties.get(READONLY));
                properties.remove(READONLY);
                if (properties.get(READ_ONLY_CAMEL_CASE).equals(Boolean.FALSE)) {
                    this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, READ_ONLY_CAMEL_CASE);
                }
            }
            if (properties.containsKey(REQUIRED_PROPERTY_KEY)) {
                properties.put(REQUIRED_INDICATOR_VISIBLE, properties.get(REQUIRED_PROPERTY_KEY));
                properties.remove(REQUIRED_PROPERTY_KEY);
                if (properties.get(REQUIRED_INDICATOR_VISIBLE).equals(Boolean.FALSE)) {
                    this.removeSetterIfNotPresentInSourceCode(componentInfo, properties, REQUIRED_INDICATOR_VISIBLE);
                }
            }
        }
        this.filterOutComboBoxProperties(component, properties);
    }

    private void removeSetterIfNotPresentInSourceCode(ComponentInfo componentInfo, Map<String, Object> properties, String propertyKey) {
        String setterName = JavaRewriterUtil.getSetterName(propertyKey, componentInfo.type(), false);
        boolean setterFound = JavaRewriterUtil.findMethodCalls(componentInfo).stream().anyMatch(f -> f.getNameAsString().equals(setterName));
        if (!setterFound) {
            properties.remove(propertyKey);
        }
    }

    private Optional<Object> getFieldValue(Object target, String fieldName) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object o = field.get(target);
            return Optional.ofNullable(o);
        }
        catch (NoSuchFieldException ex) {
            this.getLogger().debug("Could not find field {} in class {}", (Object)fieldName, (Object)target.getClass().getName());
        }
        catch (IllegalAccessException e) {
            this.getLogger().debug("Could not access the field {}", (Object)fieldName, (Object)e);
        }
        return Optional.empty();
    }

    private void addSuffixOrPrefixAttributes(Component possiblyPrefixOrSuffixComponent, Map<String, Object> properties) {
        Optional parentOptional = possiblyPrefixOrSuffixComponent.getParent();
        if (parentOptional.isEmpty()) {
            return;
        }
        Component parent = (Component)parentOptional.get();
        this.getPrefixComponent(parent).filter(prefix -> prefix.getElement().getNode().getId() == possiblyPrefixOrSuffixComponent.getElement().getNode().getId()).ifPresent(prefix -> properties.put("slot", "prefix"));
        this.getSuffixComponent(parent).filter(suffixComponent -> suffixComponent.getElement().getNode().getId() == possiblyPrefixOrSuffixComponent.getElement().getNode().getId()).ifPresent(suffixComponent -> properties.put("slot", "suffix"));
    }

    private Optional<Component> getPrefixComponent(Component component) {
        boolean hasPrefixComponent = Arrays.stream(component.getClass().getInterfaces()).anyMatch(interface0 -> interface0.getName().equals("com.vaadin.flow.component.shared.HasPrefix"));
        if (!hasPrefixComponent) {
            return Optional.empty();
        }
        return this.getMethodValue(component, "getPrefixComponent");
    }

    private Optional<Component> getSuffixComponent(Component component) {
        boolean hasPrefixComponent = Arrays.stream(component.getClass().getInterfaces()).anyMatch(interface0 -> interface0.getName().equals("com.vaadin.flow.component.shared.HasSuffix"));
        if (!hasPrefixComponent) {
            return Optional.empty();
        }
        return this.getMethodValue(component, "getSuffixComponent");
    }

    private <T> Optional<T> getMethodValue(Object target, String methodName) {
        try {
            Method declaredMethod = target.getClass().getMethod(methodName, new Class[0]);
            Object result = declaredMethod.invoke(target, new Object[0]);
            return Optional.ofNullable(result).map(o -> o);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().debug("Could not find method {} in {}", (Object)methodName, target.getClass());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.getLogger().debug("Could not invoke method {} in {}", (Object)methodName, target.getClass());
        }
        return Optional.empty();
    }

    private void addMenuBarProperties(Component component, Map<String, Object> properties) {
        boolean isMenuBar = MENU_BAR_COMPONENT_CLASS_NAME.equals(component.getClass().getName());
        if (!isMenuBar) {
            return;
        }
        ArrayList<String> texts = new ArrayList<String>();
        List<Component> rootItems = component.getChildren().filter(child -> MENU_BAR_ROOT_ITEM_CLASS_NAME.equals(child.getClass().getName())).toList();
        for (Component rootItem : rootItems) {
            if (!(rootItem instanceof HasText)) continue;
            HasText hasText = (HasText)rootItem;
            texts.add(hasText.getText());
        }
        List<ObjectNode> textObjectNodes = texts.stream().map(k -> new ObjectNode(JsonNodeFactory.instance).put("text", k)).toList();
        properties.put("items", textObjectNodes);
    }

    private void filterOutComboBoxProperties(Component component, Map<String, Object> properties) {
        if (!COMBOBOX_CLASS_NAME.equals(component.getClass().getName())) {
            return;
        }
        properties.remove("_clientSideFilter");
        properties.remove("pageSize");
        properties.remove("itemIdPath");
        properties.remove("itemValuePath");
        properties.remove("selectedItem");
        properties.remove("filter");
        properties.remove("size");
        properties.remove(OPENED_PROPERTY_KEY);
        properties.remove(VALUE_PROPERTY_KEY);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

