/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.copilot.ComponentSourceFinder;
import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.CopilotVersion;
import com.vaadin.copilot.FlowUtil;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ai.AICommunicationUtil;
import com.vaadin.copilot.ai.AIConstants;
import com.vaadin.copilot.communication.CopilotServerRequest;
import com.vaadin.copilot.communication.CopilotServerResponse;
import com.vaadin.copilot.communication.CopilotServerResponseCode;
import com.vaadin.copilot.communication.StreamResponse;
import com.vaadin.copilot.communication.StreamResponseEnum;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpMethod;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;

public class AICommandHandler
extends CopilotServerClient
implements CopilotCommand {
    private final Map<String, String> serverInfoVersions;
    private final ProjectManager projectManager;
    private final ComponentSourceFinder componentSourceFinder;
    private final boolean aiEnabled;
    private final Map<String, Disposable> disposables = new HashMap<String, Disposable>();

    public AICommandHandler(ProjectManager projectManager, boolean aiEnabled) {
        this.projectManager = projectManager;
        this.componentSourceFinder = new ComponentSourceFinder(projectManager);
        ServerInfo serverInfo = new ServerInfo();
        this.serverInfoVersions = serverInfo.getVersions().stream().collect(Collectors.toMap(ServerInfo.NameAndVersion::name, ServerInfo.NameAndVersion::version));
        this.aiEnabled = aiEnabled;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("prompt-text")) {
            if (!this.aiEnabled) {
                return true;
            }
            HashMap<String, String> metadata = new HashMap<String, String>(this.serverInfoVersions);
            ProKey proKey = this.getProKey();
            String machineId = this.getMachineId();
            if (proKey == null && machineId == null) {
                AICommunicationUtil.promptTextCannotCall(data, devToolsInterface);
                return false;
            }
            if (proKey != null) {
                metadata.put("proKey", proKey.toJson());
            }
            if (machineId != null) {
                metadata.put("machineId", machineId);
            }
            metadata.put("version", CopilotVersion.getVersion());
            String prompt = data.getString("text");
            Map<String, String> sources = AICommunicationUtil.getHillaSourceFiles(data);
            if (data.hasKey("uiid")) {
                if (data.hasKey("selections") && data.getArray("selections").length() > 0) {
                    JsonArray componentsJson = data.getArray("selections");
                    this.getLogger().debug("Selections: {}", (Object)data.getArray("selections"));
                    ArrayList selectedComponents = new ArrayList();
                    for (int i = 0; i < componentsJson.length(); ++i) {
                        ComponentTypeAndSourceLocation root = this.componentSourceFinder.findTypeAndSourceLocation(componentsJson.getObject(i), true);
                        selectedComponents.add(root);
                    }
                    this.getLogger().debug("Selected components: {}", (Object)selectedComponents);
                    File javaFile = this.projectManager.getSourceFile(((ComponentTypeAndSourceLocation)selectedComponents.get(0)).getCreateLocationOrThrow());
                    try {
                        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
                        List<ComponentInfo> selectedComponentInfos = selectedComponents.stream().map(rewriter::findComponentInfo).toList();
                        selectedComponentInfos.forEach(componentInfo -> {
                            rewriter.addComment((ComponentInfo)componentInfo, " the following item is selected:", JavaRewriter.CommentType.LINE);
                            sources.put(javaFile.getAbsolutePath(), rewriter.getResult());
                        });
                    }
                    catch (IOException e) {
                        this.getLogger().error("Error reading requested project Flow Java files", (Throwable)e);
                        devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                        return true;
                    }
                }
                try {
                    sources.putAll(this.getJavaSourceMap((int)data.getNumber("uiid")));
                }
                catch (IOException e) {
                    this.getLogger().error("Error reading requested project Flow Java files", (Throwable)e);
                    devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                    return true;
                }
            }
            HashMap<String, String> relativeSources = new HashMap<String, String>();
            for (String filename : sources.keySet()) {
                try {
                    relativeSources.put(this.projectManager.makeRelative(filename), sources.get(filename));
                }
                catch (IOException e) {
                    JsonObject responseData = Json.createObject();
                    if (data.hasKey("reqId")) {
                        responseData.put("reqId", data.getString("reqId"));
                    }
                    responseData.put("code", -300.0);
                    responseData.put("message", "Error processing the files");
                    this.getLogger().error("Error making file relative to project", (Throwable)e);
                    devToolsInterface.send("copilot-prompt-failed", responseData);
                    return true;
                }
            }
            try {
                CopilotServerRequest req = new CopilotServerRequest(prompt, relativeSources, metadata);
                JsonObject responseData = Json.createObject();
                responseData.put("requestId", data.hasKey("reqId") ? data.getString("reqId") : "");
                this.getLogger().debug("Request Registered in client: " + responseData.getString("requestId"));
                devToolsInterface.send("copilot-prompt-requestId", responseData);
                this.queryCopilotServer(req, devToolsInterface, data);
            }
            catch (Exception e) {
                AICommunicationUtil.handlingExceptionsAndNotifyDevtoolsInterface(data, devToolsInterface, e);
                return true;
            }
            return true;
        }
        if (command.equals("prompt-cancel")) {
            if (!this.aiEnabled) {
                return true;
            }
            JsonObject responseData = Json.createObject();
            if (!data.hasKey("requestId") || !data.hasKey("reqId")) {
                this.getLogger().error("Impossible to cancel without request and cancel request Ids");
                return false;
            }
            responseData.put("reqId", data.getString("reqId"));
            responseData.put("requestId", data.getString("requestId"));
            this.getLogger().debug("Trying to cancel Disposable object with id: {} - object: {}", (Object)data.getString("reqId"), (Object)this.disposables.get(data.getString("reqId")));
            if (this.disposables.get(data.getString("requestId")) != null) {
                responseData.put("message", "Request cancelled successfully");
                Disposable disposable = this.disposables.get(data.getString("requestId"));
                disposable.dispose();
                this.disposables.remove(data.getString("requestId"));
                devToolsInterface.send("copilot-prompt-cancel-ok", responseData);
            } else {
                responseData.put("message", "Error cancelling the request with id: " + data.getString("reqId"));
                devToolsInterface.send("copilot-prompt-cancel-failed", responseData);
            }
            return true;
        }
        return false;
    }

    private Map<String, String> getJavaSourceMap(int uiId) throws IOException {
        HashMap<String, String> sources = new HashMap<String, String>();
        for (Map.Entry<ComponentTracker.Location, File> entry : FlowUtil.findActiveJavaFiles(this.projectManager, uiId).entrySet()) {
            ArrayList<String> javaFileNames = new ArrayList<String>();
            File javaFile = entry.getValue();
            javaFileNames.add(javaFile.getName());
            sources.put(javaFile.getAbsolutePath(), this.projectManager.readFile(javaFile.getPath()));
            this.getLogger().debug("Java filenames: {}", javaFileNames);
        }
        return sources;
    }

    private void queryCopilotServer(CopilotServerRequest req, DevToolsInterface devToolsInterface, JsonObject dataJson) {
        URI queryUriStream = this.getQueryURI("stream");
        String json = this.writeAsJsonString(req);
        if (Copilot.isDevelopmentMode()) {
            this.getLogger().debug("Querying copilot server at {} using {}", (Object)queryUriStream, (Object)json);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        AtomicReference<StringBuilder> jsonBuffer = new AtomicReference<StringBuilder>(new StringBuilder());
        AtomicBoolean completedSuccessfully = new AtomicBoolean(false);
        Disposable disposable = ((HttpClient.ResponseReceiver)HttpClient.create().responseTimeout(Duration.of(140L, ChronoUnit.SECONDS)).headers(headers -> headers.set("Content-Type", (Object)"application/json; charset=utf-8")).request(HttpMethod.POST).send((Publisher)ByteBufMono.fromString((Publisher)Mono.just((Object)json), (Charset)StandardCharsets.UTF_8, (ByteBufAllocator)ByteBufAllocator.DEFAULT)).uri(queryUriStream)).responseContent().asString(StandardCharsets.UTF_8).doOnError(e -> AICommunicationUtil.handlingExceptionsAndNotifyDevtoolsInterface(dataJson, devToolsInterface, e)).subscribe(data -> {
            String newData = data.trim();
            if (newData.startsWith("data:")) {
                newData = newData.substring(5);
            }
            ((StringBuilder)jsonBuffer.get()).append(newData);
            String accumulatedData = ((StringBuilder)jsonBuffer.get()).toString();
            try {
                Optional<StreamResponse> parsedStreamResponseOpt = this.tryParseJson(objectMapper, accumulatedData);
                if (parsedStreamResponseOpt.isPresent()) {
                    StreamResponse parsedStreamResponse = parsedStreamResponseOpt.get();
                    JsonObject responseData = Json.createObject();
                    responseData.put("status", parsedStreamResponse.status().getMessage());
                    this.getLogger().debug("Parsed JSON: " + String.valueOf(parsedStreamResponse));
                    devToolsInterface.send("copilot-prompt-status", responseData);
                    completedSuccessfully.set(true);
                    if (dataJson.hasKey("reqId")) {
                        responseData.put("reqId", dataJson.getString("reqId"));
                    }
                    if (parsedStreamResponse.code() < 0) {
                        responseData.put("code", (double)parsedStreamResponse.code());
                        responseData.put("message", parsedStreamResponse.message());
                        devToolsInterface.send("copilot-prompt-failed", responseData);
                    } else if (parsedStreamResponse.status() == StreamResponseEnum.POST_PROCESS) {
                        responseData.put("message", parsedStreamResponse.message());
                        responseData.put("changes", (JsonValue)parsedStreamResponse.changes().keySet().stream().map(Json::create).collect(JsonUtils.asArray()));
                        this.getLogger().debug("PostProcess finished");
                        devToolsInterface.send("copilot-prompt-ok", responseData);
                        CopilotServerResponse response = new CopilotServerResponse(CopilotServerResponseCode.HILLA_REACT.getCode(), parsedStreamResponse.status().getMessage(), parsedStreamResponse.changes());
                        this.handleQueryResponse(response);
                    }
                    jsonBuffer.set(new StringBuilder());
                }
            }
            catch (Exception e) {
                this.getLogger().error("Error parsing JSON: " + e.getMessage() + " - Accumulated data: " + accumulatedData);
                JsonObject responseData = Json.createObject();
                responseData.put("reqId", dataJson.getString("reqId"));
                devToolsInterface.send("copilot-prompt-failed", responseData);
                jsonBuffer.set(new StringBuilder(accumulatedData));
            }
        }, error -> this.getLogger().error("Error: " + String.valueOf(error)), () -> {
            if (!completedSuccessfully.get()) {
                JsonObject responseData = Json.createObject();
                responseData.put("reqId", dataJson.getString("reqId"));
                this.getLogger().error("Stream did not completed successfully.");
                devToolsInterface.send("copilot-prompt-failed", responseData);
            } else {
                this.disposables.remove(dataJson.getString("reqId"));
                this.getLogger().debug("Stream completed successfully.");
            }
        });
        this.disposables.put(dataJson.getString("reqId"), disposable);
        this.getLogger().debug("Disposable object created for prompt {} - object: {} - RequestId: {}", new Object[]{json, disposable, dataJson.getString("reqId")});
    }

    private Optional<StreamResponse> tryParseJson(ObjectMapper objectMapper, String data) {
        try {
            return Optional.ofNullable((StreamResponse)objectMapper.readValue(data, StreamResponse.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private void handleQueryResponse(CopilotServerResponse response) throws IOException {
        if (response.code() == CopilotServerResponseCode.ERROR.getCode()) {
            this.getLogger().error("Copilot server returned error because an internal error. The reason could be a malformed request or a timeout.");
            return;
        }
        if (response.code() == CopilotServerResponseCode.ERROR_REQUEST.getCode()) {
            this.getLogger().error("Copilot server returned error because an internal error. The reason could be a malformed request or a timeout.");
            return;
        }
        if (response.code() == CopilotServerResponseCode.NOTHING.getCode()) {
            this.getLogger().debug("Copilot server returned no changes");
            return;
        }
        if (response.code() == CopilotServerResponseCode.HILLA_REACT.getCode()) {
            this.getLogger().debug("Copilot server returned Hilla/React changes");
        } else if (response.code() == CopilotServerResponseCode.FLOW.getCode()) {
            this.getLogger().debug("Copilot server returned Flow changes");
        } else if (response.code() == CopilotServerResponseCode.LOCAL.getCode()) {
            this.getLogger().debug("Copilot server returned Local changes");
        } else {
            if (response.code() < 0) {
                this.getLogger().debug("Copilot server returned Internal error code: {}", (Object)response.code());
                return;
            }
            this.getLogger().debug("Copilot server returned unknown response code: {}", (Object)response.code());
            return;
        }
        for (Map.Entry<String, String> change : response.changes().entrySet()) {
            try {
                this.projectManager.writeFile(this.projectManager.makeAbsolute(change.getKey()), AIConstants.COPILOT_AI_FILE_UPDATE_UNDO_LABEL, change.getValue());
            }
            catch (IOException e) {
                throw new IOException("Unable to write file (" + change.getKey() + ") with data from copilot server response", e);
            }
        }
    }

    ProKey getProKey() {
        return LocalProKey.get();
    }

    String getMachineId() {
        return MachineId.get();
    }

    public Map<String, Disposable> getDisposables() {
        return this.disposables;
    }
}

