/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.userinfo;

import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.userinfo.UserInfo;
import com.vaadin.copilot.userinfo.UserInfoRequest;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class UserInfoServerClient
extends CopilotServerClient {
    public UserInfo getUserInfo(String proKey) {
        URI uri = this.getQueryURI("userInfo");
        UserInfoRequest requestData = new UserInfoRequest(proKey);
        String json = this.writeAsJsonString(requestData);
        HttpRequest request = this.buildRequest(uri, json);
        try {
            HttpResponse<String> response = this.getHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return null;
            }
            return this.readValue(response.body(), UserInfo.class);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static UserInfo getUserInfoWithLocalProKey() {
        ProKey proKey = LocalProKey.get();
        if (proKey == null) {
            return null;
        }
        return new UserInfoServerClient().getUserInfo(proKey.getProKey());
    }
}

