/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.nodeTypes.modifiers.NodeWithPublicModifier;
import com.vaadin.copilot.ProjectManager;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class JavaModifier {
    private final ProjectManager projectManager;

    public JavaModifier(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    private CompilationUnit parseSource(String source) {
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        StaticJavaParser.setConfiguration((ParserConfiguration)parserConfiguration);
        return StaticJavaParser.parse((String)source);
    }

    public Map<File, String> modify(Class<?> cls, OperationFunction<CompilationUnitOperations> operations) throws IOException {
        File javaFile = this.projectManager.getFileForClass(cls);
        String source = IOUtils.toString((URI)javaFile.toURI(), (Charset)StandardCharsets.UTF_8);
        CompilationUnit cu = this.parseSource(source);
        operations.accept(new CompilationUnitOperations(cu, cls));
        String result = cu.toString();
        return Collections.singletonMap(javaFile, result);
    }

    public static class CompilationUnitOperations {
        private final CompilationUnit cu;
        private final Class<?> cls;

        public CompilationUnitOperations(CompilationUnit cu, Class<?> cls) {
            this.cu = cu;
            this.cls = cls;
        }

        public void addClassAnnotation(Class<? extends Annotation> annotation, String value) throws IOException {
            TypeDeclaration<?> type = this.getPublicType(this.cu);
            type.addSingleMemberAnnotation(annotation, (Expression)new StringLiteralExpr(value));
        }

        public boolean hasClassAnnotation(Class<? extends Annotation> annotationClass) {
            TypeDeclaration<?> type = this.getPublicType(this.cu);
            return type.getAnnotationByName(annotationClass.getSimpleName()).isPresent();
        }

        private TypeDeclaration<?> getPublicType(CompilationUnit cu) {
            return cu.getTypes().stream().filter(NodeWithPublicModifier::isPublic).findFirst().orElseThrow(() -> new IllegalArgumentException("No public type found in " + this.cls.getName()));
        }

        public void addInterface(Class<?> interfaceClass) {
            ClassOrInterfaceDeclaration classOrInterfaceDecl = this.getPublicType(this.cu).asClassOrInterfaceDeclaration();
            if (!this.hasImplementedType(classOrInterfaceDecl, interfaceClass)) {
                classOrInterfaceDecl.addImplementedType(interfaceClass);
            }
        }

        private boolean hasImplementedType(ClassOrInterfaceDeclaration classOrInterfaceDecl, Class<?> interfaceClass) {
            return classOrInterfaceDecl.getImplementedTypes().stream().anyMatch(type -> type.getNameAsString().equals(interfaceClass.getSimpleName()));
        }
    }

    @FunctionalInterface
    public static interface OperationFunction<T> {
        public void accept(T var1) throws IOException;
    }
}

