/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class ComponentSourceFinder {
    private final ProjectManager projectManager;

    public ComponentSourceFinder(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(JsonObject component) {
        return this.findTypeAndSourceLocation(component, false);
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(JsonObject component, boolean includeChildren) {
        return this.findTypeAndSourceLocation((int)component.getNumber("uiId"), (int)component.getNumber("nodeId"), includeChildren);
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(int uiId, int nodeId) {
        return this.findTypeAndSourceLocation(uiId, nodeId, false);
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(int uiId, int nodeId, boolean includeChildren) {
        AtomicReference<Object> info = new AtomicReference<Object>(null);
        VaadinSession vaadinSession = this.projectManager.getVaadinSession();
        vaadinSession.accessSynchronously((Command & Serializable)() -> {
            Element element = vaadinSession.findElement(uiId, nodeId);
            Optional c = element.getComponent();
            if (c.isPresent()) {
                ComponentTypeAndSourceLocation componentInfo = this.findTypeAndSourceLocation((Component)c.get(), includeChildren);
                info.set(componentInfo);
            }
        });
        ComponentTypeAndSourceLocation res = info.get();
        if (res == null) {
            throw new IllegalArgumentException("Unable to find component in source");
        }
        return res;
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(Component component, boolean includeChildren) {
        Optional parent = component.getParent();
        ComponentTypeAndSourceLocation parentInfo = parent.map(this::_getSourceLocation).orElse(null);
        ArrayList<ComponentTypeAndSourceLocation> children = new ArrayList<ComponentTypeAndSourceLocation>();
        if (includeChildren) {
            component.getChildren().forEach(child -> {
                ComponentTypeAndSourceLocation childInfo = this.findTypeAndSourceLocation((Component)child, true);
                children.add(childInfo);
            });
        }
        return this.getSourceLocation(component, parentInfo, children);
    }

    public ComponentTypeAndSourceLocation _getSourceLocation(Component component) {
        return this.getSourceLocation(component, null, null);
    }

    private ComponentTypeAndSourceLocation getSourceLocation(Component component, ComponentTypeAndSourceLocation parentInfo, List<ComponentTypeAndSourceLocation> children) {
        ComponentTracker.Location createLocation = ComponentTracker.findCreate((Component)component);
        ComponentTracker.Location attachLocation = ComponentTracker.findAttach((Component)component);
        File javaFile = createLocation != null ? this.projectManager.getSourceFile(createLocation) : null;
        ArrayList<Class> inheritanceChain = new ArrayList<Class>();
        inheritanceChain.add(component.getClass());
        for (Class<?> superClass = component.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            inheritanceChain.add(superClass);
        }
        return new ComponentTypeAndSourceLocation(component.getClass(), inheritanceChain, component, javaFile, createLocation, attachLocation, parentInfo, children);
    }
}

