/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.analytics;

import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.CopilotVersion;
import com.vaadin.copilot.analytics.AnalyticsRequest;
import com.vaadin.copilot.userinfo.UserInfo;
import com.vaadin.copilot.userinfo.UserInfoServerClient;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnalyticsClient
extends CopilotServerClient {
    private static AnalyticsClient instance;
    private final String userKey = ProjectHelpers.getUserKey();
    private final String machineId = MachineId.get();
    private final boolean vaadiner;
    private boolean enabled;
    private Map<String, String> userContext;

    private AnalyticsClient() {
        UserInfo userInfo;
        ProKey proKey = LocalProKey.get();
        this.vaadiner = proKey != null ? (userInfo = new UserInfoServerClient().getUserInfo(proKey.getProKey())) != null && userInfo.vaadiner() : false;
    }

    public static AnalyticsClient getInstance() {
        if (instance == null) {
            instance = new AnalyticsClient();
        }
        return instance;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setUserContext(Map<String, String> userContext) {
        this.userContext = Collections.unmodifiableMap(userContext);
    }

    public void track(String event, Map<String, String> properties) {
        if (!this.isEnabled()) {
            return;
        }
        properties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
        properties.put("Vaadiner", String.valueOf(this.vaadiner));
        properties.put("Version", CopilotVersion.getVersion());
        this.sendRequest(event, properties, this.userContext);
    }

    protected void sendRequest(String event, Map<String, String> properties, Map<String, String> context) {
        AnalyticsRequest trackingRequest = new AnalyticsRequest(this.userKey, this.machineId, event, properties, context);
        String json = this.writeAsJsonString(trackingRequest);
        this.sendReactive("analytics", json);
    }
}

