/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.AccessRequirement;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.RouteDuplicatedException;
import com.vaadin.copilot.RouteHandler;
import com.vaadin.copilot.Util;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.flow.shared.util.SharedUtil;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteCreator {
    private final ProjectManager projectManager;

    public RouteCreator(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(RouteCreator.class);
    }

    public void createFlowView(String route, AccessRequirement accessRequirement, Class<?> layoutClass) throws IOException, RouteDuplicatedException {
        RouteCreator.getLogger().debug("Creating Flow view for route {}", (Object)route);
        this.throwIfInvalidRoute(route);
        String lastRouteSegment = RouteCreator.getLastRouteSegment(route);
        String className = RouteCreator.getFlowViewName(route);
        if (!this.projectManager.sanitizeFilename(className).equals(className)) {
            throw new IllegalArgumentException("Invalid filename " + className);
        }
        File viewFolder = this.projectManager.getFlowNewViewFolder();
        File viewFile = new File(viewFolder, className + ".java");
        String viewsPackage = this.projectManager.getJavaPackage(viewFile);
        if (this.existsRoute(route)) {
            throw new RouteDuplicatedException(route);
        }
        if (viewFile.exists()) {
            throw new RouteDuplicatedException(route);
        }
        viewFile.getParentFile().mkdirs();
        String title = Util.titleCase(SharedUtil.dashSeparatedToCamelCase((String)lastRouteSegment));
        String content = this.getFlowRouteTemplate(viewsPackage, route, title, className, accessRequirement, layoutClass);
        this.projectManager.writeFile(viewFile, CopilotIDEPlugin.undoLabel("Add route"), content);
    }

    private void throwIfInvalidRoute(String route) {
        if (route.isEmpty()) {
            return;
        }
        if (!route.matches("^[a-zA-Z0-9-/]*$")) {
            throw new IllegalArgumentException("Routes can only contain letters, numbers, dashes and separators (/): " + route);
        }
        if (!route.matches(".*[a-zA-Z0-9]+.*")) {
            throw new IllegalArgumentException("Route must contain at least one letter or number: " + route);
        }
        if (route.contains("//")) {
            throw new IllegalArgumentException("Route must not contain consecutive slashes: " + route);
        }
    }

    private static String getLastRouteSegment(String route) {
        if (route.contains("/")) {
            return route.substring(route.lastIndexOf(47) + 1);
        }
        return route;
    }

    static String getFlowViewName(String route) {
        String[] parts = route.split("/");
        String filename = parts[parts.length - 1];
        String identifier = filename.isEmpty() || filename.endsWith("/") ? "Main" : SharedUtil.capitalize((String)JavaRewriterUtil.getJavaIdentifier(filename, 100));
        return identifier;
    }

    public void createHillaView(String route, AccessRequirement accessRequirement) throws IOException, RouteDuplicatedException {
        String[] parts;
        RouteCreator.getLogger().debug("Creating Hilla view for route {}", (Object)route);
        this.throwIfInvalidRoute(route);
        Object filenameWithPath = route;
        if (((String)filenameWithPath).isEmpty() || ((String)filenameWithPath).endsWith("/")) {
            filenameWithPath = (String)filenameWithPath + "@index";
        }
        if (!this.projectManager.sanitizeFilename((String)filenameWithPath).equals(((String)filenameWithPath).replace('/', '_'))) {
            throw new IllegalArgumentException("Invalid filename " + (String)filenameWithPath);
        }
        File viewFile = this.projectManager.getHillaViewsFolder();
        for (String part : parts = ((String)filenameWithPath).split("/")) {
            viewFile = new File(viewFile, part);
        }
        if (this.existsRoute(route)) {
            throw new RouteDuplicatedException(route);
        }
        if ((viewFile = RouteCreator.addExtension(viewFile, ".tsx")).exists()) {
            throw new RouteDuplicatedException(route);
        }
        viewFile.getParentFile().mkdirs();
        String viewName = viewFile.getName().replace(".tsx", "");
        if (viewName.startsWith("@")) {
            viewName = "";
        }
        String title = Util.titleCase(SharedUtil.dashSeparatedToCamelCase((String)viewName));
        String content = this.getHillaRouteTemplate(parts[parts.length - 1], title, accessRequirement);
        this.projectManager.writeFile(viewFile, CopilotIDEPlugin.undoLabel("Add route"), content);
    }

    private String getHillaRouteTemplate(String routeName, String title, AccessRequirement accessRequirement) {
        String functionName = this.getValidReactComponentFunctionName(SharedUtil.capitalize((String)SharedUtil.dashSeparatedToCamelCase((String)routeName)));
        return "import type { ViewConfig } from '@vaadin/hilla-file-router/types.js';\n\nexport const config: ViewConfig = {\n  title: 'TITLE',\n  ACCESS_CONTROL\n};\n\nexport default function FUNCTION_NAME() {\n    return (\n        <div className=\"flex flex-col\">\n            <h1>ROUTE_NAME</h1>\n        </div>\n    );\n}\n".replace("TITLE", title).replace("FUNCTION_NAME", functionName).replace("ROUTE_NAME", routeName).replace("ACCESS_CONTROL", (CharSequence)(switch (accessRequirement.getType()) {
            case AccessRequirement.Type.PERMIT_ALL -> "loginRequired: true,";
            case AccessRequirement.Type.ANONYMOUS_ALLOWED -> "";
            case AccessRequirement.Type.DENY_ALL -> "rolesAllowed: [],";
            case AccessRequirement.Type.ROLES_ALLOWED -> "rolesAllowed: [" + Arrays.stream(accessRequirement.getRoles()).map(role -> "\"" + role + "\"").collect(Collectors.joining(", ")) + "],";
            default -> throw new IllegalArgumentException("Unknown access requirement: " + String.valueOf((Object)accessRequirement.getType()));
        }));
    }

    private String getValidReactComponentFunctionName(String functionName) {
        if (((String)functionName).equals("@index")) {
            return "Index";
        }
        if (((String)functionName).matches("^[^A-Z].*")) {
            functionName = "A" + (String)functionName;
        }
        return ((String)functionName).replaceAll("[^a-zA-Z0-9]", "");
    }

    String getFlowRouteTemplate(String packageName, String route, String title, String className, AccessRequirement accessRequirement, Class<?> layoutClass) {
        Class<PermitAll> accessClass;
        String accessParam = null;
        switch (accessRequirement.getType()) {
            case PERMIT_ALL: {
                accessClass = PermitAll.class;
                break;
            }
            case ANONYMOUS_ALLOWED: {
                accessClass = AnonymousAllowed.class;
                break;
            }
            case DENY_ALL: {
                accessClass = DenyAll.class;
                break;
            }
            case ROLES_ALLOWED: {
                accessClass = RolesAllowed.class;
                accessParam = "{" + Arrays.stream(accessRequirement.getRoles()).map(role -> "\"" + role + "\"").collect(Collectors.joining(", ")) + "}";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown access requirement: " + String.valueOf((Object)accessRequirement.getType()));
            }
        }
        Object accessAnnotation = accessClass.getSimpleName();
        if (accessParam != null) {
            accessAnnotation = (String)accessAnnotation + "(" + accessParam + ")";
        }
        Object layoutImport = "";
        Object layoutAnnotationValue = "";
        if (layoutClass != null) {
            layoutImport = "import " + layoutClass.getName() + ";";
            layoutAnnotationValue = ", layout = " + layoutClass.getSimpleName() + ".class";
        }
        return "package VIEW_PACKAGE;\n\nimport com.vaadin.flow.component.html.H1;\nimport com.vaadin.flow.component.orderedlayout.HorizontalLayout;\nimport com.vaadin.flow.router.Route;\nimport com.vaadin.flow.router.PageTitle;\nimport com.vaadin.flow.server.auth.AnonymousAllowed;\nimport ACCESS_CLASS_NAME;\nLAYOUT_IMPORT\n\n@Route(value = \"ROUTE\"ROUTE_LAYOUT)\n@PageTitle(\"TITLE\")\n@ACCESS_ANNOTATION\npublic class CLASS_NAME extends HorizontalLayout {\n\n    public CLASS_NAME() {\n        add(new H1(\"This is CLASS_NAME\"));\n    }\n\n}\n".replace("LAYOUT_IMPORT", (CharSequence)layoutImport).replace("ROUTE_LAYOUT", (CharSequence)layoutAnnotationValue).replace("VIEW_PACKAGE", packageName).replace("ROUTE", route).replace("ACCESS_CLASS_NAME", accessClass.getName()).replace("CLASS_NAME", className).replace("TITLE", title).replace("ACCESS_ANNOTATION", (CharSequence)accessAnnotation);
    }

    private static File addExtension(File viewFile, String ext) {
        return new File(viewFile.getParentFile(), viewFile.getName() + ext);
    }

    private boolean existsRoute(String route) {
        try {
            RouteHandler.getServerRoutes(this.projectManager.getVaadinSession()).stream().filter(routeData -> routeData.getTemplate().equals(route)).findAny().ifPresent(routeData -> {
                throw new RuntimeException("Route already exists: " + route);
            });
        }
        catch (RuntimeException e) {
            return true;
        }
        return false;
    }
}

