/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotStatus;
import com.vaadin.copilot.analytics.AnalyticsClient;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.Serializable;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopilotIndexHtmlLoader
implements VaadinServiceInitListener {
    public void serviceInit(ServiceInitEvent event) {
        VaadinServletContext context = (VaadinServletContext)event.getSource().getContext();
        if (!CopilotStatus.isEnabled(context)) {
            this.getLogger().info("Copilot is disabled");
            return;
        }
        boolean vaadinUsageStatisticsEnabled = ApplicationConfiguration.get((VaadinContext)context).isUsageStatisticsEnabled();
        boolean analyticsEnabled = !Copilot.isDevelopmentMode() && vaadinUsageStatisticsEnabled;
        AnalyticsClient.getInstance().setEnabled(analyticsEnabled);
        event.addIndexHtmlRequestListener((IndexHtmlRequestListener & Serializable)e -> {
            Document document = e.getDocument();
            String devToolsConf = this.getRow(document.head().toString(), "window.Vaadin.devToolsConf");
            if (devToolsConf.contains("\"token\":")) {
                document.body().append("<copilot-main></copilot-main>");
                document.head().appendElement("script").append("const issuedWarnings = window.litIssuedWarnings ??= new Set();\nissuedWarnings.add(\n  'Multiple versions of Lit loaded. Loading multiple versions is not recommended. See https://lit.dev/msg/multiple-versions for more information.',\n);\nissuedWarnings.add(\n  'Lit is in dev mode. Not recommended for production! See https://lit.dev/msg/dev-mode for more information.',\n);\nissuedWarnings.add(\n  'Overriding ReactiveElement.createProperty() is deprecated. The override will not be called with standard decorators See https://lit.dev/msg/no-override-create-property for more information.',\n);\nissuedWarnings.add(\n  'Overriding ReactiveElement.getPropertyDescriptor() is deprecated. The override will not be called with standard decorators See https://lit.dev/msg/no-override-get-property-descriptor for more information.',\n);\n");
            }
        });
    }

    private String getRow(String text, String needle) {
        int location = text.indexOf(needle);
        if (location == -1) {
            return "";
        }
        int prependingNewline = text.substring(0, location).lastIndexOf("\n");
        int followingNewline = text.indexOf("\n", location);
        return text.substring(prependingNewline + 1, followingNewline);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

