/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.vaadin.base.devserver.FileWatcher;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.exception.ComponentInfoNotFoundException;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceSyncChecker {
    private static final String JAVA_FILE_EXTENSION = ".java";
    private final Set<String> updatedAtLeastOnce = new HashSet<String>();
    private final Set<String> notSyncIssuesStacktrace = new HashSet<String>();
    private final ApplicationConfiguration applicationConfiguration;
    private final SerializableConsumer<File> sourceClassChangeListener = (SerializableConsumer & Serializable)sourceFile -> {
        if (sourceFile.isFile() && sourceFile.getAbsolutePath().endsWith(JAVA_FILE_EXTENSION)) {
            String classPathInProjectWithoutExtension = this.getSourcePathOfSourceFile((File)sourceFile);
            this.updatedAtLeastOnce.add(classPathInProjectWithoutExtension);
        }
    };
    private final List<FileWatcher> sourceFileWatchers = new ArrayList<FileWatcher>();

    public SourceSyncChecker(ApplicationConfiguration applicationConfiguration, DevModeHandlerManager devModeHandler) {
        this.applicationConfiguration = applicationConfiguration;
        this.startSourceFileWatchers(devModeHandler);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SourceSyncChecker.class);
    }

    private void startSourceFileWatchers(DevModeHandlerManager devModeHandler) {
        File javaSourceFolder = this.applicationConfiguration.getJavaSourceFolder();
        if (!javaSourceFolder.exists()) {
            SourceSyncChecker.getLogger().debug("Java source folder {} does not exist ", (Object)javaSourceFolder.getAbsolutePath());
            return;
        }
        FileWatcher watcher = this.startSourceFileWatcher(javaSourceFolder);
        if (watcher != null) {
            this.sourceFileWatchers.add(watcher);
        }
        this.registerWatcherShutdownCommand(devModeHandler);
    }

    private FileWatcher startSourceFileWatcher(File sourceFolder) {
        try {
            FileWatcher sourceFileWatcher = new FileWatcher(this.sourceClassChangeListener, sourceFolder);
            sourceFileWatcher.start();
            SourceSyncChecker.getLogger().debug("Started watching {}", (Object)sourceFolder);
            return sourceFileWatcher;
        }
        catch (IOException e) {
            SourceSyncChecker.getLogger().error("Could not start file watched for source classes", (Throwable)e);
            return null;
        }
    }

    private void registerWatcherShutdownCommand(DevModeHandlerManager devModeHandlerManager) {
        devModeHandlerManager.registerShutdownCommand((Command & Serializable)() -> {
            for (FileWatcher sourceFileWatcher : this.sourceFileWatchers) {
                try {
                    sourceFileWatcher.stop();
                }
                catch (IOException e) {
                    SourceSyncChecker.getLogger().error("Could not stop file watcher for source classes", (Throwable)e);
                }
            }
            this.sourceFileWatchers.clear();
        });
    }

    public boolean maybeOutOfSync(ComponentInfoNotFoundException exception) {
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = exception.getComponentTypeAndSourceLocation();
        File sourceFile = componentTypeAndSourceLocation.javaFile();
        String sourcePathOfSourceFile = this.getSourcePathOfSourceFile(sourceFile);
        if (this.notSyncIssuesStacktrace.contains(ExceptionUtils.getStackTrace((Throwable)exception))) {
            return false;
        }
        if (!this.updatedAtLeastOnce.contains(sourcePathOfSourceFile)) {
            this.notSyncIssuesStacktrace.add(ExceptionUtils.getStackTrace((Throwable)exception));
            return false;
        }
        return this.updatedAtLeastOnce.contains(sourcePathOfSourceFile);
    }

    private String getSourcePathOfSourceFile(File file) {
        Path javaSourceFolderPath = this.applicationConfiguration.getJavaSourceFolder().toPath();
        Path path = file.toPath();
        return javaSourceFolderPath.relativize(path).toString();
    }

    public List<FileWatcher> getSourceFileWatchers() {
        return this.sourceFileWatchers;
    }
}

