/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LumoRewriterUtil {
    private static final String addClassName = "addClassName";
    private static final String addClassNames = "addClassNames";
    private static final String setClassName = "setClassName";
    private static final List<String> classNameMethods = List.of("addClassName", "addClassNames", "setClassName");
    private static final Map<String, String> classNameLumoUtilityClassCacheMap = new HashMap<String, String>();

    private LumoRewriterUtil() {
    }

    public static void removeThemeArgStartsWith(List<MethodCallExpr> methodCallStatements, String startsWith) {
        List<MethodCallExpr> themeAddCalls = LumoRewriterUtil.getThemeAddCalls(methodCallStatements);
        for (MethodCallExpr addCall : themeAddCalls) {
            List argsToRemove = addCall.getArguments().stream().filter(f -> f.isStringLiteralExpr() && f.asStringLiteralExpr().asString().startsWith(startsWith)).collect(Collectors.toList());
            JavaRewriterUtil.removeArgumentCalls(addCall, argsToRemove, true);
        }
    }

    public static void removeSetThemeArgs(List<MethodCallExpr> methodCallExprList, String argName) {
        List<MethodCallExpr> list = methodCallExprList.stream().filter(methodCallExpr -> methodCallExpr.getScope().isPresent()).filter(methodCallExpr -> ((Expression)methodCallExpr.getScope().get()).toString().contains("getThemeList")).filter(methodCallExpr -> methodCallExpr.getNameAsString().equals("set")).toList();
        for (MethodCallExpr methodCallExpr2 : list) {
            Expression argument;
            if (methodCallExpr2.getArguments().isEmpty() || !(argument = methodCallExpr2.getArgument(0)).isStringLiteralExpr() || !argument.asStringLiteralExpr().asString().equals(argName)) continue;
            JavaRewriterUtil.removeStatement((Node)methodCallExpr2);
        }
    }

    public static void removeThemeArgs(List<MethodCallExpr> methodCallStatements, List<String> args) {
        List<MethodCallExpr> themeAddCalls = LumoRewriterUtil.getThemeAddCalls(methodCallStatements);
        for (MethodCallExpr addCall : themeAddCalls) {
            List argsToRemove = addCall.getArguments().stream().filter(f -> f.isStringLiteralExpr() && args.contains(f.asStringLiteralExpr().asString())).collect(Collectors.toList());
            JavaRewriterUtil.removeArgumentCalls(addCall, argsToRemove, true);
        }
    }

    public static Expression createAddClassNameExprUsingLumoVariables(Expression owner, Object value, CompilationUnit cu) {
        if (!(value instanceof String)) {
            return null;
        }
        NodeList classNameArgExpressions = new NodeList();
        String[] classNames = ((String)value).split(" ");
        boolean addedAny = false;
        for (String className : classNames) {
            String lumoVariable = LumoRewriterUtil.getLumoVariable(className);
            if (lumoVariable != null) {
                addedAny = true;
                classNameArgExpressions.add((Node)new NameExpr(lumoVariable));
                continue;
            }
            classNameArgExpressions.add((Node)new StringLiteralExpr(className));
        }
        if (!addedAny) {
            return null;
        }
        LumoRewriterUtil.addLumoUtilityImport(cu);
        return new MethodCallExpr(owner, addClassNames, classNameArgExpressions);
    }

    public static boolean addClassNameWithArgs(ComponentInfo component, List<Expression> arguments) {
        Optional<MethodCallExpr> addClassNamesOptional;
        MethodCallExpr methodClassExpr;
        if (component.routeConstructor() != null) {
            methodClassExpr = new MethodCallExpr();
        } else {
            if (component.isAnonymousComponent()) {
                JavaRewriter.ExtractInlineVariableResult extractInlineVariableResult = JavaRewriterUtil.extractInlineVariableToLocalVariable(component);
                if (extractInlineVariableResult == null) {
                    return false;
                }
                MethodCallExpr methodClassExpr2 = new MethodCallExpr((Expression)new NameExpr(extractInlineVariableResult.newVariableName()), addClassName);
                arguments.forEach(arg_0 -> ((MethodCallExpr)methodClassExpr2).addArgument(arg_0));
                extractInlineVariableResult.blockStmt().addStatement(extractInlineVariableResult.index() + 1, (Expression)methodClassExpr2);
                return true;
            }
            String varName = component.localVariableName() != null ? component.localVariableName() : component.fieldName();
            methodClassExpr = new MethodCallExpr((Expression)new NameExpr(varName), addClassName);
        }
        arguments.forEach(arg_0 -> ((MethodCallExpr)methodClassExpr).addArgument(arg_0));
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(component);
        List<MethodCallExpr> classNameMethodCalls = methodCallStatements.stream().filter(f -> classNameMethods.contains(f.getNameAsString())).toList();
        for (int i = classNameMethodCalls.size() - 1; i >= 0; --i) {
            if (!classNameMethodCalls.get(i).getNameAsString().equals(setClassName)) continue;
            classNameMethodCalls = classNameMethodCalls.subList(i + 1, classNameMethodCalls.size());
            break;
        }
        if ((addClassNamesOptional = classNameMethodCalls.stream().filter(f -> f.getNameAsString().equals(addClassNames)).findAny()).isPresent()) {
            arguments.forEach(arg -> ((MethodCallExpr)addClassNamesOptional.get()).addArgument(arg));
            return true;
        }
        return JavaRewriterUtil.addAfterLastFunctionCall(methodCallStatements, addClassNames, (Expression[])arguments.toArray(Expression[]::new)) != null;
    }

    public static void removeClassNameArgs(ComponentInfo component, String ... lumoUtilityClassNames) {
        List<String> classNameDefinitionMethodNames = List.of(addClassName, addClassNames, setClassName);
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(component);
        List<MethodCallExpr> classNameDefinitionMethods = methodCallStatements.stream().filter(f -> classNameDefinitionMethodNames.contains(f.getNameAsString())).toList();
        ArrayList<Expression> argsWillBeRemoved = new ArrayList<Expression>();
        for (String lumoUtilityClassName : lumoUtilityClassNames) {
            argsWillBeRemoved.addAll(LumoRewriterUtil.getPossibleLumoUtilityMethodArgExpressions(lumoUtilityClassName));
        }
        JavaRewriterUtil.removeArgumentCalls(classNameDefinitionMethods, argsWillBeRemoved, true);
    }

    public static void addLumoUtilityImport(CompilationUnit compilationUnit) {
        JavaRewriterUtil.addImport(compilationUnit, "com.vaadin.flow.theme.lumo.LumoUtility");
    }

    private static List<Expression> getPossibleLumoUtilityMethodArgExpressions(String lumoInnerClassName) {
        BiMap<String, String> utilityClasses = LumoRewriterUtil.getLumoFieldsNameValueMap(lumoInnerClassName);
        ArrayList<Expression> lumoRelatedUtilityClasses = new ArrayList<Expression>();
        lumoRelatedUtilityClasses.addAll(utilityClasses.keySet().stream().map(arg -> new FieldAccessExpr((Expression)new NameExpr("LumoUtility." + lumoInnerClassName), arg)).toList());
        lumoRelatedUtilityClasses.addAll(utilityClasses.values().stream().map(StringLiteralExpr::new).toList());
        return lumoRelatedUtilityClasses;
    }

    public static List<Expression> getLumoMethodArgExpressions(String lumoInnerClassName, List<String> classNames) {
        BiMap<String, String> classKeyValueMap = LumoRewriterUtil.getLumoFieldsNameValueMap(lumoInnerClassName);
        return classNames.stream().map(lumoClassValue -> (String)classKeyValueMap.inverse().get(lumoClassValue)).filter(Objects::nonNull).map(arg -> new FieldAccessExpr((Expression)new NameExpr("LumoUtility." + lumoInnerClassName), arg)).map(k -> k).toList();
    }

    public static List<Expression> getLumoMethodArgExpressions(List<String> lumoInnerClassNames, List<String> classNames) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (String lumoInnerClassName : lumoInnerClassNames) {
            List<Expression> lumoMethodArgExpressions = LumoRewriterUtil.getLumoMethodArgExpressions(lumoInnerClassName, classNames);
            expressions.addAll(lumoMethodArgExpressions);
        }
        return expressions;
    }

    private static BiMap<String, String> getLumoFieldsNameValueMap(String innerClassName) {
        try {
            HashBiMap biMap = HashBiMap.create();
            Class<?> lumoUtilityClazz = JavaRewriterUtil.getClass("com.vaadin.flow.theme.lumo.LumoUtility$" + innerClassName);
            for (Field declaredField : lumoUtilityClazz.getDeclaredFields()) {
                String name = declaredField.getName();
                String value = (String)declaredField.get(null);
                biMap.put((Object)name, (Object)value);
            }
            return biMap;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("There is no lumo utility field named " + innerClassName);
        }
    }

    private static List<MethodCallExpr> getThemeAddCalls(List<MethodCallExpr> methodCallStatements) {
        return methodCallStatements.stream().filter(methodCallExpr -> methodCallExpr.getScope().isPresent()).filter(methodCallExpr -> ((Expression)methodCallExpr.getScope().get()).toString().contains("getThemeList")).filter(methodCallExpr -> methodCallExpr.getNameAsString().equals("add") || methodCallExpr.getNameAsString().equals("addAll")).collect(Collectors.toList());
    }

    private static String getLumoVariable(String className) {
        Class<?>[] classes;
        if (classNameLumoUtilityClassCacheMap.containsKey(className)) {
            return classNameLumoUtilityClassCacheMap.get(className);
        }
        Class<?> lumoUtilityClass = JavaRewriterUtil.getClass("com.vaadin.flow.theme.lumo.LumoUtility");
        for (Class<?> clazz : classes = lumoUtilityClass.getClasses()) {
            Field[] fields;
            for (Field field : fields = clazz.getFields()) {
                String name = field.getName();
                try {
                    Object classVarValue = field.get(null);
                    if (!(classVarValue instanceof String) || !classVarValue.equals(className)) continue;
                    String lumoVariableName = lumoUtilityClass.getSimpleName() + "." + clazz.getSimpleName() + "." + name;
                    classNameLumoUtilityClassCacheMap.put(className, lumoVariableName);
                    return lumoVariableName;
                }
                catch (IllegalAccessException e) {
                    LumoRewriterUtil.getLogger().debug("Could not access LumoUtility variable {}", (Object)name, (Object)e);
                    return null;
                }
            }
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(LumoRewriterUtil.class);
    }
}

