/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DebugWindowConnection;
import com.vaadin.flow.hotswap.VaadinHotswapper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;
import java.util.Set;

public class HotswapListener
implements VaadinHotswapper {
    public boolean onClassLoadEvent(VaadinSession vaadinSession, Set<Class<?>> classes, boolean redefined) {
        VaadinService service = vaadinSession.getService();
        BrowserLiveReload liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService((VaadinService)service).orElse(null);
        if (liveReload != null) {
            JsonObject msg = Json.createObject();
            msg.put("command", "copilot-java-after-update");
            JsonObject data = Json.createObject();
            this.getRoutePath(service, classes.iterator().next()).ifPresent(routePath -> data.put("routePath", routePath));
            data.put("class", classes.iterator().next().getName());
            data.put("redefined", redefined);
            msg.put("data", (JsonValue)data);
            ((DebugWindowConnection)liveReload).broadcast(msg);
        }
        return false;
    }

    private Optional<String> getRoutePath(VaadinService service, Class<?> maybeRouteClass) {
        if (maybeRouteClass.getAnnotation(Route.class) != null) {
            return Optional.ofNullable(RouteUtil.getRoutePath((VaadinContext)service.getContext(), maybeRouteClass));
        }
        return Optional.empty();
    }
}

