/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.dom.ElementStateProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRewriterCopyPasteHandler {
    private static final String VALUE_PROPERTY_KEY = "value";
    private static final String INVALID_PROPERTY_KEY = "invalid";
    private static final String ERROR_MESSAGE_PROPERTY_KEY = "errorMessage";
    private final ProjectManager projectManager;

    public JavaRewriterCopyPasteHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public JavaComponent getCopiedJavaComponent(ComponentTypeAndSourceLocation componentTypeAndSourceLocation) {
        Component component = componentTypeAndSourceLocation.component();
        ElementStateProvider stateProvider = component.getElement().getStateProvider();
        Map<String, Object> properties = stateProvider.getPropertyNames(component.getElement().getNode()).collect(Collectors.toMap(k -> k, k -> stateProvider.getProperty(component.getElement().getNode(), k)));
        this.addExtraProperties(component, properties);
        this.filterOutProperties(component, componentTypeAndSourceLocation.inheritanceChain(), properties);
        JavaComponent.Metadata copyMetadata = new JavaComponent.Metadata();
        try {
            copyMetadata = this.getCopyMetadata(componentTypeAndSourceLocation);
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
        }
        return new JavaComponent(this.getTag(componentTypeAndSourceLocation.inheritanceChain()), this.getFlowComponentClassName(componentTypeAndSourceLocation.inheritanceChain()), properties, componentTypeAndSourceLocation.children().stream().map(this::getCopiedJavaComponent).toList(), copyMetadata);
    }

    private String getFlowComponentClassName(List<Class> inheritanceChain) {
        for (Class aClass : inheritanceChain) {
            if (!aClass.getName().startsWith("com.vaadin.flow")) continue;
            return aClass.getName();
        }
        return inheritanceChain.get(0).getName();
    }

    private String getTag(List<Class> inheritanceChain) {
        for (Class aClass : inheritanceChain) {
            if (!aClass.getName().startsWith("com.vaadin.flow")) continue;
            return this.getTemplateTag(aClass.getSimpleName());
        }
        return this.getTemplateTag(inheritanceChain.get(0).getSimpleName());
    }

    private String getTemplateTag(String originalTag) {
        if ("RadioButtonGroup".equals(originalTag)) {
            return "RadioGroup";
        }
        if ("CheckBoxItem".equals(originalTag)) {
            return "Checkbox";
        }
        return originalTag;
    }

    private JavaComponent.Metadata getCopyMetadata(ComponentTypeAndSourceLocation componentTypeAndSourceLocation) throws IOException {
        JavaComponent.Metadata metadata = new JavaComponent.Metadata();
        if (componentTypeAndSourceLocation.createLocation().className().startsWith("com.vaadin.flow.data")) {
            return metadata;
        }
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(componentTypeAndSourceLocation.javaFile()));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        Optional.ofNullable(componentInfo.localVariableName()).ifPresent(metadata::setLocalVariableName);
        Optional.ofNullable(componentInfo.fieldName()).ifPresent(metadata::setFieldVariableName);
        metadata.setOriginalClassName(componentTypeAndSourceLocation.component().getClass().getName());
        return metadata;
    }

    private void addExtraProperties(Component component, Map<String, Object> properties) {
        HasText hasText;
        if (component instanceof HasText && !"".equals((hasText = (HasText)component).getText())) {
            properties.put("text", hasText.getText());
        }
        if ("com.vaadin.flow.component.html.Image".equals(component.getClass().getName())) {
            if (!properties.containsKey("src") && component.getElement().hasAttribute("src")) {
                properties.put("src", component.getElement().getAttribute("src"));
            }
            if (!properties.containsKey("alt") && component.getElement().hasAttribute("alt")) {
                properties.put("alt", component.getElement().getAttribute("alt"));
            }
        }
        if (component.getClass().getName().equals("com.vaadin.flow.component.radiobutton.RadioButton") && !properties.containsKey("label")) {
            component.getChildren().filter(child -> child.getClass().getName().equals("com.vaadin.flow.component.html.Label")).findFirst().ifPresent(label -> properties.put("label", label.getElement().getTextRecursively()));
        }
    }

    private void filterOutProperties(Component component, List<Class> inheritanceChain, Map<String, Object> properties) {
        boolean textFieldBase = inheritanceChain.stream().anyMatch(clazz -> clazz.getName().equals("com.vaadin.flow.component.textfield.TextFieldBase"));
        boolean select = "com.vaadin.flow.component.select.Select".equals(component.getClass().getName());
        boolean checkboxGroup = "com.vaadin.flow.component.checkbox.CheckboxGroup".equals(component.getClass().getName());
        boolean radioButtonGroup = "com.vaadin.flow.component.radiobutton.RadioButtonGroup".equals(component.getClass().getName());
        if (textFieldBase || select || checkboxGroup || radioButtonGroup) {
            properties.remove(VALUE_PROPERTY_KEY);
            properties.remove(INVALID_PROPERTY_KEY);
            properties.remove(ERROR_MESSAGE_PROPERTY_KEY);
            if (select) {
                properties.remove("opened");
            }
        }
        if ("com.vaadin.flow.component.checkbox.CheckboxGroup$CheckBoxItem".equals(component.getClass().getName())) {
            properties.remove("checked");
            properties.remove("disabled");
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

