/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.info;

import com.vaadin.flow.server.frontend.FrontendVersion;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record JdkInfo(boolean jrebel, boolean extendedClassDefCapable, boolean runningWithExtendClassDef, boolean hotswapAgentFound, String hotswapAgentLocation, boolean runningWitHotswap, boolean runningInJavaDebugMode, String hotswapVersion, boolean hotswapVersionOk) {
    public static JdkInfo get() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        boolean jrebel = System.getProperty("rebel.base") != null;
        boolean extendedClassDefCapable = runtimeMXBean.getVmVendor().contains("JetBrains");
        boolean runningWithExtendClassDef = inputArguments.contains("-XX:+AllowEnhancedClassRedefinition");
        boolean runningInJavaDebugMode = inputArguments.toString().toLowerCase(Locale.ENGLISH).contains("jdwp");
        List hotswapJavaAgent = inputArguments.stream().filter(arg -> arg.startsWith("-javaagent:")).filter(arg -> arg.endsWith("hotswap-agent.jar")).collect(Collectors.toList());
        File javaHome = new File(System.getProperty("java.home"));
        File hotswapAgentLocation = null;
        if (inputArguments.contains("-XX:HotswapAgent=fatjar")) {
            hotswapAgentLocation = new File(new File(new File(javaHome, "lib"), "hotswap"), "hotswap-agent.jar");
        } else if (!hotswapJavaAgent.isEmpty()) {
            hotswapAgentLocation = new File(((String)hotswapJavaAgent.get(0)).substring("-javaagent:".length()));
        }
        boolean runningWithHotswap = false;
        boolean hotswapAgentFound = false;
        String hotswapVersionString = null;
        String hotswapAgentJarPath = null;
        if (hotswapAgentLocation != null) {
            runningWithHotswap = true;
            hotswapAgentFound = hotswapAgentLocation.exists();
            hotswapVersionString = JdkInfo.getHotswapAgentVersionString(hotswapAgentLocation).orElse(null);
            hotswapAgentJarPath = hotswapAgentLocation.getAbsolutePath();
        }
        boolean hotswapVersionOk = JdkInfo.checkHotswapAgentVersion(hotswapVersionString);
        return new JdkInfo(jrebel, extendedClassDefCapable, runningWithExtendClassDef, hotswapAgentFound, hotswapAgentJarPath, runningWithHotswap, runningInJavaDebugMode, hotswapVersionString, hotswapVersionOk);
    }

    private static Optional<String> getHotswapAgentVersionString(File hotswapAgentLocation) {
        if (hotswapAgentLocation.exists()) {
            Optional<String> optional;
            JarFile jarFile = new JarFile(hotswapAgentLocation);
            try {
                optional = Optional.ofNullable(jarFile.getManifest().getMainAttributes().getValue("Implementation-Version"));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    JdkInfo.getLogger().error("No META-INF/MANIFEST.MF found in {}", (Object)hotswapAgentLocation, (Object)e);
                }
            }
            jarFile.close();
            return optional;
        }
        return Optional.empty();
    }

    private static boolean checkHotswapAgentVersion(String hotswapVersionString) {
        return JdkInfo.getHotswapAgentVersion(hotswapVersionString).map(frontendVersion -> frontendVersion.isEqualOrNewer(new FrontendVersion(2, 0, 0))).orElse(false);
    }

    private static Optional<FrontendVersion> getHotswapAgentVersion(String versionString) {
        if (versionString == null) {
            return Optional.empty();
        }
        String withoutSnapshot = versionString.replace("-SNAPSHOT", "");
        return Optional.of(new FrontendVersion(withoutSnapshot));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(JdkInfo.class);
    }
}

