/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.docs;

import com.vaadin.copilot.plugins.docs.DocsException;
import com.vaadin.copilot.plugins.docs.DocsMainSection;
import com.vaadin.copilot.plugins.docs.DocsRequest;
import com.vaadin.copilot.plugins.docs.DocsResponse;
import com.vaadin.copilot.plugins.docs.DocsSection;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocsDataLoader {
    private final Map<DocsRequest, DocsResponse> parsed = new WeakHashMap<DocsRequest, DocsResponse>();
    private final String TARGET = "target";
    private final Map<String, String> docTagNameReplacementMap = Map.of("avatar-group", "avatar", "checkbox-group", "checkbox", "radio-group", "radio-button", "chart", "charts");

    public DocsResponse get(DocsRequest docsRequest) throws DocsException {
        if (docsRequest.isCustomComponent()) {
            throw new DocsException(0);
        }
        if (!this.isVaadinComponent(docsRequest.getTag())) {
            throw new DocsException(1);
        }
        if (this.parsed.containsKey(docsRequest)) {
            return this.parsed.get(docsRequest);
        }
        this.fetchAndCache(docsRequest);
        return this.parsed.get(docsRequest);
    }

    private void fetchAndCache(DocsRequest docsRequest) throws DocsException {
        String url = this.getUrl(docsRequest.getTag());
        try {
            Document document = this.fetch(url);
            this.parsed.put(docsRequest, this.parse(document, url));
        }
        catch (HttpStatusException ex) {
            if (ex.getStatusCode() == 404) {
                throw new DocsException(404);
            }
            if (ex.getStatusCode() == 503) {
                throw new DocsException(503);
            }
            throw new DocsException(500);
        }
        catch (Exception ex) {
            throw new DocsException(500);
        }
    }

    private Document fetch(String url) throws IOException {
        return Jsoup.connect((String)url).timeout(10000).get();
    }

    private DocsResponse parse(Document document, String url) {
        DocsResponse docsResponse = new DocsResponse();
        docsResponse.setDocumentationPageUrl(url);
        Element mainElement = document.select("main").first();
        if (mainElement == null) {
            return docsResponse;
        }
        this.filterElements(mainElement);
        this.fixUrls(url, mainElement);
        this.replaceCodeBlocksShowExampleLinks(url, mainElement);
        Element header = mainElement.selectFirst("header");
        this.parseHeader(docsResponse, header);
        for (DocsMainSection mainSection : docsResponse.getMainSectionList()) {
            if (mainSection.getUrl() != null) {
                try {
                    Document mainSectionDoc = this.fetch(mainSection.getUrl());
                    Element main = mainSectionDoc.select("main").first();
                    if (main == null) continue;
                    this.filterElements(main);
                    this.fixUrls(mainSection.getUrl(), main);
                    this.replaceCodeBlocksShowExampleLinks(url, main);
                    this.parseSections(mainSection, main);
                }
                catch (Exception ex) {
                    this.getLogger().error(ex.getMessage(), (Throwable)ex);
                }
                continue;
            }
            this.parseSections(mainSection, mainElement);
        }
        this.parseLinks(docsResponse, header);
        this.filterSections(docsResponse);
        return docsResponse;
    }

    private void filterSections(DocsResponse docsResponse) {
        for (DocsMainSection mainSection : docsResponse.getMainSectionList()) {
            mainSection.getSections().removeIf(f -> StringUtils.equals((CharSequence)f.getTitle(), (CharSequence)"Related Components"));
        }
    }

    private void parseHeader(DocsResponse docsResponse, Element header) {
        if (header == null) {
            return;
        }
        Element mainSectionHeader = header.selectFirst("ul");
        if (mainSectionHeader == null) {
            docsResponse.getMainSectionList().add(new DocsMainSection("Usage"));
            return;
        }
        Elements mainSectionElements = mainSectionHeader.select("li");
        for (Element mainSectionElement : mainSectionElements) {
            Element element = mainSectionElement.firstElementChild();
            if (element == null) continue;
            DocsMainSection mainSection = new DocsMainSection();
            if ("span".equals(element.tagName())) {
                mainSection.setTitle(element.text());
            } else if ("a".equals(element.tagName())) {
                mainSection.setUrl(element.attr("href"));
                mainSection.setTitle(element.text());
            }
            docsResponse.getMainSectionList().add(mainSection);
        }
    }

    private void parseLinks(DocsResponse docsResponse, Element header) {
        if (header == null) {
            return;
        }
        Optional<Element> linksElement = this.findByClassNameContainsRecursively(header, "PageHeader-module--links");
        if (linksElement.isPresent()) {
            Elements links = linksElement.get().select("a");
            for (Element link : links) {
                if (link.hasAttr("target")) continue;
                link.attr("target", "_blank");
            }
            DocsMainSection linksSection = new DocsMainSection("Links");
            DocsSection section = new DocsSection();
            section.setLinks(true);
            section.setHtmlContent(linksElement.get().outerHtml());
            linksSection.getSections().add(section);
            docsResponse.getMainSectionList().add(linksSection);
        }
    }

    private void parseSections(DocsMainSection mainSection, Element mainElement) {
        Elements sectionElements = this.getSectionElements(mainElement);
        for (Element sectionElement : sectionElements) {
            Element first;
            DocsSection section = new DocsSection();
            Element maybeH2Element = sectionElement.firstElementChild();
            if (maybeH2Element != null && "h2".equals(maybeH2Element.tagName())) {
                section.setTitle(maybeH2Element.text());
            }
            if ((first = sectionElement.select("div.sectionbody").first()) != null) {
                section.setHtmlContent(first.outerHtml());
            }
            mainSection.getSections().add(section);
        }
    }

    private Elements getSectionElements(Element mainElement) {
        if (mainElement == null) {
            return new Elements();
        }
        Element article = mainElement.selectFirst("article");
        if (article == null) {
            return new Elements();
        }
        Element preamble = article.selectFirst("div#preamble");
        Elements sections = article.select("div.sect1");
        Elements elements = new Elements();
        if (preamble != null) {
            elements.add((Object)preamble);
        }
        elements.addAll((Collection)sections);
        return elements;
    }

    private void filterElements(Element mainElement) {
        Element discussionIdElement = mainElement.select("code.discussion-id").first();
        if (discussionIdElement != null && discussionIdElement.parent() != null) {
            if (discussionIdElement.parent().parent() != null) {
                discussionIdElement.parent().parent().remove();
            } else {
                discussionIdElement.parent().remove();
            }
        }
        Elements commercialNotes = mainElement.select("div.note.commercial");
        commercialNotes.remove();
    }

    private void fixUrls(String pageUrl, Element mainElement) {
        URI uri = URI.create(pageUrl);
        Elements anchors = mainElement.select("a");
        for (Element anchor : anchors) {
            if (anchor.hasAttr("href")) {
                String href = anchor.attr("href");
                if (href.startsWith("/")) {
                    String scheme = uri.getScheme();
                    String host = uri.getHost();
                    anchor.attr("href", scheme + "://" + host + href);
                } else if (href.startsWith("#")) {
                    anchor.attr("href", pageUrl + href);
                }
            }
            anchor.attr("target", "_blank");
        }
    }

    private boolean isVaadinComponent(String elementTagName) {
        return elementTagName.toLowerCase(Locale.ENGLISH).startsWith("vaadin");
    }

    private String getUrl(String elementTagName) {
        String docTagName = elementTagName.toLowerCase(Locale.ENGLISH).replace("vaadin-", "");
        if (this.docTagNameReplacementMap.containsKey(docTagName)) {
            docTagName = this.docTagNameReplacementMap.get(docTagName);
        }
        return "https://vaadin.com/docs/latest/components/" + docTagName + "?copilot-request";
    }

    private Optional<Element> findByClassNameContainsRecursively(Element parent, String className) {
        Element element;
        for (Node childNode : parent.childNodes()) {
            if (!(childNode instanceof Element) || !(element = (Element)childNode).className().contains(className)) continue;
            return Optional.of(element);
        }
        for (Node childNode : parent.childNodes()) {
            Optional<Element> foundInChild;
            if (!(childNode instanceof Element) || !(foundInChild = this.findByClassNameContainsRecursively(element = (Element)childNode, className)).isPresent()) continue;
            return foundInChild;
        }
        return Optional.empty();
    }

    private void replaceCodeBlocksShowExampleLinks(String pageUrl, Element mainElement) {
        Elements codeExampleDivs = mainElement.select("div.code-example");
        for (Element codeExampleDiv : codeExampleDivs) {
            for (Node childNode : codeExampleDiv.childNodes()) {
                childNode.remove();
            }
            Element anchorElement = new Element("a");
            Element showExample = anchorElement.text("Show Example");
            showExample.addClass("code-show-example");
            showExample.attr("target", "_blank");
            codeExampleDiv.appendChild((Node)anchorElement);
            String sectionAnchorHref = this.findSectionAnchorHref(codeExampleDiv);
            if (sectionAnchorHref != null) {
                showExample.attr("href", sectionAnchorHref);
                continue;
            }
            showExample.attr("href", pageUrl);
        }
    }

    private String findSectionAnchorHref(Element element) {
        for (Element siblingElement : element.siblingElements()) {
            if (!siblingElement.tagName().equals("h2") && !siblingElement.tagName().equals("h3") || siblingElement.selectFirst("a.anchor") == null) continue;
            return siblingElement.selectFirst("a.anchor").attr("href");
        }
        Element parent = element.parent();
        if (parent != null && !"main".equals(parent.tagName())) {
            return this.findSectionAnchorHref(parent);
        }
        return null;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

