/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.copilot.SpringBridge;
import com.vaadin.flow.server.VaadinServletContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;

public final class VsCodeUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String HOTCODE_REPLACE_KEY = "java.debug.settings.hotCodeReplace";
    private static final String LAUNCH_CONFIGURATION_NAME = "Launch using Hotswap Agent";
    private static final String MAIN_CLASS = "mainClass";

    private VsCodeUtil() {
    }

    public static void ensureAutoHotDeploy(File projectFolder) throws IOException {
        File settingsJson = new File(VsCodeUtil.getOrCreateVsCodeFolder(projectFolder), "settings.json");
        if (!settingsJson.exists()) {
            Files.writeString(settingsJson.toPath(), (CharSequence)"{}", new OpenOption[0]);
        }
        ObjectNode tree = (ObjectNode)objectMapper.readTree(settingsJson);
        tree.put(HOTCODE_REPLACE_KEY, "auto");
        objectMapper.writeValue(settingsJson, (Object)tree);
    }

    public static void addHotswapAgentLaunchConfiguration(File projectFolder, File javaExecutable, VaadinServletContext vaadinServletContext) throws IOException {
        File launchJson = new File(VsCodeUtil.getOrCreateVsCodeFolder(projectFolder), "launch.json");
        if (!launchJson.exists()) {
            Files.writeString(launchJson.toPath(), (CharSequence)"{\n  \"version\": \"0.2.0\",\n  \"configurations\": [\n  ]\n}\n", new OpenOption[0]);
        }
        ObjectNode tree = (ObjectNode)objectMapper.readTree(launchJson);
        ArrayNode confArray = (ArrayNode)tree.get("configurations");
        String mainClass = null;
        if (confArray == null) {
            confArray = objectMapper.createArrayNode();
            tree.set("configurations", (JsonNode)confArray);
        }
        int existingLaunchConfig = -1;
        for (int i = 0; i < confArray.size(); ++i) {
            ObjectNode launchConf = (ObjectNode)confArray.get(i);
            if (mainClass == null && launchConf.has(MAIN_CLASS)) {
                mainClass = launchConf.get(MAIN_CLASS).asText();
            }
            if (!launchConf.has("name") || !launchConf.get("name").asText().equals(LAUNCH_CONFIGURATION_NAME)) continue;
            existingLaunchConfig = i;
        }
        if (existingLaunchConfig != -1) {
            confArray.remove(existingLaunchConfig);
        }
        if (mainClass == null) {
            Class<?> appClass = SpringBridge.getApplicationClass(vaadinServletContext);
            mainClass = appClass != null ? appClass.getName() : "com.example.Application";
        }
        confArray.add(VsCodeUtil.createLaunchConf(javaExecutable.getAbsolutePath(), mainClass));
        objectMapper.writeValue(launchJson, (Object)tree);
    }

    private static File getOrCreateVsCodeFolder(File projectFolder) throws IOException {
        File vsCodeFolder = new File(projectFolder, ".vscode");
        if (!vsCodeFolder.exists() && !vsCodeFolder.mkdirs()) {
            throw new IOException("Unable to create folder " + vsCodeFolder.getAbsolutePath());
        }
        return vsCodeFolder;
    }

    private static JsonNode createLaunchConf(String javaExecutable, String mainClass) {
        ObjectNode launchConf = objectMapper.createObjectNode();
        launchConf.put("type", "java");
        launchConf.put("name", LAUNCH_CONFIGURATION_NAME);
        launchConf.put("javaExec", javaExecutable);
        launchConf.put("request", "launch");
        launchConf.put(MAIN_CLASS, mainClass);
        ArrayList<String> vmArgs = new ArrayList<String>();
        vmArgs.add("-XX:+AllowEnhancedClassRedefinition");
        vmArgs.add("-XX:+ClassUnloading");
        vmArgs.add("-XX:HotswapAgent=fatjar");
        launchConf.put("vmArgs", String.join((CharSequence)" ", vmArgs));
        return launchConf;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }
}

