/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaClassOrRecordRewriter;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class JavaDataProviderHandler {
    private final JavaRewriter javaRewriter;
    private final ComponentTypeAndSourceLocation typeAndSourceLocation;
    private final File sourceFile;

    public JavaDataProviderHandler(ProjectManager projectManager, ComponentTypeAndSourceLocation typeAndSourceLocation) throws IOException {
        this.typeAndSourceLocation = typeAndSourceLocation;
        ComponentTypeAndSourceLocation parent = typeAndSourceLocation.parent();
        if (parent == null) {
            throw new IllegalArgumentException("Could not find the parent of the component");
        }
        this.sourceFile = projectManager.getSourceFile(parent.createLocation());
        this.javaRewriter = new JavaRewriter(projectManager.readFile(this.sourceFile));
    }

    public static boolean isDataProviderItemChange(ComponentTypeAndSourceLocation componentTypeAndSourceLocation) {
        ComponentTracker.Location createLocation = componentTypeAndSourceLocation.createLocation();
        ComponentTracker.Location attachLocation = componentTypeAndSourceLocation.attachLocation();
        if (createLocation != null && attachLocation != null) {
            return createLocation.className().startsWith("com.vaadin.flow.data.provider") && attachLocation.className().startsWith("com.vaadin.flow.data.provider");
        }
        return false;
    }

    public JavaDataProviderHandlerResult handleSetComponentProperty(String property, String value) {
        if (!"label".equals(property)) {
            throw new IllegalArgumentException("Unknown property" + property);
        }
        ComponentInfo parentInfo = this.javaRewriter.findComponentInfo(this.typeAndSourceLocation.parent());
        Component component = this.typeAndSourceLocation.component();
        Object item = this.getItem(component);
        Optional<MethodCallExpr> setItemsCall = JavaRewriterUtil.findMethodCallStatements(parentInfo).stream().filter(f -> f.getNameAsString().equals("setItems")).findFirst();
        Expression expressionToReplace = setItemsCall.isPresent() ? this.findItemExpression((Expression)setItemsCall.get(), item) : this.findItemExpression((Expression)parentInfo.objectCreationExpr(), item);
        if (expressionToReplace == null) {
            throw new IllegalArgumentException("Could not find node to replace");
        }
        Expression expression = JavaRewriterUtil.toExpression(value);
        boolean replace = expressionToReplace.replace((Node)expression);
        if (!replace) {
            throw new IllegalArgumentException("Could not replace expression");
        }
        return new JavaDataProviderHandlerResult(this.sourceFile, this.javaRewriter.getResult());
    }

    private Expression findItemExpression(Expression searchExpression, Object item) {
        ArrayList argsToSearch = new ArrayList();
        if (searchExpression.isMethodCallExpr()) {
            argsToSearch = new ArrayList(searchExpression.asMethodCallExpr().getArguments());
        } else if (searchExpression.isObjectCreationExpr() && !(argsToSearch = new ArrayList(searchExpression.asObjectCreationExpr().getArguments())).isEmpty()) {
            argsToSearch.remove(0);
        }
        Expression searchingExpression = JavaRewriterUtil.toExpression(item);
        for (Expression arg : argsToSearch) {
            if (!JavaRewriterUtil.typesEqual(arg.calculateResolvedType(), item.getClass()) || !JavaRewriterUtil.equalsByNameAsString(searchingExpression, arg)) continue;
            return arg;
        }
        return null;
    }

    private Object getItem(Component component) {
        try {
            Field item = component.getClass().getDeclaredField("item");
            item.setAccessible(true);
            return item.get(component);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not find item of the component", ex);
        }
    }

    public static void handleDataStatementsAndClearDataProps(CompilationUnit compilationUnit, VariableDeclarator parentVarDec, JavaComponent javaComponent, InsertionPoint insertionPoint) {
        List<JavaComponent> itemComponents = javaComponent.children().stream().filter(child -> FlowComponentQuirks.isChildGeneratesLabelAndValueStmts(javaComponent, child)).toList();
        if (!itemComponents.isEmpty()) {
            JavaDataProviderHandler.addLabelValueDataStatements(compilationUnit, parentVarDec, javaComponent.children(), insertionPoint);
            javaComponent.children().removeAll(itemComponents);
        }
    }

    private static void addLabelValueDataStatements(CompilationUnit compilationUnit, VariableDeclarator parentVarDec, List<JavaComponent> children, InsertionPoint insertionPoint) {
        JavaClassOrRecordRewriter javaClassOrRecordRewriter = new JavaClassOrRecordRewriter(compilationUnit);
        String recordName = javaClassOrRecordRewriter.addOrGetLabelValueEnabledRecordName();
        ClassOrInterfaceType recordType = new ClassOrInterfaceType();
        recordType.setName(recordName);
        JavaDataProviderHandler.updateVarDeclarationByAddingType(parentVarDec, recordType);
        boolean anyDisabled = false;
        MethodCallExpr setItemCallExpr = new MethodCallExpr((Expression)parentVarDec.getNameAsExpression(), "setItems");
        for (JavaComponent child : children) {
            String label = null;
            anyDisabled = child.props().containsKey("disabled") || anyDisabled;
            NodeList args = new NodeList();
            ObjectCreationExpr newItemExpr = new ObjectCreationExpr(null, recordType, args);
            if (child.props().containsKey("label")) {
                label = (String)child.props().get("label");
            } else if (child.props().containsKey("text")) {
                label = (String)child.props().get("text");
            }
            String value = child.props().containsKey("value") ? (String)child.props().get("value") : label;
            if (label == null) {
                throw new IllegalArgumentException("Unknown property. Label cannot be null");
            }
            args.add((Node)new StringLiteralExpr(label));
            args.add((Node)new StringLiteralExpr(value));
            if (child.props().containsKey("disabled")) {
                args.add((Node)new BooleanLiteralExpr(false));
            }
            setItemCallExpr.addArgument((Expression)newItemExpr);
        }
        insertionPoint.add((Statement)new ExpressionStmt((Expression)setItemCallExpr));
        JavaDataProviderHandler.addSetItemLabelGeneratorStmt(parentVarDec, insertionPoint, recordType);
        if (anyDisabled) {
            JavaDataProviderHandler.addSetItemEnabledProviderMethodExpr(parentVarDec, insertionPoint, recordType);
        }
    }

    private static void addSetItemLabelGeneratorStmt(VariableDeclarator variableDeclarator, InsertionPoint insertionPoint, ClassOrInterfaceType recordType) {
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)variableDeclarator.getNameAsExpression(), "setItemLabelGenerator");
        MethodReferenceExpr methodReferenceExpr = new MethodReferenceExpr();
        methodReferenceExpr.setScope((Expression)new NameExpr(recordType.getName()));
        methodReferenceExpr.setIdentifier("label");
        methodCallExpr.addArgument((Expression)methodReferenceExpr);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)methodCallExpr));
    }

    private static void addSetItemEnabledProviderMethodExpr(VariableDeclarator variableDeclarator, InsertionPoint insertionPoint, ClassOrInterfaceType recordType) {
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)variableDeclarator.getNameAsExpression(), "setItemEnabledProvider");
        MethodReferenceExpr methodReferenceExpr = new MethodReferenceExpr();
        methodReferenceExpr.setScope((Expression)new NameExpr(recordType.getName()));
        methodReferenceExpr.setIdentifier("enabled");
        methodCallExpr.addArgument((Expression)methodReferenceExpr);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)methodCallExpr));
    }

    private static void updateVarDeclarationByAddingType(VariableDeclarator parentVarDec, ClassOrInterfaceType type) {
        Type type2 = parentVarDec.getType();
        if (!(type2 instanceof ClassOrInterfaceType)) {
            throw new IllegalArgumentException("Unknown variable " + String.valueOf(parentVarDec.getType()));
        }
        ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)type2;
        classOrInterfaceType.setTypeArguments(new Type[]{type});
    }

    public record JavaDataProviderHandlerResult(File file, String result) {
    }
}

