/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.vaadin.copilot.javarewriter.AttachExpression;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.component.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record ComponentInfo(Class<? extends Component> type, ObjectCreationExpr objectCreationExpr, BlockStmt componentCreateScope, AttachExpression attachCall, BlockStmt componentAttachScope, VariableDeclarator localVariableDeclarator, AssignExpr assignmentExpression, FieldDeclaration fieldDeclaration, FieldDeclaration fieldDeclarationAndAssignment, String localVariableName, String fieldName, ConstructorDeclaration routeConstructor, boolean containerComposite, JavaRewriter rewriter) {
    public static ComponentInfo find(ComponentTypeAndSourceLocation typeAndSourceLocation, JavaRewriter javaRewriter) {
        MethodCallExpr methodCallExpr;
        Optional<BlockStmt> componentAttachScope;
        AttachExpression attachCall;
        Optional<FieldDeclaration> fieldDeclarationAndAssignment;
        CompilationUnit compilationUnit = javaRewriter.compilationUnit;
        List<ObjectCreationExpr> objectCreationExprs = JavaRewriterUtil.findNodesOfType((Node)compilationUnit, typeAndSourceLocation.createLocation().lineNumber(), ObjectCreationExpr.class, node -> node.getType().asClassOrInterfaceType().getName().asString().equals(typeAndSourceLocation.type().getSimpleName()));
        if (objectCreationExprs.size() > 1) {
            throw new IllegalArgumentException("There are multiple components created on the given line and we are unable to determine which one to modify");
        }
        Optional<Object> objectCreationExpr = Optional.ofNullable(objectCreationExprs.isEmpty() ? null : objectCreationExprs.get(0));
        boolean routeClass = false;
        boolean compositeContainer = false;
        if (objectCreationExpr.isEmpty() && !(routeClass = JavaRewriterUtil.isRouteClass(typeAndSourceLocation, compilationUnit))) {
            throw new IllegalArgumentException("Constructor not found at the expected location: " + String.valueOf(typeAndSourceLocation.createLocation()));
        }
        Optional<BlockStmt> componentCreateScope = objectCreationExpr.map(JavaRewriterUtil::findBlock);
        Optional<Object> localVariableDeclarator = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, VariableDeclarator.class));
        Optional<AssignExpr> assignmentExpression = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, AssignExpr.class));
        Optional<FieldDeclaration> fieldDeclaration = fieldDeclarationAndAssignment = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, FieldDeclaration.class));
        if (localVariableDeclarator.isPresent() && fieldDeclarationAndAssignment.isPresent()) {
            localVariableDeclarator = Optional.empty();
        }
        String localVariableName = null;
        String fieldName = null;
        if (localVariableDeclarator.isPresent()) {
            localVariableName = ((VariableDeclarator)localVariableDeclarator.get()).getNameAsString();
        } else if (fieldDeclarationAndAssignment.isPresent()) {
            fieldName = fieldDeclarationAndAssignment.get().getVariable(0).getNameAsString();
        } else if (assignmentExpression.isPresent()) {
            String localVariableOrFieldName = assignmentExpression.get().getTarget().asNameExpr().getNameAsString();
            if (componentCreateScope.isPresent() && JavaRewriterUtil.findLocalVariableDeclarator(localVariableOrFieldName, componentCreateScope.get()) != null) {
                localVariableName = localVariableOrFieldName;
            } else {
                fieldName = localVariableOrFieldName;
                fieldDeclaration = Optional.ofNullable(JavaRewriterUtil.findFieldDeclaration((Node)assignmentExpression.get(), fieldName));
            }
        }
        Optional<MethodCallExpr> attachMethodCall = JavaRewriterUtil.findNodeOfType((Node)compilationUnit, typeAndSourceLocation.attachLocation().lineNumber(), MethodCallExpr.class);
        if (attachMethodCall.isEmpty() && !routeClass) {
            Optional<ObjectCreationExpr> attachObjectCreationCall = JavaRewriterUtil.findNodeOfType((Node)compilationUnit, typeAndSourceLocation.attachLocation().lineNumber(), ObjectCreationExpr.class);
            if (attachObjectCreationCall.isEmpty() && !routeClass) {
                String varName = localVariableName != null ? localVariableName : fieldName;
                Optional<AttachExpression> possibleAttachExpressionFromParentInfo = ComponentInfo.findPossibleAttachExpressionFromParentInfo(typeAndSourceLocation, objectCreationExpr.orElse(null), varName, javaRewriter);
                if (possibleAttachExpressionFromParentInfo.isEmpty()) {
                    throw new IllegalArgumentException("Attach not found at the expected location: " + String.valueOf(typeAndSourceLocation.attachLocation()));
                }
                attachCall = possibleAttachExpressionFromParentInfo.get();
                componentAttachScope = Optional.of(JavaRewriterUtil.findBlock(possibleAttachExpressionFromParentInfo.get().getNode()));
            } else {
                componentAttachScope = attachObjectCreationCall.map(JavaRewriterUtil::findBlock);
                attachCall = new AttachExpression(attachObjectCreationCall.orElse(null));
            }
        } else {
            componentAttachScope = attachMethodCall.map(JavaRewriterUtil::findBlock);
            attachCall = new AttachExpression(attachMethodCall.orElse(null));
        }
        Optional<Object> routeConstructor = Optional.empty();
        if (routeClass && (routeConstructor = JavaRewriterUtil.findNodeOfType((Node)compilationUnit, typeAndSourceLocation.createLocation().lineNumber(), ConstructorDeclaration.class)).isEmpty()) {
            List constructors = compilationUnit.findAll(ConstructorDeclaration.class);
            if (constructors.isEmpty()) {
                routeConstructor = Optional.of((ConstructorDeclaration)((ConstructorDeclaration)new ConstructorDeclaration().setName(typeAndSourceLocation.type().getSimpleName())).setPublic(true));
                String className = typeAndSourceLocation.type().getSimpleName();
                ClassOrInterfaceDeclaration classDeclaration = compilationUnit.findAll(ClassOrInterfaceDeclaration.class).stream().filter(c -> c.getNameAsString().equals(className)).findFirst().orElseThrow(() -> new IllegalArgumentException("Class " + className + "not found"));
                classDeclaration.addMember((BodyDeclaration)routeConstructor.get());
            } else {
                throw new IllegalArgumentException("Route class has constructors but none at the expected location: " + String.valueOf(typeAndSourceLocation.createLocation()));
            }
        }
        if ((compositeContainer = ComponentInfo.isChildOfCompositeContainer(attachCall.expression())) && attachCall.expression().isMethodCallExpr() && (methodCallExpr = attachCall.getMethodCallExpression()) != null && methodCallExpr.getNameAsString().equals("getContent") && methodCallExpr.getParentNode().isPresent()) {
            attachCall = new AttachExpression((Expression)methodCallExpr.getParentNode().get());
        }
        return new ComponentInfo(typeAndSourceLocation.type(), objectCreationExpr.orElse(null), componentCreateScope.orElse(null), attachCall, componentAttachScope.orElse(null), localVariableDeclarator.orElse(null), assignmentExpression.orElse(null), fieldDeclaration.orElse(null), fieldDeclarationAndAssignment.orElse(null), localVariableName, fieldName, routeConstructor.orElse(null), compositeContainer, javaRewriter);
    }

    private static boolean isChildOfCompositeContainer(Expression attachCallExpr) {
        if (attachCallExpr == null) {
            return false;
        }
        ClassOrInterfaceDeclaration classDefinition = JavaRewriterUtil.findAncestorOrThrow((Node)attachCallExpr, ClassOrInterfaceDeclaration.class);
        return classDefinition.getExtendedTypes().stream().anyMatch(type -> type.getNameAsString().equals("Composite"));
    }

    private static Optional<AttachExpression> findPossibleAttachExpressionFromParentInfo(ComponentTypeAndSourceLocation componentTypeAndSourceLocation, ObjectCreationExpr objectCreationExpr, String varName, JavaRewriter javaRewriter) {
        if (componentTypeAndSourceLocation.parent() == null) {
            return Optional.empty();
        }
        ArrayList<Object> possibleArgs = new ArrayList<Object>();
        if (varName != null) {
            possibleArgs.add(new NameExpr(varName));
        }
        if (objectCreationExpr != null) {
            possibleArgs.add(objectCreationExpr);
        }
        if (possibleArgs.isEmpty()) {
            return Optional.empty();
        }
        ComponentTypeAndSourceLocation parent = componentTypeAndSourceLocation.parent();
        ComponentInfo componentInfo = ComponentInfo.find(parent, javaRewriter);
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        return methodCallStatements.stream().filter(f -> {
            if (!f.getNameAsString().equals("add")) return false;
            if (!f.getArguments().stream().anyMatch(possibleArgs::contains)) return false;
            return true;
        }).findFirst().map(AttachExpression::new);
    }
}

