/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vaadin.copilot.Copilot;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopilotServerClient {
    private static final String SERVER_PORT_ENV = "COPILOT_SERVER_PORT";
    protected static final String SERVER_URL_ENV = "copilot.serverBaseUrl";
    private static String serverBaseUrlCache = null;
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CopilotServerClient() {
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpRequest buildRequest(URI uri, String json) {
        return HttpRequest.newBuilder().uri(uri).POST(HttpRequest.BodyPublishers.ofString(json)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(120L)).build();
    }

    protected String writeAsJsonString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid data", e);
        }
    }

    protected <T> T readValue(String string, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(string, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid data", e);
        }
    }

    protected URI getQueryURI(String path) {
        try {
            return new URI(this.getServerBaseUrl() + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid server configuration, server uri is wrong", e);
        }
    }

    protected String getServerBaseUrl() {
        if (serverBaseUrlCache != null) {
            return serverBaseUrlCache;
        }
        serverBaseUrlCache = System.getenv(SERVER_URL_ENV);
        if (serverBaseUrlCache != null) {
            return serverBaseUrlCache;
        }
        if (Copilot.isDevelopmentMode()) {
            try {
                Integer serverPort = Optional.ofNullable(System.getenv(SERVER_PORT_ENV)).map(Integer::parseInt).orElse(8081);
                String localhostUrl = "http://localhost:%s/v1/".formatted(serverPort);
                String statusUrl = localhostUrl + "actuator/health";
                HttpRequest request = HttpRequest.newBuilder().uri(new URI(statusUrl)).timeout(Duration.ofSeconds(1L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    this.getLogger().info("Using the local server for development.");
                    return localhostUrl;
                }
            }
            catch (InterruptedException e) {
                this.getLogger().warn("Interrupted while trying to reach the local server.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.getLogger().warn("No local server found, as this exception occurred while trying to reach the local server: {}.", e.getClass());
            }
            this.getLogger().info("Using the staging server for development.");
            serverBaseUrlCache = "https://copilot.stg.vaadin.com/v1/";
            return serverBaseUrlCache;
        }
        serverBaseUrlCache = "https://copilot.vaadin.com/v1/";
        return serverBaseUrlCache;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

