/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.vaadin.copilot.javarewriter.ConstructorAnalyzer;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.LumoRewriterUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.JsonArray;
import elemental.json.JsonBoolean;
import elemental.json.JsonNull;
import elemental.json.JsonNumber;
import elemental.json.JsonObject;
import elemental.json.JsonString;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRewriter {
    private final String source;
    private final ParserConfiguration parserConfiguration = new ParserConfiguration();
    protected CompilationUnit compilationUnit;

    public JavaRewriter(String source) {
        this.source = source;
        this.parseSource(source);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private void parseSource(String source) {
        this.parserConfiguration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ReflectionTypeSolver(false));
        JavaSymbolSolver symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        this.parserConfiguration.setSymbolResolver((SymbolResolver)symbolSolver);
        StaticJavaParser.setConfiguration((ParserConfiguration)this.parserConfiguration);
        this.compilationUnit = (CompilationUnit)LexicalPreservingPrinter.setup((Node)StaticJavaParser.parse((String)source));
    }

    public String getResult() {
        return LexicalPreservingPrinter.print((Node)this.compilationUnit);
    }

    public int getFirstModifiedRow() {
        int row = 1;
        for (int i = 0; i < this.source.length(); ++i) {
            if (this.source.charAt(i) != this.getResult().charAt(i)) {
                return row;
            }
            if (this.source.charAt(i) != '\n') continue;
            ++row;
        }
        return -1;
    }

    public boolean replaceFunctionCall(ComponentInfo componentInfo, String function, Object value) {
        if (this.replaceConstructorParam(componentInfo, function, value)) {
            return true;
        }
        return this.replaceOrAddCall(componentInfo, function, value);
    }

    private boolean replaceConstructorParam(ComponentInfo componentInfo, String function, Object value) {
        Optional<Map.Entry> mapping;
        ObjectCreationExpr objectCreationExpr = componentInfo.objectCreationExpr();
        Optional<Constructor<?>> constructor = this.findConstructor(componentInfo.type(), objectCreationExpr);
        Optional<Map> mappings = constructor.map(c -> ConstructorAnalyzer.get().getMappings((Constructor<?>)c));
        if (mappings.isPresent() && (mapping = mappings.get().entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(function)).findFirst()).isPresent()) {
            objectCreationExpr.setArgument(((Integer)mapping.get().getKey()).intValue(), JavaRewriterUtil.toExpression(value));
            return true;
        }
        return false;
    }

    private String getMappedProperty(Constructor<?> c, int propertyIndex) {
        return ConstructorAnalyzer.get().getMappings(c).entrySet().stream().filter(entry -> (Integer)entry.getKey() == propertyIndex).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private Optional<Constructor<?>> findConstructor(Class<? extends Component> componentType, ObjectCreationExpr objectCreationExpr) {
        try {
            ResolvedConstructorDeclaration resolved = objectCreationExpr.resolve();
            List<Constructor> candidates = Arrays.stream(componentType.getDeclaredConstructors()).filter(c -> c.getParameterCount() == resolved.getNumberOfParams()).filter(c -> {
                for (int i = 0; i < resolved.getNumberOfParams(); ++i) {
                    ResolvedType paramType = resolved.getParam(i).getType();
                    if (JavaRewriterUtil.typesEqual(paramType, c.getParameterTypes()[i])) continue;
                    return false;
                }
                return true;
            }).toList();
            if (candidates.isEmpty()) {
                return Optional.empty();
            }
            if (candidates.size() > 1) {
                this.getLogger().warn("Multiple constructors found for {}: {}", componentType, candidates);
                return Optional.empty();
            }
            return Optional.of(candidates.get(0));
        }
        catch (UnsolvedSymbolException e) {
            this.getLogger().error("Unable to resolve constructor for {}: {}", new Object[]{componentType, objectCreationExpr, e});
            return Optional.empty();
        }
    }

    public boolean addCall(ComponentInfo componentInfo, String function, Object ... parameters) {
        return this.doReplaceOrAddCall(componentInfo, function, false, parameters);
    }

    public boolean replaceOrAddCall(ComponentInfo componentInfo, String function, Object ... parameters) {
        return this.doReplaceOrAddCall(componentInfo, function, true, parameters);
    }

    private boolean doReplaceOrAddCall(ComponentInfo componentInfo, String function, boolean replace, Object ... parameters) {
        ExtractInlineVariableResult extractInlineVariableResult;
        ArrayList<Expression> parameterExpressions = new ArrayList<Expression>();
        for (Object parameter : parameters) {
            parameterExpressions.add(JavaRewriterUtil.toExpression(parameter));
        }
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        MethodCallExpr functionCall = functionCalls.stream().filter(m -> m.getNameAsString().equals(function)).findFirst().orElse(null);
        if (replace && functionCall != null) {
            if (parameterExpressions.size() == 1) {
                functionCall.setArgument(0, (Expression)parameterExpressions.get(0));
            }
            return true;
        }
        if (!functionCalls.isEmpty() && JavaRewriterUtil.addAfterLastFunctionCall(functionCalls, function, parameterExpressions.toArray(new Expression[0]))) {
            return true;
        }
        int addAfterStatementIndex = -1;
        BlockStmt scope = componentInfo.componentCreateScope;
        if (componentInfo.localVariableDeclarator != null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex((Node)componentInfo.localVariableDeclarator);
        } else if (componentInfo.fieldDeclaration != null && componentInfo.fieldDeclarationAndAssignment == null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex((Node)componentInfo.assignmentExpression);
        } else if (componentInfo.fieldDeclarationAndAssignment != null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex((Node)componentInfo.attachCall) - 1;
            scope = componentInfo.componentAttachScope;
        }
        if (addAfterStatementIndex >= 0) {
            NameExpr variable = new NameExpr(JavaRewriterUtil.getFieldOrVariableName(componentInfo));
            MethodCallExpr newCall = new MethodCallExpr((Expression)variable, function);
            parameterExpressions.forEach(arg_0 -> ((MethodCallExpr)newCall).addArgument(arg_0));
            scope.addStatement(addAfterStatementIndex + 1, (Statement)new ExpressionStmt((Expression)newCall));
            return true;
        }
        if (JavaRewriterUtil.inlineAssignment(componentInfo) && (extractInlineVariableResult = JavaRewriterUtil.extractInlineVariableToLocalVariable(componentInfo)) != null) {
            MethodCallExpr newCall = new MethodCallExpr((Expression)new NameExpr(extractInlineVariableResult.newVariableName()), function);
            parameterExpressions.forEach(arg_0 -> ((MethodCallExpr)newCall).addArgument(arg_0));
            extractInlineVariableResult.blockStmt.addStatement(extractInlineVariableResult.index + 1, (Expression)newCall);
            return true;
        }
        throw new IllegalStateException("Unable to determine where to add function call");
    }

    public Object getPropertyValue(ComponentInfo componentInfo, String property) {
        Optional<Constructor<?>> maybeConstructor;
        String setterName = JavaRewriterUtil.getSetterName(property, componentInfo.type(), false);
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        List<MethodCallExpr> candidates = functionCalls.stream().filter(m -> m.getNameAsString().equals(setterName)).toList();
        if (!candidates.isEmpty()) {
            MethodCallExpr setterCall = candidates.get(candidates.size() - 1);
            Expression arg = (Expression)setterCall.getArguments().get(0);
            return JavaRewriterUtil.fromExpression(arg, setterCall.resolve().getParam(0).getType());
        }
        ObjectCreationExpr createExpression = componentInfo.objectCreationExpr();
        if (createExpression != null && (maybeConstructor = this.findConstructor(componentInfo.type(), createExpression)).isPresent()) {
            Constructor<?> constructor = maybeConstructor.get();
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                String mappedProperty = this.getMappedProperty(constructor, i);
                if (!setterName.equals(mappedProperty)) continue;
                return JavaRewriterUtil.fromExpression(createExpression.getArgument(i), createExpression.resolve().getParam(i).getType());
            }
        }
        return null;
    }

    public ComponentInfo findComponentInfo(ComponentTypeAndSourceLocation typeAndSourceLocation) {
        Optional<FieldDeclaration> fieldDeclarationAndAssignment;
        List<ObjectCreationExpr> objectCreationExprs = JavaRewriterUtil.findNodesOfType((Node)this.compilationUnit, typeAndSourceLocation.createLocation().lineNumber(), ObjectCreationExpr.class, node -> node.getType().asClassOrInterfaceType().getName().asString().equals(typeAndSourceLocation.type().getSimpleName()));
        if (objectCreationExprs.size() > 1) {
            throw new IllegalArgumentException("There are multiple components created on the given line and we are unable to determine which one to modify");
        }
        Optional<Object> objectCreationExpr = Optional.ofNullable(objectCreationExprs.isEmpty() ? null : objectCreationExprs.get(0));
        boolean routeClass = false;
        if (objectCreationExpr.isEmpty() && !(routeClass = this.isRouteClass(typeAndSourceLocation))) {
            throw new IllegalArgumentException("Constructor not found at the expected location: " + String.valueOf(typeAndSourceLocation.createLocation()));
        }
        Optional<BlockStmt> componentCreateScope = objectCreationExpr.map(JavaRewriterUtil::findBlock);
        Optional<MethodCallExpr> attachCall = JavaRewriterUtil.findNodeOfType((Node)this.compilationUnit, typeAndSourceLocation.attachLocation().lineNumber(), MethodCallExpr.class);
        if (attachCall.isEmpty() && !routeClass) {
            throw new IllegalArgumentException("Attach not found at the expected location: " + String.valueOf(typeAndSourceLocation.attachLocation()));
        }
        Optional<BlockStmt> componentAttachScope = attachCall.map(JavaRewriterUtil::findBlock);
        Optional<Object> localVariableDeclarator = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, VariableDeclarator.class));
        Optional<AssignExpr> assignmentExpression = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, AssignExpr.class));
        Optional<FieldDeclaration> fieldDeclaration = fieldDeclarationAndAssignment = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, FieldDeclaration.class));
        if (localVariableDeclarator.isPresent() && fieldDeclarationAndAssignment.isPresent()) {
            localVariableDeclarator = Optional.empty();
        }
        String localVariableName = null;
        String fieldName = null;
        if (localVariableDeclarator.isPresent()) {
            localVariableName = ((VariableDeclarator)localVariableDeclarator.get()).getNameAsString();
        } else if (fieldDeclarationAndAssignment.isPresent()) {
            fieldName = fieldDeclarationAndAssignment.get().getVariable(0).getNameAsString();
        } else if (assignmentExpression.isPresent()) {
            String localVariableOrFieldName = assignmentExpression.get().getTarget().asNameExpr().getNameAsString();
            if (componentCreateScope.isPresent() && JavaRewriterUtil.findLocalVariableDeclarator(localVariableOrFieldName, componentCreateScope.get()) != null) {
                localVariableName = localVariableOrFieldName;
            } else {
                fieldName = localVariableOrFieldName;
                fieldDeclaration = Optional.ofNullable(JavaRewriterUtil.findFieldDeclaration((Node)assignmentExpression.get(), fieldName));
            }
        }
        Optional<Object> routeConstructor = Optional.empty();
        if (routeClass && (routeConstructor = JavaRewriterUtil.findNodeOfType((Node)this.compilationUnit, typeAndSourceLocation.createLocation().lineNumber(), ConstructorDeclaration.class)).isEmpty()) {
            List constructors = this.compilationUnit.findAll(ConstructorDeclaration.class);
            if (constructors.isEmpty()) {
                routeConstructor = Optional.of((ConstructorDeclaration)((ConstructorDeclaration)new ConstructorDeclaration().setName(typeAndSourceLocation.type().getSimpleName())).setPublic(true));
                String className = typeAndSourceLocation.type().getSimpleName();
                ClassOrInterfaceDeclaration classDeclaration = this.compilationUnit.findAll(ClassOrInterfaceDeclaration.class).stream().filter(c -> c.getNameAsString().equals(className)).findFirst().orElseThrow(() -> new IllegalArgumentException("Class " + className + "not found"));
                classDeclaration.addMember((BodyDeclaration)routeConstructor.get());
            } else {
                throw new IllegalArgumentException("Route class has constructors but none at the expected location: " + String.valueOf(typeAndSourceLocation.createLocation()));
            }
        }
        return new ComponentInfo(typeAndSourceLocation.type(), objectCreationExpr.orElse(null), componentCreateScope.orElse(null), attachCall.orElse(null), componentAttachScope.orElse(null), localVariableDeclarator.orElse(null), assignmentExpression.orElse(null), fieldDeclaration.orElse(null), fieldDeclarationAndAssignment.orElse(null), localVariableName, fieldName, routeConstructor.orElse(null), this);
    }

    private boolean isRouteClass(ComponentTypeAndSourceLocation typeAndSourceLocation) {
        if (!typeAndSourceLocation.createLocation.equals((Object)typeAndSourceLocation.attachLocation)) {
            return false;
        }
        return typeAndSourceLocation.attachLocation().methodName().equals("<init>");
    }

    public boolean delete(ComponentInfo componentInfo) {
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        List<MethodCallExpr> otherMethodCalls = JavaRewriterUtil.findMethodCallNonStatements(componentInfo);
        functionCalls.forEach(expr -> JavaRewriterUtil.findAncestorOrThrow((Node)expr, Statement.class).remove());
        if (componentInfo.fieldDeclaration != null) {
            componentInfo.fieldDeclaration.remove();
            if (componentInfo.fieldDeclarationAndAssignment == null) {
                JavaRewriterUtil.removeStatement((Node)componentInfo.objectCreationExpr());
            }
        } else if (componentInfo.localVariableDeclarator != null) {
            JavaRewriterUtil.removeStatement((Node)componentInfo.localVariableDeclarator);
        }
        otherMethodCalls.forEach(methodCall -> {
            if (!JavaRewriterUtil.removeFromStringConcatenation((Node)methodCall)) {
                JavaRewriterUtil.removeStatement((Node)methodCall);
            }
        });
        this.removeAttachCall(componentInfo);
        List<Expression> parameterUsage = JavaRewriterUtil.findParameterUsage(componentInfo);
        parameterUsage.forEach(expr -> {
            if (JavaRewriterUtil.hasAncestor((Node)expr, Statement.class)) {
                JavaRewriterUtil.removeStatement((Node)expr);
            }
        });
        return true;
    }

    private Optional<Expression> removeAttachCall(ComponentInfo componentInfo) {
        Optional<Expression> addArgument = JavaRewriterUtil.getAttachArgument(componentInfo);
        addArgument.ifPresent(Node::remove);
        if (componentInfo.attachCall() != null && componentInfo.attachCall().getArguments().isEmpty()) {
            JavaRewriterUtil.removeStatement((Node)componentInfo.attachCall());
        }
        return addArgument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveComponent(ComponentInfo component, ComponentInfo container, ComponentInfo reference, Where where) {
        ObjectCreationExpr toAdd;
        if (container == null) {
            throw new IllegalArgumentException("Container component must be non-null");
        }
        if (component.equals(container) || component.equals(reference) || container.equals(reference)) {
            throw new IllegalArgumentException("Component, container and reference must be different");
        }
        this.removeAttachCall(component);
        List<MethodCallExpr> containerFunctionCalls = JavaRewriterUtil.findMethodCallStatements(container);
        String componentFieldOrVariableName = JavaRewriterUtil.getFieldOrVariableName(component);
        Object object = toAdd = componentFieldOrVariableName == null ? component.objectCreationExpr() : new NameExpr(componentFieldOrVariableName);
        if (where == Where.APPEND) {
            if (reference != null) {
                throw new IllegalArgumentException("Reference component must be null when appending");
            }
            boolean added = JavaRewriterUtil.addAfterLastFunctionCall(containerFunctionCalls, "add", new Expression[]{toAdd});
            if (added) return;
            throw new IllegalArgumentException("No add call found for the container component");
        }
        if (where != Where.BEFORE) throw new IllegalArgumentException("Unknown where: " + String.valueOf((Object)where));
        if (reference == null) {
            throw new IllegalArgumentException("Reference component must be non-null when moving before");
        }
        Optional<Expression> referenceAddArgument = JavaRewriterUtil.findReference((NodeList<Expression>)reference.attachCall().getArguments(), reference);
        if (!referenceAddArgument.isPresent()) throw new IllegalArgumentException("Reference component not found in the add call");
        int refAddIndex = reference.attachCall().getArguments().indexOf((Object)referenceAddArgument.get());
        reference.attachCall().getArguments().add(refAddIndex, (Node)toAdd);
        List<MethodCallExpr> componentFunctionCalls = JavaRewriterUtil.findMethodCallStatements(component);
        if (componentFunctionCalls.isEmpty()) return;
        MethodCallExpr lastCall = componentFunctionCalls.get(componentFunctionCalls.size() - 1);
        BlockStmt insertBlock = JavaRewriterUtil.findAncestorOrThrow((Node)lastCall, BlockStmt.class);
        int finalAddLocation = JavaRewriterUtil.findBlockStatementIndex((Node)lastCall) + 1;
        int attachCallIndex = JavaRewriterUtil.findBlockStatementIndex((Node)reference.attachCall());
        List<MethodCallExpr> allAddCalls = containerFunctionCalls.stream().filter(m -> m.getNameAsString().equals(reference.attachCall().getName().asString())).toList();
        for (MethodCallExpr addCall : allAddCalls) {
            int addCallIndex = JavaRewriterUtil.findBlockStatementIndex((Node)addCall);
            if (addCallIndex < attachCallIndex || addCallIndex >= finalAddLocation) continue;
            Statement statement = JavaRewriterUtil.findAncestorOrThrow((Node)addCall, Statement.class);
            statement.remove();
            insertBlock.addStatement(finalAddLocation - 1, statement);
        }
    }

    public void duplicate(ComponentInfo component) {
        if (component.routeConstructor() != null) {
            throw new IllegalArgumentException("Cannot duplicate a route class");
        }
        InsertionPoint insertionPoint = this.findInsertionPointForAppend(component);
        String duplicatedName = null;
        if (component.localVariableName() != null) {
            duplicatedName = JavaRewriterUtil.findFreeVariableName(component.localVariableName(), insertionPoint.block);
            VariableDeclarator newLocalVariable = JavaRewriterUtil.clone(component.localVariableDeclarator());
            newLocalVariable.setName(duplicatedName);
            insertionPoint.add((Statement)new ExpressionStmt((Expression)new VariableDeclarationExpr(newLocalVariable)));
        } else if (component.fieldName() != null) {
            FieldDeclaration newField;
            duplicatedName = JavaRewriterUtil.findFreeVariableName(component.fieldName(), insertionPoint.block);
            if (component.fieldDeclarationAndAssignment() != null) {
                newField = JavaRewriterUtil.clone(component.fieldDeclarationAndAssignment());
            } else {
                newField = JavaRewriterUtil.clone(component.fieldDeclaration());
                AssignExpr newAssignment = JavaRewriterUtil.clone(component.assignmentExpression());
                newAssignment.setTarget((Expression)new NameExpr(duplicatedName));
                insertionPoint.add((Statement)new ExpressionStmt((Expression)newAssignment));
            }
            newField.getVariable(0).setName(duplicatedName);
            JavaRewriterUtil.addFieldAfter(newField, component.fieldDeclaration());
        }
        if (duplicatedName != null) {
            List<MethodCallExpr> calls = JavaRewriterUtil.findMethodCallStatements(component);
            for (MethodCallExpr call : calls) {
                MethodCallExpr newCall = JavaRewriterUtil.clone(call);
                JavaRewriterUtil.setNameExprScope(newCall, new NameExpr(duplicatedName));
                insertionPoint.add((Statement)new ExpressionStmt((Expression)newCall));
            }
        }
        Expression componentAddArgument = JavaRewriterUtil.getAttachArgumentOrThrow(component);
        int addIndex = component.attachCall().getArgumentPosition(componentAddArgument) + 1;
        if (duplicatedName != null) {
            component.attachCall().getArguments().add(addIndex, (Node)new NameExpr(duplicatedName));
        } else {
            component.attachCall().getArguments().add(addIndex, (Node)((Expression)JavaRewriterUtil.clone(component.objectCreationExpr())));
        }
    }

    public void addComponentUsingTemplate(ComponentInfo referenceComponent, ComponentInfo layout, Where where, List<JavaComponent> template) {
        if (where == Where.APPEND) {
            if (referenceComponent != null || layout == null) {
                throw new IllegalArgumentException("Reference component must be null and layout must be non-null when appending");
            }
            InsertionPoint insertionPoint = this.findInsertionPointForAppend(layout);
            if (layout.routeConstructor() != null) {
                this.createComponentStatements(insertionPoint, null, template, "this", null);
            } else {
                this.createComponentStatements(insertionPoint, null, template, JavaRewriterUtil.getFieldOrVariableName(layout), null);
            }
        } else if (where == Where.BEFORE) {
            BlockStmt insertBlock = referenceComponent.componentCreateScope();
            int insertIndex = JavaRewriterUtil.findBlockStatementIndex((Node)referenceComponent.objectCreationExpr());
            InsertionPoint insertionPoint = new InsertionPoint(insertBlock, insertIndex);
            this.createComponentStatements(insertionPoint, null, template, JavaRewriterUtil.getFieldOrVariableName(referenceComponent), referenceComponent);
        } else {
            throw new IllegalArgumentException("Unknown where: " + String.valueOf((Object)where));
        }
    }

    private InsertionPoint findInsertionPointForAppend(ComponentInfo component) {
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(component);
        if (!functionCalls.isEmpty()) {
            MethodCallExpr lastCall = functionCalls.get(functionCalls.size() - 1);
            return JavaRewriterUtil.findLocationAfter((Expression)lastCall);
        }
        if (component.routeConstructor() != null) {
            return JavaRewriterUtil.findLocationAtEnd((Statement)component.routeConstructor().getBody());
        }
        return JavaRewriterUtil.findLocationBefore((Expression)component.attachCall());
    }

    public void setAlignment(ComponentInfo component, AlignmentMode alignmentMode, boolean selected, List<String> lumoClasses) {
        String[] stringArray;
        if (alignmentMode == AlignmentMode.ALIGN_ITEMS) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "AlignItems";
            stringArray = stringArray2;
            stringArray2[1] = "JustifyContent";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "AlignSelf";
        }
        String[] lumoUtilityInnerClassNames = stringArray;
        LumoRewriterUtil.removeClassNameArgs(component, lumoUtilityInnerClassNames);
        LumoRewriterUtil.addLumoUtilityImport(this.compilationUnit);
        if (selected) {
            ArrayList<Expression> parameterToAddList = new ArrayList<Expression>();
            for (String lumoUtilityInnerClassName : lumoUtilityInnerClassNames) {
                parameterToAddList.addAll(LumoRewriterUtil.getLumoMethodArgExpressions(lumoUtilityInnerClassName, lumoClasses));
            }
            boolean added = LumoRewriterUtil.addClassNameWithArgs(component, parameterToAddList);
            if (!added) {
                this.replaceOrAddCall(component, "addClassNames", parameterToAddList.toArray(new Object[0]));
            }
        }
    }

    public void setGap(ComponentInfo component, String newValue) {
        LumoRewriterUtil.removeClassNameArgs(component, "Gap", "Gap.Column", "Gap.Row");
        LumoRewriterUtil.addLumoUtilityImport(this.compilationUnit);
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(component);
        methodCallStatements.stream().filter(methodCallExpr -> StringUtils.equals((CharSequence)methodCallExpr.getNameAsString(), (CharSequence)"setSpacing")).findAny().ifPresent(JavaRewriterUtil::removeStatement);
        LumoRewriterUtil.removeThemeArgStartsWith(methodCallStatements, "spacing");
        if (StringUtils.isNotEmpty((CharSequence)newValue)) {
            List<Expression> gapExpressions = LumoRewriterUtil.getLumoMethodArgExpressions("Gap", List.of(newValue));
            boolean added = LumoRewriterUtil.addClassNameWithArgs(component, gapExpressions);
            if (!added) {
                this.replaceOrAddCall(component, "addClassNames", gapExpressions.toArray(new Object[0]));
            }
        } else {
            boolean added = JavaRewriterUtil.addAfterLastFunctionCall(methodCallStatements, "setSpacing", new Expression[]{new BooleanLiteralExpr(false)});
            if (!added) {
                this.replaceOrAddCall(component, "setSpacing", false);
            }
        }
    }

    public void mergeAndReplace(List<ComponentInfo> components, JavaComponent wrapperComponent) {
        ComponentInfo firstComponent = components.get(0);
        if (firstComponent.componentAttachScope == null) {
            throw new IllegalArgumentException("Routes cannot be wrapped");
        }
        for (int i = 1; i < components.size(); ++i) {
            ComponentInfo component = components.get(i);
            if (component.componentAttachScope == firstComponent.componentAttachScope) continue;
            throw new IllegalArgumentException("Only components attached in the same block are currently supported");
        }
        int wrapperInsertIndex = JavaRewriterUtil.findBlockStatementIndex((Node)firstComponent.attachCall);
        InsertionPoint firstComponentAttachLocation = new InsertionPoint(firstComponent.componentAttachScope, wrapperInsertIndex);
        List<VariableDeclarator> statements = this.createComponentStatements(firstComponentAttachLocation, null, wrapperComponent, false, null, null);
        NameExpr wrapperVariable = new NameExpr(statements.get(0).getNameAsString());
        MethodCallExpr addCall = new MethodCallExpr((Expression)wrapperVariable, "add");
        Node wrapperAdd = null;
        for (int i = 0; i < components.size(); ++i) {
            Optional<Expression> componentAddArgument;
            ComponentInfo component = components.get(i);
            if (i == 0) {
                componentAddArgument = Optional.of(JavaRewriterUtil.getAttachArgumentOrThrow(component));
                Optional maybeParent = componentAddArgument.flatMap(Node::getParentNode);
                if (maybeParent.isEmpty()) {
                    throw new IllegalArgumentException("No add argument found for the first component");
                }
                wrapperAdd = (Node)maybeParent.get();
                wrapperAdd.replace((Node)componentAddArgument.get(), (Node)wrapperVariable);
            } else {
                componentAddArgument = this.removeAttachCall(component);
            }
            componentAddArgument.ifPresent(arg_0 -> ((MethodCallExpr)addCall).addArgument(arg_0));
        }
        if (wrapperAdd == null) {
            throw new IllegalArgumentException("Wrapper was never added");
        }
        firstComponentAttachLocation.block.addStatement(JavaRewriterUtil.findBlockStatementIndex(wrapperAdd), (Expression)addCall);
    }

    private void createComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, List<JavaComponent> template, String layoutVariableName, ComponentInfo referenceComponent) {
        for (JavaComponent javaComponent : template) {
            this.createComponentStatements(insertionPoint, parent, javaComponent, true, layoutVariableName, referenceComponent);
        }
    }

    private List<VariableDeclarator> createComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, JavaComponent javaComponent, boolean attach, String layoutVariableName, ComponentInfo referenceComponent) {
        ArrayList<VariableDeclarator> createdVariables = new ArrayList<VariableDeclarator>();
        String componentClassName = javaComponent.className() != null ? javaComponent.className() : FlowComponentQuirks.getClassForTag(javaComponent.tag());
        ClassOrInterfaceType fullType = StaticJavaParser.parseClassOrInterfaceType((String)componentClassName);
        HashMap setters = new HashMap();
        Class<?> componentType = JavaRewriterUtil.getClass(fullType.getNameWithScope());
        javaComponent.props().forEach((prop, value) -> {
            SetterAndValue setterAndValue = JavaRewriterUtil.getSetterAndValue(componentType, prop, value);
            setters.put(setterAndValue.setter(), setterAndValue.value());
        });
        JavaRewriterUtil.addImport(this.compilationUnit, fullType.getNameWithScope());
        ClassOrInterfaceType type = fullType.clone().removeScope();
        ObjectCreationExpr constructor = new ObjectCreationExpr(null, type, new NodeList());
        this.getSingleParamConstructor(fullType, setters.keySet()).ifPresent(constructorProp -> {
            Object value = setters.remove(constructorProp);
            this.getParameterList(insertionPoint, value).forEach(arg_0 -> ((ObjectCreationExpr)constructor).addArgument(arg_0));
        });
        String variableBaseName = type.getNameAsString().toLowerCase(Locale.ENGLISH);
        if (javaComponent.props().containsKey("text")) {
            variableBaseName = SharedUtil.firstToLower((String)SharedUtil.dashSeparatedToCamelCase((String)((String)javaComponent.props().get("text")).replace(' ', '-')));
            variableBaseName = JavaRewriterUtil.getJavaIdentifier(variableBaseName);
        }
        String variableName = insertionPoint.getFreeVariableName(variableBaseName);
        NameExpr variableNameExpr = new NameExpr(variableName);
        VariableDeclarator decl = new VariableDeclarator((Type)type, variableName, (Expression)constructor);
        VariableDeclarationExpr declarationExpr = new VariableDeclarationExpr(decl);
        createdVariables.add(decl);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)declarationExpr));
        for (Map.Entry setter : setters.entrySet()) {
            Object value2 = setter.getValue();
            if (value2 instanceof JavaComponent) {
                JavaComponent javaComponentValue = (JavaComponent)value2;
                value2 = this.createSubComponentStatements(insertionPoint, javaComponent, List.of(javaComponentValue)).get(0);
            }
            this.insertSetter(insertionPoint, (Expression)variableNameExpr, (String)setter.getKey(), value2);
        }
        this.createComponentStatements(insertionPoint, javaComponent, javaComponent.children(), variableName, null);
        if (attach) {
            this.attachComponent(insertionPoint, parent, layoutVariableName, referenceComponent, variableNameExpr, variableName);
        }
        return createdVariables;
    }

    private void attachComponent(InsertionPoint insertionPoint, JavaComponent parent, String layoutVariableName, ComponentInfo referenceComponent, NameExpr variableNameExpr, String variableName) {
        if (referenceComponent != null) {
            MethodCallExpr referenceAttach = referenceComponent.attachCall();
            if (referenceAttach.getArguments().size() == 1) {
                ExpressionStmt addCall = this.createAddCall(parent, referenceAttach.getScope().orElse(null), (Expression)variableNameExpr);
                BlockStmt block = JavaRewriterUtil.findAncestorOrThrow((Node)referenceAttach, BlockStmt.class);
                block.addStatement(JavaRewriterUtil.findBlockStatementIndex((Node)referenceAttach), (Statement)addCall);
            } else {
                Object referenceArgument = layoutVariableName == null ? referenceComponent.objectCreationExpr() : (Expression)referenceAttach.getArguments().stream().filter(arg -> {
                    NameExpr nameExpr;
                    return arg instanceof NameExpr && (nameExpr = (NameExpr)arg).getNameAsString().equals(layoutVariableName);
                }).findFirst().orElse(null);
                if (referenceArgument == null) {
                    throw new IllegalArgumentException("Did not find reference argument ('" + variableName + "') in " + String.valueOf(referenceAttach));
                }
                int index = referenceAttach.getArguments().indexOf(referenceArgument);
                referenceAttach.getArguments().add(index, (Node)variableNameExpr);
            }
        } else if (layoutVariableName != null) {
            NameExpr scope = null;
            if (!layoutVariableName.equals("this")) {
                scope = new NameExpr(layoutVariableName);
            }
            ExpressionStmt addCall = this.createAddCall(parent, (Expression)scope, (Expression)variableNameExpr);
            insertionPoint.add((Statement)addCall);
        } else {
            throw new IllegalArgumentException("Either layoutVariableName or referenceAttach must be given to attach a component");
        }
    }

    private NodeList<Expression> getParameterList(InsertionPoint insertionPoint, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return new NodeList();
            }
            if (list.get(0) instanceof JavaComponent) {
                return JavaRewriterUtil.toExpressionList(this.createSubComponentStatements(insertionPoint, null, list));
            }
        }
        return JavaRewriterUtil.toExpressionList(value);
    }

    private void insertSetter(InsertionPoint insertionPoint, Expression owner, String setterName, Object value) {
        if (setterName.equals("setStyle")) {
            this.insertStyles(insertionPoint, owner, (Map)value);
        } else if (setterName.equals("setSlot")) {
            MethodCallExpr getElement = new MethodCallExpr(owner, "getElement");
            MethodCallExpr setAttributeCall = new MethodCallExpr((Expression)getElement, "setAttribute", new NodeList((Node[])new Expression[]{JavaRewriterUtil.toExpression("slot"), JavaRewriterUtil.toExpression(value)}));
            insertionPoint.add((Statement)new ExpressionStmt((Expression)setAttributeCall));
        } else {
            NodeList<Expression> parameterExpression = this.getParameterList(insertionPoint, value);
            MethodCallExpr setterCall = new MethodCallExpr(owner, setterName, parameterExpression);
            insertionPoint.add((Statement)new ExpressionStmt((Expression)setterCall));
        }
    }

    private void insertStyles(InsertionPoint insertionPoint, Expression owner, Map<String, String> styles) {
        MethodCallExpr finalCall = new MethodCallExpr(owner, "getStyle");
        for (Map.Entry<String, String> entry : styles.entrySet()) {
            finalCall = new MethodCallExpr((Expression)finalCall, "set", new NodeList((Node[])new Expression[]{JavaRewriterUtil.toExpression(entry.getKey()), JavaRewriterUtil.toExpression(entry.getValue())}));
        }
        insertionPoint.add((Statement)new ExpressionStmt((Expression)finalCall));
    }

    private NodeList<Expression> createSubComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, List<JavaComponent> components) {
        ArrayList<VariableDeclarator> variables = new ArrayList<VariableDeclarator>();
        for (JavaComponent javaComponent : components) {
            variables.addAll(this.createComponentStatements(insertionPoint, parent, javaComponent, false, null, null));
        }
        return new NodeList((Node[])((Expression[])variables.stream().map(VariableDeclarator::getName).map(NameExpr::new).toArray(NameExpr[]::new)));
    }

    private Optional<String> getSingleParamConstructor(ClassOrInterfaceType type, Set<String> setters) {
        Class<?> componentType = JavaRewriterUtil.getClass(type.getNameWithScope());
        Optional<Constructor> constructor = Arrays.stream(componentType.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 1 && c.getParameterTypes()[0] == String.class).findFirst();
        if (constructor.isEmpty()) {
            return Optional.empty();
        }
        String mappedProperty = this.getMappedProperty(constructor.get(), 0);
        if (mappedProperty != null && setters.contains(mappedProperty)) {
            return Optional.of(mappedProperty);
        }
        return Optional.empty();
    }

    private ExpressionStmt createAddCall(JavaComponent parent, Expression scope, Expression toAdd) {
        String methodName = "add";
        if (parent != null && parent.tag().equals("SideNav")) {
            methodName = "addItem";
        }
        return new ExpressionStmt((Expression)new MethodCallExpr(scope, methodName, new NodeList((Node[])new Expression[]{toAdd})));
    }

    protected String getSource() {
        return this.source;
    }

    public record ComponentInfo(Class<? extends Component> type, ObjectCreationExpr objectCreationExpr, BlockStmt componentCreateScope, MethodCallExpr attachCall, BlockStmt componentAttachScope, VariableDeclarator localVariableDeclarator, AssignExpr assignmentExpression, FieldDeclaration fieldDeclaration, FieldDeclaration fieldDeclarationAndAssignment, String localVariableName, String fieldName, ConstructorDeclaration routeConstructor, JavaRewriter rewriter) {
    }

    public record ExtractInlineVariableResult(BlockStmt blockStmt, String newVariableName, int index) {
    }

    public record ComponentTypeAndSourceLocation(Class<? extends Component> type, File javaFile, ComponentTracker.Location createLocation, ComponentTracker.Location attachLocation, ComponentTypeAndSourceLocation parent, List<ComponentTypeAndSourceLocation> children) {
    }

    public static enum Where {
        BEFORE,
        APPEND;

    }

    public static class InsertionPoint {
        private final BlockStmt block;
        private int index;

        public InsertionPoint(BlockStmt block, int index) {
            this.block = block;
            this.index = index;
        }

        public String getFreeVariableName(String baseName) {
            return JavaRewriterUtil.findFreeVariableName(baseName, this.block);
        }

        public void add(Statement statement) {
            this.block.addStatement(this.index++, statement);
        }

        public BlockStmt getBlock() {
            return this.block;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public record JavaComponent(String tag, String className, Map<String, Object> props, List<JavaComponent> children) {
        private static Object propertyValueFromJson(Object jsonValue) {
            if (jsonValue instanceof JsonBoolean) {
                JsonBoolean jsonboolean = (JsonBoolean)jsonValue;
                return jsonboolean.getBoolean();
            }
            if (jsonValue instanceof JsonString) {
                JsonString jsonString = (JsonString)jsonValue;
                return jsonString.getString();
            }
            if (jsonValue instanceof JsonNull) {
                return null;
            }
            if (jsonValue instanceof JsonNumber) {
                JsonNumber number = (JsonNumber)jsonValue;
                if (number.asString().equals("" + (int)number.asNumber())) {
                    return (int)((JsonNumber)jsonValue).getNumber();
                }
                return number.asNumber();
            }
            if (jsonValue instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonValue;
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (String key : jsonObject.keys()) {
                    values.put(key, JavaComponent.propertyValueFromJson(jsonObject.get(key)));
                }
                return values;
            }
            if (jsonValue instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonValue;
                ArrayList<Object> values = new ArrayList<Object>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    values.add(JavaComponent.propertyValueFromJson(jsonArray.get(i)));
                }
                return values;
            }
            throw new IllegalArgumentException("Unsupported JSON value: " + String.valueOf(jsonValue));
        }

        public static JavaComponent componentFromJson(JsonObject json) {
            String tag = json.hasKey("tag") ? json.getString("tag") : null;
            String className = json.hasKey("className") ? json.getString("className") : null;
            HashMap<String, Object> props = new HashMap<String, Object>();
            JsonObject jsonProps = json.getObject("props");
            if (jsonProps != null) {
                for (String key : jsonProps.keys()) {
                    props.put(key, JavaComponent.propertyValueFromJson(jsonProps.get(key)));
                }
            }
            ArrayList<JavaComponent> children = new ArrayList<JavaComponent>();
            JsonArray jsonChildren = json.getArray("children");
            if (jsonChildren != null) {
                for (int i = 0; i < jsonChildren.length(); ++i) {
                    JavaComponent child = JavaComponent.componentFromJson(jsonChildren.getObject(i));
                    if ("prefix".equals(child.props.get("slot"))) {
                        child.props.remove("slot");
                        props.put("prefixComponent", child);
                        continue;
                    }
                    if ("add-button".equals(child.props.get("slot"))) {
                        child.props.remove("slot");
                        props.put("uploadButton", child);
                        continue;
                    }
                    children.add(child);
                }
            }
            return new JavaComponent(tag, className, props, children);
        }

        public static List<JavaComponent> componentsFromJson(JsonArray template) {
            return JsonUtils.stream((JsonArray)template).map(JsonObject.class::cast).map(JavaComponent::componentFromJson).toList();
        }
    }

    public static enum AlignmentMode {
        ALIGN_ITEMS,
        SELF_HORIZONTALLY,
        SELF_VERTICALLY;

    }

    public record SetterAndValue(String setter, Object value) {
    }

    public record Code(String code) {
    }
}

