/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdeIntegration {
    private final ApplicationConfiguration configuration;

    public IdeIntegration(ApplicationConfiguration configuration) {
        this.configuration = configuration;
        if (configuration.isProductionMode()) {
            IdeIntegration.getLogger().error("{} should never be created in production mode", (Object)this.getClass().getSimpleName());
        }
    }

    public void showComponentCreateInIde(Component component) {
        this.internalShowInIde(component, ComponentTracker.findCreate((Component)component));
    }

    public void showComponentAttachInIde(Component component) {
        this.internalShowInIde(component, ComponentTracker.findAttach((Component)component));
    }

    private void internalShowInIde(Component component, ComponentTracker.Location location) {
        if (location == null) {
            IdeIntegration.getLogger().error("Unable to find the location where the component {} was created", (Object)component.getClass().getName());
            return;
        }
        File javaFile = location.findJavaFile((AbstractConfiguration)this.configuration);
        if (javaFile == null || !javaFile.exists()) {
            IdeIntegration.getLogger().error("Unable to find file {}", (Object)javaFile);
            return;
        }
        IdeUtils.openFile(javaFile, location.lineNumber());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IdeIntegration.class);
    }
}

