/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.auth.AnnotatedViewAccessChecker;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import jakarta.servlet.ServletContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cglib.proxy.Proxy;
import org.springframework.core.env.Environment;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringIntegration {
    public static String getPropertyValue(VaadinServletContext context, String property) {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getContext());
        if (webAppContext == null) {
            SpringIntegration.getLogger().error("No web application context available");
            return null;
        }
        Environment env = webAppContext.getEnvironment();
        return env.getProperty(property, (String)null);
    }

    public static Class<?> getApplicationClass(VaadinServletContext context) {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getContext());
        if (webAppContext == null) {
            SpringIntegration.getLogger().error("No web application context available");
            return null;
        }
        Map beans = webAppContext.getBeansWithAnnotation(SpringBootApplication.class);
        Class<?> appClass = beans.values().iterator().next().getClass();
        if (Proxy.isProxyClass(appClass)) {
            appClass = appClass.getSuperclass();
        }
        while (appClass.getName().contains("$$SpringCGLIB$$")) {
            appClass = appClass.getSuperclass();
        }
        return appClass;
    }

    public static Boolean isViewSecurityEnabled(VaadinServletContext context) {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getContext());
        if (webAppContext == null) {
            return false;
        }
        String[] naviAccessControl = webAppContext.getBeanNamesForType(NavigationAccessControl.class);
        if (naviAccessControl.length != 1) {
            return false;
        }
        NavigationAccessControl accessControl = (NavigationAccessControl)webAppContext.getBean(naviAccessControl[0]);
        return accessControl.hasAccessChecker(AnnotatedViewAccessChecker.class);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SpringIntegration.class);
    }
}

