/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.analytics;

import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.CopilotVersion;
import com.vaadin.copilot.analytics.AnalyticsRequest;
import com.vaadin.copilot.userinfo.UserInfo;
import com.vaadin.copilot.userinfo.UserInfoServerClient;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

public class AnalyticsClient
extends CopilotServerClient {
    private final String userKey = ProjectHelpers.getUserKey();
    private final String machineId = MachineId.get();
    private final boolean vaadiner;

    public AnalyticsClient() {
        UserInfo userInfo;
        ProKey proKey = LocalProKey.get();
        this.vaadiner = proKey != null ? (userInfo = new UserInfoServerClient().getUserInfo(proKey.getProKey())) != null && userInfo.vaadiner() : false;
    }

    public void track(String event, Map<String, String> properties, Map<String, String> context) {
        properties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
        properties.put("Vaadiner", String.valueOf(this.vaadiner));
        context = context == null ? new HashMap<String, String>() : new HashMap<String, String>(context);
        context.put("version", CopilotVersion.getVersion());
        this.sendRequest(event, properties, context);
    }

    protected void sendRequest(String event, Map<String, String> properties, Map<String, String> context) {
        URI uri = this.getQueryURI("analytics");
        AnalyticsRequest trackingRequest = new AnalyticsRequest(this.userKey, this.machineId, event, properties, context);
        String json = this.writeAsJsonString(trackingRequest);
        HttpRequest request = this.buildRequest(uri, json);
        this.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }
}

