/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithStatements;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.vaadin.copilot.plugins.themeeditor.ComponentType;
import com.vaadin.copilot.plugins.themeeditor.Where;
import com.vaadin.copilot.plugins.themeeditor.utils.StatementLineNumberVisitor;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class Editor {
    private List<Modification> modifyOrAddCall(CompilationUnit cu, int componentCreateLineNumber, int componentAttachLineNumber, ComponentType componentType, String methodName, String methodParameter) {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        Statement node = this.findStatement(cu, componentCreateLineNumber);
        SimpleName localVariableOrField = this.findLocalVariableOrField(cu, componentCreateLineNumber);
        if (localVariableOrField == null) {
            this.modifyOrAddCallInlineConstructor(cu, node, componentType, methodName, methodParameter, mods);
            return mods;
        }
        BlockStmt codeBlock = (BlockStmt)node.getParentNode().orElseThrow();
        boolean handled = false;
        Expression exp = (Expression)((Node)localVariableOrField.getParentNode().orElseThrow()).getParentNode().orElseThrow();
        if (exp.isAssignExpr()) {
            AssignExpr assignExpr = exp.asAssignExpr();
            if (assignExpr.getValue().isObjectCreationExpr()) {
                handled = this.modifyConstructorCall(assignExpr.getValue().asObjectCreationExpr(), methodName, methodParameter, mods);
            }
            if (!handled) {
                this.addOrReplaceCall(codeBlock, (Node)node, localVariableOrField, methodName, (Expression)new StringLiteralExpr(methodParameter), mods);
            }
        } else if (exp.isVariableDeclarationExpr()) {
            ObjectCreationExpr constructorCall;
            VariableDeclarationExpr varDeclaration = exp.asVariableDeclarationExpr();
            VariableDeclarator varDeclarator = varDeclaration.getVariable(0);
            Optional initializer = varDeclarator.getInitializer();
            if (initializer.isPresent() && ((Expression)initializer.orElseThrow()).isObjectCreationExpr() && this.modifyConstructorCall(constructorCall = ((Expression)initializer.orElseThrow()).asObjectCreationExpr(), methodName, methodParameter, mods)) {
                handled = true;
            }
            if (!handled) {
                this.addOrReplaceCall(codeBlock, (Node)node, localVariableOrField, methodName, (Expression)new StringLiteralExpr(methodParameter), mods);
            }
        }
        return mods;
    }

    private List<Modification> addCall(CompilationUnit cu, int componentCreateLineNumber, int componentAttachLineNumber, ComponentType componentType, String methodName, String methodParameter) {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        Statement node = this.findStatement(cu, componentCreateLineNumber);
        if (node == null) {
            throw new UnsupportedOperationException("Cannot add method call for given component.");
        }
        SimpleName localVariableOrField = this.findLocalVariableOrField(cu, componentCreateLineNumber);
        if (localVariableOrField == null) {
            this.modifyOrAddCallInlineConstructor(cu, node, componentType, methodName, methodParameter, mods);
            return mods;
        }
        Expression exp = (Expression)((Node)localVariableOrField.getParentNode().orElseThrow()).getParentNode().orElseThrow();
        if (exp.isAssignExpr()) {
            this.addCall((Node)node, localVariableOrField, methodName, (Expression)new StringLiteralExpr(methodParameter), mods);
        } else if (exp.isVariableDeclarationExpr()) {
            this.addCall((Node)node, localVariableOrField, methodName, (Expression)new StringLiteralExpr(methodParameter), mods);
        }
        return mods;
    }

    private List<Modification> removeCall(CompilationUnit cu, int componentCreateLineNumber, int componentAttachLineNumber, ComponentType componentType, String methodName, String methodParameter) {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        Statement node = this.findStatement(cu, componentCreateLineNumber);
        SimpleName localVariableOrField = this.findLocalVariableOrField(cu, componentCreateLineNumber);
        if (localVariableOrField == null) {
            this.modifyOrAddCallInlineConstructor(cu, node, componentType, methodName, methodParameter, mods);
            return mods;
        }
        BlockStmt codeBlock = (BlockStmt)node.getParentNode().orElseThrow();
        boolean handled = false;
        Expression exp = (Expression)((Node)localVariableOrField.getParentNode().orElseThrow()).getParentNode().orElseThrow();
        if (exp.isAssignExpr()) {
            AssignExpr assignExpr = exp.asAssignExpr();
            if (assignExpr.getValue().isObjectCreationExpr()) {
                handled = this.modifyConstructorCall(assignExpr.getValue().asObjectCreationExpr(), methodName, methodParameter, mods);
            }
            if (!handled) {
                this.removeCall(codeBlock, (Node)node, localVariableOrField, methodName, (Expression)new StringLiteralExpr(methodParameter), mods);
            }
        } else if (exp.isVariableDeclarationExpr()) {
            ObjectCreationExpr constructorCall;
            VariableDeclarationExpr varDeclaration = exp.asVariableDeclarationExpr();
            VariableDeclarator varDeclarator = varDeclaration.getVariable(0);
            Optional initializer = varDeclarator.getInitializer();
            if (initializer.isPresent() && ((Expression)initializer.orElseThrow()).isObjectCreationExpr() && this.modifyConstructorCall(constructorCall = ((Expression)initializer.orElseThrow()).asObjectCreationExpr(), methodName, methodParameter, mods)) {
                handled = true;
            }
            if (!handled) {
                this.removeCall(codeBlock, (Node)node, localVariableOrField, methodName, (Expression)new StringLiteralExpr(methodParameter), mods);
            }
        }
        return mods;
    }

    private void modifyOrAddCallInlineConstructor(CompilationUnit cu, Statement componentNode, ComponentType componentType, String methodName, String methodParameter, List<Modification> mods) {
        ObjectCreationExpr constructorCall;
        if (!componentNode.isExpressionStmt() || componentType == null) {
            return;
        }
        Expression expression = componentNode.asExpressionStmt().getExpression();
        if (expression.isMethodCallExpr() && (constructorCall = this.findConstructorCallParameter(expression.asMethodCallExpr(), componentType)) != null) {
            this.modifyConstructorCall(constructorCall, methodName, methodParameter, mods);
        }
    }

    private ObjectCreationExpr findConstructorCallParameter(MethodCallExpr methodCallExpr, ComponentType componentType) {
        List constructorCalls = methodCallExpr.getArguments().stream().filter(arg -> arg.isObjectCreationExpr()).map(arg -> arg.asObjectCreationExpr()).filter(objectCreate -> this.isConstructorFor((ObjectCreationExpr)objectCreate, componentType)).collect(Collectors.toList());
        if (constructorCalls.size() == 1) {
            return (ObjectCreationExpr)constructorCalls.get(0);
        }
        return null;
    }

    protected SimpleName findLocalVariableOrField(CompilationUnit cu, int componentCreateLineNumber) {
        Statement statement = this.findStatement(cu, componentCreateLineNumber);
        if (statement != null && statement.isExpressionStmt()) {
            AssignExpr assignExpr;
            Expression target;
            ExpressionStmt expressionStmt = statement.asExpressionStmt();
            Expression expression = expressionStmt.getExpression();
            if (expression.isVariableDeclarationExpr()) {
                VariableDeclarationExpr varDeclaration = expression.asVariableDeclarationExpr();
                VariableDeclarator varDeclarator = varDeclaration.getVariable(0);
                return varDeclarator.getName();
            }
            if (expression.isAssignExpr() && (target = (assignExpr = expression.asAssignExpr()).getTarget()).isNameExpr()) {
                return target.asNameExpr().getName();
            }
        }
        return null;
    }

    private List<Modification> addComponent(CompilationUnit cu, int componentCreateLineNumber, int componentAttachLineNumber, Where where, ComponentType componentType, String ... constructorArguments) {
        Expression expression;
        Statement createStatement;
        ArrayList<Modification> mods = new ArrayList<Modification>();
        if (!this.hasImport(cu, componentType.getClassName())) {
            mods.add(this.addImport(cu, componentType.getClassName()));
        }
        if ((createStatement = this.findStatement(cu, componentCreateLineNumber)) == null || createStatement.isBlockStmt()) {
            if (where == Where.INSIDE) {
                mods.addAll(this.addComponentToClass(cu, componentCreateLineNumber, componentType, constructorArguments));
            }
            return mods;
        }
        Statement attachStatement = this.findStatement(cu, componentAttachLineNumber);
        String localVariableName = this.getVariableName(componentType, constructorArguments);
        localVariableName = this.findUnusedVariableName(localVariableName, (BlockStmt)createStatement.getParentNode().orElseThrow(), null);
        ExpressionStmt componentConstructCode = this.assignToLocalVariable(componentType, localVariableName, (Expression)this.getConstructorCode(componentType, constructorArguments));
        NameExpr componentAttachNode = new NameExpr(localVariableName);
        SimpleName referenceLocalVariableOrField = this.findLocalVariableOrField(cu, componentCreateLineNumber);
        mods.add(Modification.insertLineBefore((Node)attachStatement, (Node)componentConstructCode));
        if (referenceLocalVariableOrField == null && attachStatement.equals((Object)createStatement) && attachStatement.isExpressionStmt()) {
            Expression attachNodeExpression = attachStatement.asExpressionStmt().getExpression();
            if (attachNodeExpression.isMethodCallExpr()) {
                ObjectCreationExpr referenceComponentAdd = this.findConstructorCallParameter(attachNodeExpression.asMethodCallExpr(), componentType);
                if (referenceComponentAdd != null) {
                    MethodCallExpr methodCallExpr = attachNodeExpression.asMethodCallExpr();
                    NodeList args = methodCallExpr.getArguments();
                    for (int i = 0; i < args.size(); ++i) {
                        if (!referenceComponentAdd.equals((Object)args.get(i))) continue;
                        if (where == Where.BEFORE) {
                            mods.add(Modification.insertBefore(args.get(i), (Node)componentAttachNode));
                            break;
                        }
                        mods.add(Modification.insertAfter(args.get(i), (Node)componentAttachNode));
                        break;
                    }
                }
                return mods;
            }
        } else if (referenceLocalVariableOrField != null && attachStatement.isExpressionStmt() && (expression = attachStatement.asExpressionStmt().getExpression()).isMethodCallExpr()) {
            NodeList args = expression.asMethodCallExpr().getArguments();
            for (int i = 0; i < args.size(); ++i) {
                SimpleName name;
                if (!((Expression)args.get(i)).isNameExpr() || !(name = ((Expression)args.get(i)).asNameExpr().getName()).equals((Object)referenceLocalVariableOrField)) continue;
                if (where == Where.BEFORE) {
                    mods.add(Modification.insertBefore(args.get(i), (Node)componentAttachNode));
                    break;
                }
                mods.add(Modification.insertAfter(args.get(i), (Node)componentAttachNode));
                break;
            }
        }
        return mods;
    }

    private String findUnusedVariableName(String localVariableName, BlockStmt body, ClassOrInterfaceDeclaration classDefinition) {
        Set<String> usedLocalVariables = this.findLocalVariables(body);
        if (classDefinition == null) {
            classDefinition = (ClassOrInterfaceDeclaration)body.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).orElseThrow();
        }
        Set<String> usedFieldNames = this.findFieldNames(classDefinition);
        Object varName = localVariableName;
        int i = 2;
        while (usedLocalVariables.contains(varName) || usedFieldNames.contains(varName)) {
            varName = localVariableName + i;
            ++i;
        }
        return varName;
    }

    private Set<String> findFieldNames(ClassOrInterfaceDeclaration classDefinition) {
        HashSet<String> names = new HashSet<String>();
        for (FieldDeclaration field : classDefinition.getFields()) {
            for (VariableDeclarator varDecl : field.getVariables()) {
                names.add(varDecl.getNameAsString());
            }
        }
        return names;
    }

    private Set<String> findLocalVariables(BlockStmt body) {
        HashSet<String> names = new HashSet<String>();
        if (body != null) {
            for (Statement statement : body.getStatements()) {
                if (!statement.isExpressionStmt() || !statement.asExpressionStmt().getExpression().isVariableDeclarationExpr()) continue;
                NodeList vars = statement.asExpressionStmt().getExpression().asVariableDeclarationExpr().getVariables();
                for (VariableDeclarator varDecl : vars) {
                    names.add(varDecl.getNameAsString());
                }
            }
        }
        return names;
    }

    private ExpressionStmt assignToLocalVariable(ComponentType componentType, String variableName, Expression expression) {
        VariableDeclarationExpr localVariable = new VariableDeclarationExpr(new VariableDeclarator((Type)this.getType(componentType), variableName));
        return new ExpressionStmt((Expression)new AssignExpr((Expression)localVariable, expression, AssignExpr.Operator.ASSIGN));
    }

    private Modification addImport(CompilationUnit cu, String className) {
        return Modification.addImport((Node)cu, (Node)new ImportDeclaration(className, false, false));
    }

    private boolean hasImport(CompilationUnit cu, String className) {
        for (ImportDeclaration importDecl : cu.getImports()) {
            if (!importDecl.getNameAsString().equals(className)) continue;
            return true;
        }
        return false;
    }

    private List<Modification> addComponentToClass(CompilationUnit cu, int componentCreateLineNumber, ComponentType componentType, String[] constructorArguments) {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        ClassOrInterfaceDeclaration classDefinition = this.findClassDefinition(cu, componentCreateLineNumber);
        ConstructorDeclaration constructor = this.findConstructorDeclaration(cu, componentCreateLineNumber);
        String variableName = this.getVariableName(componentType, constructorArguments);
        if (constructor != null) {
            variableName = this.findUnusedVariableName(variableName, constructor.getBody(), null);
        } else if (classDefinition != null) {
            variableName = this.findUnusedVariableName(variableName, null, classDefinition);
        }
        ExpressionStmt createComponent = this.assignToLocalVariable(componentType, variableName, (Expression)this.getConstructorCode(componentType, constructorArguments));
        ExpressionStmt addComponent = this.addToLayout(variableName);
        if (constructor != null) {
            mods.add(Modification.insertAtEndOfBlock((Node)constructor.getBody(), (Node)createComponent));
            mods.add(Modification.insertAtEndOfBlock((Node)constructor.getBody(), (Node)addComponent));
        } else if (classDefinition != null) {
            if (!classDefinition.getConstructors().isEmpty()) {
                return mods;
            }
            ConstructorDeclaration defaultConstructor = classDefinition.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            defaultConstructor.getBody().addStatement((Statement)createComponent);
            defaultConstructor.getBody().addStatement((Statement)addComponent);
        }
        return mods;
    }

    private static String indent(int amount, String string) {
        String indent = " ".repeat(amount);
        return Pattern.compile("^", 8).matcher(string).replaceAll(indent);
    }

    private List<Modification> addListener(CompilationUnit cu, int componentCreateLineNumber, int componentAttachLineNumber, String listenerType) {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        Statement createStatement = this.findStatement(cu, componentCreateLineNumber);
        SimpleName referenceLocalVariableOrField = this.findLocalVariableOrField(cu, componentCreateLineNumber);
        Parameter param = new Parameter();
        param.setName("e");
        LambdaExpr emptyCallback = new LambdaExpr(param, new BlockStmt(new NodeList()));
        MethodCallExpr listener = new MethodCallExpr((Expression)new NameExpr(referenceLocalVariableOrField), listenerType, new NodeList((Node[])new Expression[]{emptyCallback}));
        Node listenerNode = new ExpressionStmt((Expression)listener).setComment((Comment)new LineComment(" TODO: Implement listener"));
        Node parent = (Node)createStatement.getParentNode().orElseThrow();
        if (parent instanceof BlockStmt) {
            List<MethodCallExpr> methodCalls = this.findMethodCalls((BlockStmt)parent, referenceLocalVariableOrField);
            if (methodCalls.isEmpty()) {
                mods.add(Modification.insertLineAfter((Node)createStatement, listenerNode));
            } else {
                mods.add(Modification.insertLineAfter((Node)methodCalls.get(methodCalls.size() - 1).getParentNode().orElseThrow(), listenerNode));
            }
        } else {
            mods.add(Modification.insertAfter((Node)createStatement, listenerNode));
        }
        return mods;
    }

    private String addNewLineToBody(String body) {
        int endOfBody = body.lastIndexOf("}");
        return body.substring(0, endOfBody) + "\n" + body.substring(endOfBody);
    }

    protected List<MethodCallExpr> findMethodCalls(BlockStmt parent, SimpleName variableName) {
        ArrayList<MethodCallExpr> methodCalls = new ArrayList<MethodCallExpr>();
        for (Statement s : parent.getStatements()) {
            Expression scope;
            MethodCallExpr methodCall;
            ExpressionStmt expr;
            if (!s.isExpressionStmt() || !(expr = s.asExpressionStmt()).getExpression().isMethodCallExpr() || !(methodCall = expr.getExpression().asMethodCallExpr()).getScope().isPresent() || !(scope = (Expression)methodCall.getScope().orElseThrow()).isNameExpr() || !scope.asNameExpr().getName().equals((Object)variableName)) continue;
            methodCalls.add(methodCall);
        }
        return methodCalls;
    }

    private ExpressionStmt addToLayout(String variableName) {
        return new ExpressionStmt((Expression)new MethodCallExpr("add", new Expression[]{new NameExpr(variableName)}));
    }

    private String getVariableName(ComponentType type, String[] constructorArguments) {
        if (constructorArguments.length == 1) {
            return SharedUtil.firstToLower((String)SharedUtil.dashSeparatedToCamelCase((String)constructorArguments[0].replaceAll(" ", "-")));
        }
        String simpleName = type.getClassName();
        simpleName = simpleName.substring(simpleName.lastIndexOf(46));
        return simpleName;
    }

    private ClassOrInterfaceDeclaration findClassDefinition(CompilationUnit cu, int lineNumber) {
        for (TypeDeclaration type : cu.getTypes()) {
            if (!this.contains((Node)type.getName(), lineNumber)) continue;
            return type.asClassOrInterfaceDeclaration();
        }
        return null;
    }

    private ConstructorDeclaration findConstructorDeclaration(CompilationUnit cu, int lineNumber) {
        for (TypeDeclaration type : cu.getTypes()) {
            if (!this.contains((Node)type, lineNumber)) continue;
            return this.findConstructorDeclaration(type, lineNumber);
        }
        return null;
    }

    private ConstructorDeclaration findConstructorDeclaration(TypeDeclaration<?> type, int lineNumber) {
        for (ConstructorDeclaration constructor : type.getConstructors()) {
            if (!this.contains((Node)constructor, lineNumber)) continue;
            return constructor;
        }
        return null;
    }

    private ObjectCreationExpr getConstructorCode(ComponentType componentType, String[] constructorArguments) {
        ClassOrInterfaceType type = this.getType(componentType);
        List componentConstructorArgs = Arrays.stream(constructorArguments).map(arg -> new StringLiteralExpr(arg)).collect(Collectors.toList());
        return new ObjectCreationExpr(null, type, new NodeList(componentConstructorArgs));
    }

    private ClassOrInterfaceType getType(ComponentType componentType) {
        ClassOrInterfaceType type = StaticJavaParser.parseClassOrInterfaceType((String)componentType.getClassName());
        type.setScope(null);
        return type;
    }

    private void addOrReplaceCall(BlockStmt codeBlock, Node afterThisNode, SimpleName variableName, String methodName, Expression methodArgument, List<Modification> mods) {
        NodeList arguments = new NodeList();
        arguments.add((Node)methodArgument);
        ExpressionStmt setTextCall = new ExpressionStmt((Expression)new MethodCallExpr((Expression)new NameExpr(variableName), methodName, arguments));
        ExpressionStmt existingCall = this.findMethodCall(codeBlock, afterThisNode, variableName, methodName);
        if (existingCall != null) {
            Modification mod = Modification.replace((Node)existingCall, (Node)setTextCall);
            mods.add(mod);
        } else {
            Modification mod = Modification.insertLineAfter(afterThisNode, (Node)setTextCall);
            mods.add(mod);
        }
    }

    private void removeCall(BlockStmt codeBlock, Node afterThisNode, SimpleName variableName, String methodName, Expression methodArgument, List<Modification> mods) {
        NodeList arguments = new NodeList();
        arguments.add((Node)methodArgument);
        ExpressionStmt setTextCall = new ExpressionStmt((Expression)new MethodCallExpr((Expression)new NameExpr(variableName), methodName, arguments));
        ExpressionStmt existingCall = this.findMethodCall(codeBlock, afterThisNode, variableName, methodName);
        if (existingCall != null) {
            Modification mod = Modification.remove((Node)existingCall);
            mods.add(mod);
        }
    }

    private void addCall(Node afterThisNode, SimpleName variableName, String methodName, Expression methodArgument, List<Modification> mods) {
        NodeList arguments = new NodeList();
        arguments.add((Node)methodArgument);
        ExpressionStmt setTextCall = new ExpressionStmt((Expression)new MethodCallExpr((Expression)new NameExpr(variableName), methodName, arguments));
        Modification mod = Modification.insertLineAfter(afterThisNode, (Node)setTextCall);
        mods.add(mod);
    }

    private boolean modifyConstructorCall(ObjectCreationExpr constructorCall, String methodName, String newText, List<Modification> mods) {
        StringLiteralExpr param;
        if (methodName.equals("setText") && (param = this.findConstructorParameter(constructorCall, ComponentType.BUTTON, 0)) != null) {
            Modification mod = Modification.replace((Node)param, (Node)new StringLiteralExpr(newText));
            mods.add(mod);
            return true;
        }
        if (methodName.equals("setLabel") && (param = this.findConstructorParameter(constructorCall, ComponentType.TEXTFIELD, 0)) != null) {
            Modification mod = Modification.replace((Node)param, (Node)new StringLiteralExpr(newText));
            mods.add(mod);
            return true;
        }
        return false;
    }

    private StringLiteralExpr findConstructorParameter(ObjectCreationExpr objectCreationExpression, ComponentType type, int parameterIndex) {
        Expression param;
        if (this.isConstructorFor(objectCreationExpression, type) && objectCreationExpression.getArguments().size() == 1 && objectCreationExpression.getArguments().size() >= parameterIndex - 1 && (param = objectCreationExpression.getArgument(parameterIndex)).isStringLiteralExpr()) {
            return param.asStringLiteralExpr();
        }
        return null;
    }

    private boolean isConstructorFor(ObjectCreationExpr objectCreationExpression, ComponentType type) {
        String constructorType = objectCreationExpression.getType().getName().asString();
        return constructorType.equals(type.getClassName()) || constructorType.equals(this.getSimpleName(type));
    }

    private String getSimpleName(ComponentType type) {
        String className = type.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static int getLinesCount(Node node) {
        int nodeLines = node.getRange().map(r -> r.getLineCount()).orElseGet(() -> node.toString().split("\n").length);
        if (node.getComment().isPresent()) {
            Comment comment = (Comment)node.getComment().orElseThrow();
            nodeLines += comment.getRange().map(Range::getLineCount).orElse(0).intValue();
        }
        return nodeLines;
    }

    protected ExpressionStmt findMethodCall(BlockStmt codeBlock, Node afterThis, SimpleName leftHandSide, String string) {
        boolean refFound = false;
        for (Statement s : codeBlock.getStatements()) {
            Expression scope;
            MethodCallExpr methodCallExpr;
            Expression expression;
            if (s == afterThis) {
                refFound = true;
                continue;
            }
            if (!refFound || !s.isExpressionStmt() || !(expression = s.asExpressionStmt().getExpression()).isMethodCallExpr() || !(methodCallExpr = expression.asMethodCallExpr()).getScope().isPresent() || !(scope = (Expression)methodCallExpr.getScope().orElseThrow()).isNameExpr()) continue;
            String variableName = scope.asNameExpr().getNameAsString();
            String methodName = methodCallExpr.getNameAsString();
            if (!string.equals(methodName) || !variableName.equals(leftHandSide.getIdentifier())) continue;
            return s.asExpressionStmt();
        }
        return null;
    }

    protected Statement findStatement(CompilationUnit cu, int lineNumber) {
        return (Statement)cu.accept((GenericVisitor)new StatementLineNumberVisitor(), (Object)lineNumber);
    }

    private boolean contains(Node node, int lineNumber) {
        return ((Position)node.getBegin().orElseThrow()).line <= lineNumber && ((Position)node.getEnd().orElseThrow()).line >= lineNumber;
    }

    private static void addStatement(Node referenceNode, Where where, Statement stmt) {
        Object var4_3 = referenceNode.getParentNode().orElse(null);
        if (var4_3 instanceof NodeWithStatements) {
            NodeWithStatements nws = var4_3;
            if (where == null) {
                nws.addStatement(stmt);
            } else {
                int index = nws.getStatements().indexOf((Object)referenceNode) + (Where.AFTER.equals((Object)where) ? 1 : 0);
                nws.addStatement(index, stmt);
            }
        }
    }

    protected String readFile(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            String string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public int addComponent(File f, int referenceComponentCreateLineNumber, int referenceComponentAttachLineNumber, Where where, ComponentType componentType, String ... constructorArguments) {
        return this.modifyClass(f, cu -> this.addComponent((CompilationUnit)cu, referenceComponentCreateLineNumber, referenceComponentAttachLineNumber, where, componentType, constructorArguments));
    }

    public int addListener(File f, int componentCreateLineNumber, int componentAttachLineNumber, String listenerType) {
        return this.modifyClass(f, cu -> this.addListener((CompilationUnit)cu, componentCreateLineNumber, componentAttachLineNumber, listenerType));
    }

    public int modifyClass(File f, Function<CompilationUnit, List<Modification>> modifier) {
        try {
            String source = this.readFile(f);
            CompilationUnit cu = this.parseSource(source);
            List<Modification> mods = modifier.apply(cu);
            Collections.sort(mods);
            int sourceOffset = 0;
            for (Modification mod : mods) {
                mod.apply();
                sourceOffset += mod.sourceOffset();
            }
            String newSource = LexicalPreservingPrinter.print((Node)cu);
            if (newSource.equals(source)) {
                throw new UnsupportedOperationException("Unable to edit file");
            }
            try (FileWriter fw = new FileWriter(f);){
                fw.write(newSource);
            }
            return sourceOffset;
        }
        catch (IOException e1) {
            throw new UnsupportedOperationException(e1);
        }
    }

    public int setComponentAttribute(String className, int componentCreateLineNumber, int componentAttachLineNumber, ComponentType componentType, String methodName, String methodParam) {
        return this.setComponentAttribute(this.getSourceFile(className), componentCreateLineNumber, componentAttachLineNumber, componentType, methodName, methodParam);
    }

    public int setComponentAttribute(File f, int componentCreateLineNumber, int componentAttachLineNumber, ComponentType componentType, String methodName, String methodParam) {
        return this.modifyClass(f, cu -> this.modifyOrAddCall((CompilationUnit)cu, componentCreateLineNumber, componentAttachLineNumber, componentType, methodName, methodParam));
    }

    public int addComponentAttribute(File f, int componentCreateLineNumber, int componentAttachLineNumber, ComponentType componentType, String methodName, String methodParam) {
        return this.modifyClass(f, cu -> this.addCall((CompilationUnit)cu, componentCreateLineNumber, componentAttachLineNumber, componentType, methodName, methodParam));
    }

    public int removeComponentAttribute(File f, int componentCreateLineNumber, int componentAttachLineNumber, ComponentType componentType, String methodName, String methodParam) {
        return this.modifyClass(f, cu -> this.removeCall((CompilationUnit)cu, componentCreateLineNumber, componentAttachLineNumber, componentType, methodName, methodParam));
    }

    protected CompilationUnit parseSource(String source) {
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        StaticJavaParser.setConfiguration((ParserConfiguration)parserConfiguration);
        return (CompilationUnit)LexicalPreservingPrinter.setup((Node)StaticJavaParser.parse((String)source));
    }

    public File getSourceFile(Class<?> cls) {
        return this.getSourceFile(cls.getName());
    }

    public File getSourceFile(String className) {
        String classFileName = className.replace(".", File.separator) + ".java";
        File src = new File("").getAbsoluteFile();
        src = new File(src, "src");
        File f = new File(src, "main");
        f = new File(f, "java");
        if ((f = new File(f, classFileName)).exists()) {
            return f;
        }
        f = new File(src, "test");
        f = new File(f, "java");
        f = new File(f, classFileName);
        return f;
    }

    public static class Modification
    implements Comparable<Modification> {
        private Node referenceNode;
        private Type type;
        private Node node;
        private int sourceOffset;

        public void apply() {
            if (this.type == Type.IMPORT) {
                Node node = this.referenceNode;
                if (node instanceof CompilationUnit) {
                    CompilationUnit cu = (CompilationUnit)node;
                    node = this.node;
                    if (node instanceof ImportDeclaration) {
                        ImportDeclaration id = (ImportDeclaration)node;
                        cu.getImports().add((Node)id);
                    }
                }
            } else if (this.type == Type.INSERT_LINE_AFTER) {
                Node id = this.node;
                if (id instanceof Statement) {
                    Statement stmt = (Statement)id;
                    Editor.addStatement(this.referenceNode, Where.AFTER, stmt);
                }
            } else if (this.type == Type.INSERT_AFTER) {
                Node parent = this.referenceNode.getParentNode().orElse(null);
                if (parent instanceof MethodCallExpr) {
                    MethodCallExpr mce = (MethodCallExpr)parent;
                    mce.getArguments().addAfter((Node)((Expression)this.node), (Node)((Expression)this.referenceNode));
                }
            } else if (this.type == Type.INSERT_LINE_BEFORE) {
                Node mce = this.node;
                if (mce instanceof Statement) {
                    Statement stmt = (Statement)mce;
                    Editor.addStatement(this.referenceNode, Where.BEFORE, stmt);
                }
            } else if (this.type == Type.INSERT_BEFORE) {
                Node parent = this.referenceNode.getParentNode().orElse(null);
                if (parent instanceof MethodCallExpr) {
                    MethodCallExpr mce = (MethodCallExpr)parent;
                    mce.getArguments().addBefore((Node)((Expression)this.node), (Node)((Expression)this.referenceNode));
                }
            } else if (this.type == Type.REPLACE) {
                this.referenceNode.getComment().ifPresent(Node::remove);
                this.referenceNode.replace(this.node);
            } else if (this.type == Type.INSERT_AT_END_OF_BLOCK) {
                Node mce = this.node;
                if (mce instanceof Statement) {
                    Statement stmt = (Statement)mce;
                    Node node = this.referenceNode;
                    if (node instanceof NodeWithStatements) {
                        NodeWithStatements block = (NodeWithStatements)node;
                        block.addStatement(stmt);
                    } else {
                        node = this.referenceNode;
                        if (node instanceof NodeWithBlockStmt) {
                            NodeWithBlockStmt block = (NodeWithBlockStmt)node;
                            block.getBody().addStatement(stmt);
                        }
                    }
                }
            } else if (this.type == Type.REMOVE_NODE) {
                this.referenceNode.getComment().ifPresent(Node::remove);
                this.referenceNode.remove();
            } else {
                throw new RuntimeException("Failed to perform: " + String.valueOf(this));
            }
        }

        public int sourceOffset() {
            return this.sourceOffset;
        }

        public static Modification addImport(Node referenceNode, Node node) {
            Modification mod = new Modification();
            mod.referenceNode = referenceNode;
            mod.type = Type.IMPORT;
            mod.node = node;
            mod.sourceOffset = Editor.getLinesCount(node);
            return mod;
        }

        public static Modification insertAfter(Node referenceNode, Node node) {
            Modification mod = new Modification();
            mod.referenceNode = referenceNode;
            mod.type = Type.INSERT_AFTER;
            mod.node = node;
            mod.sourceOffset = 0;
            return mod;
        }

        public static Modification insertAtEndOfBlock(Node referenceNode, Node node) {
            Modification mod = new Modification();
            mod.referenceNode = referenceNode;
            mod.type = Type.INSERT_AT_END_OF_BLOCK;
            mod.node = node;
            mod.sourceOffset = Editor.getLinesCount(node);
            return mod;
        }

        public static Modification insertBefore(Node referenceNode, Node node) {
            Modification mod = new Modification();
            mod.referenceNode = referenceNode;
            mod.type = Type.INSERT_BEFORE;
            mod.node = node;
            mod.sourceOffset = 0;
            return mod;
        }

        public static Modification insertLineBefore(Node referenceNode, Node node) {
            Modification mod = new Modification();
            mod.referenceNode = referenceNode;
            mod.type = Type.INSERT_LINE_BEFORE;
            mod.node = node;
            mod.sourceOffset = Editor.getLinesCount(node);
            return mod;
        }

        public static Modification insertLineAfter(Node referenceNode, Node node) {
            Modification mod = new Modification();
            mod.referenceNode = referenceNode;
            mod.type = Type.INSERT_LINE_AFTER;
            mod.node = node;
            mod.sourceOffset = Editor.getLinesCount(node);
            return mod;
        }

        public static Modification replace(Node referenceNode, Node node) {
            Modification mod = new Modification();
            mod.referenceNode = referenceNode;
            mod.type = Type.REPLACE;
            mod.node = node;
            mod.sourceOffset = Editor.getLinesCount(node) - Editor.getLinesCount(referenceNode);
            return mod;
        }

        public static Modification remove(Node referenceNode) {
            Modification mod = new Modification();
            mod.referenceNode = referenceNode;
            mod.type = Type.REMOVE_NODE;
            mod.sourceOffset = -Editor.getLinesCount(referenceNode);
            return mod;
        }

        @Override
        public int compareTo(Modification o) {
            Position aBegin = ((Range)this.referenceNode.getRange().orElseThrow()).begin;
            int a = aBegin.line;
            Position bBegin = ((Range)o.referenceNode.getRange().orElseThrow()).begin;
            int b = bBegin.line;
            if (a == b) {
                return Integer.compare(bBegin.column, aBegin.column);
            }
            return Integer.compare(b, a);
        }

        public String toString() {
            if (this.type == Type.INSERT_LINE_AFTER) {
                return "Modification INSERT_LINE_AFTER at position " + String.valueOf(this.referenceNode.getEnd().orElseThrow()) + ": " + String.valueOf(this.node);
            }
            if (this.type == Type.INSERT_AFTER) {
                return "Modification INSERT_AFTER at position " + String.valueOf(this.referenceNode.getEnd().orElseThrow()) + ": " + String.valueOf(this.node);
            }
            if (this.type == Type.INSERT_BEFORE) {
                return "Modification INSERT_BEFORE at position " + String.valueOf(this.referenceNode.getBegin().orElseThrow()) + ": " + String.valueOf(this.node);
            }
            if (this.type == Type.REPLACE) {
                return "Modification REPLACE position " + String.valueOf(this.referenceNode.getBegin().orElseThrow()) + "-" + String.valueOf(this.referenceNode.getEnd().orElseThrow()) + ": " + String.valueOf(this.node);
            }
            if (this.type == Type.REMOVE_NODE) {
                return "Modification REMOVE position " + String.valueOf(this.referenceNode.getBegin().orElseThrow()) + "-" + String.valueOf(this.referenceNode.getEnd().orElseThrow()) + ": " + String.valueOf(this.referenceNode);
            }
            if (this.type == Type.INSERT_AT_END_OF_BLOCK) {
                return "Modification INSERT_AT_END_OF_BLOCK " + String.valueOf(this.referenceNode);
            }
            return "Modification UNKNOWN TYPE";
        }

        private static enum Type {
            IMPORT,
            INSERT_AFTER,
            INSERT_BEFORE,
            INSERT_LINE_AFTER,
            INSERT_LINE_BEFORE,
            REPLACE,
            INSERT_AT_END_OF_BLOCK,
            REMOVE_NODE;

        }
    }
}

