/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.info;

import com.vaadin.copilot.CopilotVersion;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopilotInfo
implements Serializable {
    private final List<NameAndVersion> versions = new ArrayList<NameAndVersion>();
    private final JdkInfo jdkInfo;

    public CopilotInfo(ApplicationConfiguration applicationConfiguration) {
        if (EndpointRequestUtil.isHillaAvailable()) {
            this.versions.add(new NameAndVersion("Hilla", CopilotInfo.fetchHillaVersion()));
        }
        this.versions.add(new NameAndVersion("Flow", Version.getFullVersion()));
        if (CopilotInfo.isVaadinAvailable()) {
            this.versions.add(new NameAndVersion("Vaadin", CopilotInfo.fetchVaadinVersion()));
        }
        this.versions.add(new NameAndVersion("Copilot", CopilotVersion.getVersion()));
        this.versions.add(new NameAndVersion("Copilot IDE Plugin", ""));
        this.versions.add(new NameAndVersion("Java", CopilotInfo.fetchJavaVersion()));
        this.versions.add(new NameAndVersion("Java Hotswap", ""));
        String frontendHotswap = applicationConfiguration.getMode() == Mode.DEVELOPMENT_FRONTEND_LIVERELOAD ? "Enabled, using Vite" : "Disabled, using pre-built bundle";
        this.versions.add(new NameAndVersion("Frontend Hotswap", frontendHotswap));
        this.versions.add(new NameAndVersion("OS", CopilotInfo.fetchOperatingSystem()));
        this.jdkInfo = this.determineJdkInfo();
    }

    private JdkInfo determineJdkInfo() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        boolean jrebel = System.getProperty("rebel.base") != null;
        boolean extendedClassDefCapable = runtimeMXBean.getVmVendor().contains("JetBrains");
        boolean runningWithExtendClassDef = inputArguments.contains("-XX:+AllowEnhancedClassRedefinition");
        boolean runningWithHotswap = inputArguments.contains("-XX:HotswapAgent=fatjar");
        boolean runningInJavaDebugMode = inputArguments.toString().toLowerCase(Locale.ENGLISH).contains("jdwp");
        File javaHome = new File(System.getProperty("java.home"));
        File hotswapAgentLocation = new File(new File(new File(javaHome, "lib"), "hotswap"), "hotswap-agent.jar");
        boolean hotswapAgentFound = hotswapAgentLocation.exists();
        String hotswapVersionString = this.getHotswapAgentVersionString(hotswapAgentLocation).orElse(null);
        boolean hotswapVersionOk = this.checkHotswapAgentVersion(hotswapVersionString);
        return new JdkInfo(jrebel, extendedClassDefCapable, runningWithExtendClassDef, hotswapAgentFound, hotswapAgentLocation.getAbsolutePath(), runningWithHotswap, runningInJavaDebugMode, hotswapVersionString, hotswapVersionOk);
    }

    private Optional<String> getHotswapAgentVersionString(File hotswapAgentLocation) {
        if (hotswapAgentLocation.exists()) {
            Optional<String> optional;
            JarFile jarFile = new JarFile(hotswapAgentLocation);
            try {
                optional = Optional.ofNullable(jarFile.getManifest().getMainAttributes().getValue("Implementation-Version"));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.getLogger().error("No META-INF/MANIFEST.MF found in {}", (Object)hotswapAgentLocation, (Object)e);
                }
            }
            jarFile.close();
            return optional;
        }
        return Optional.empty();
    }

    private boolean checkHotswapAgentVersion(String hotswapVersionString) {
        return this.getHotswapAgentVersion(hotswapVersionString).map(frontendVersion -> frontendVersion.isEqualOrNewer(new FrontendVersion(1, 4, 2))).orElse(false);
    }

    private Optional<FrontendVersion> getHotswapAgentVersion(String versionString) {
        if (versionString == null) {
            return Optional.empty();
        }
        String withoutSnapshot = versionString.replace("-SNAPSHOT", "");
        return Optional.of(new FrontendVersion(withoutSnapshot));
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public static String fetchJavaVersion() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return vendor + " " + version;
    }

    public static String fetchOperatingSystem() {
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return arch + " " + name + " " + version;
    }

    public static String fetchVaadinVersion() {
        return CopilotInfo.isVaadinAvailable() ? Platform.getVaadinVersion().orElse("?") : "-";
    }

    public static String fetchHillaVersion() {
        return EndpointRequestUtil.isHillaAvailable() ? Platform.getHillaVersion().orElse("?") : "-";
    }

    public List<NameAndVersion> getVersions() {
        return this.versions;
    }

    public JdkInfo getJdkInfo() {
        return this.jdkInfo;
    }

    private static boolean isVaadinAvailable() {
        return Thread.currentThread().getContextClassLoader().getResource("META-INF/maven/com.vaadin/vaadin-core/pom.properties") != null;
    }

    public record NameAndVersion(String name, String version) implements Serializable
    {
    }

    public record JdkInfo(boolean jrebel, boolean extendedClassDefCapable, boolean runningWithExtendClassDef, boolean hotswapAgentFound, String hotswapAgentLocation, boolean runningWitHotswap, boolean runningInJavaDebugMode, String hotswapVersion, boolean hotswapVersionOk) {
    }
}

