/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotVersion;
import com.vaadin.copilot.userinfo.UserInfo;
import com.vaadin.copilot.userinfo.UserInfoServerClient;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.VaadinComIntegration;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInfoHandler
implements CopilotCommand {
    public static final String PRODUCT_VAADIN_COPILOT = "vaadin-copilot";
    public static final int LOGIN_TIMEOUT_SECONDS = 900;
    private final VaadinContext context;
    private final UserInfoServerClient client = new UserInfoServerClient();

    public UserInfoHandler(VaadinContext context) {
        this.context = context;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, final DevToolsInterface devToolsInterface) {
        if (command.equals("get-user-info")) {
            ProKey proKey = LocalProKey.get();
            JsonObject userInfo = Json.createObject();
            if (proKey != null) {
                UserInfo info = this.client.getUserInfo(proKey.getProKey());
                userInfo.put("validLicense", this.hasValidLicense());
                userInfo.put("vaadiner", info != null && info.vaadiner());
            }
            userInfo.put("reqId", data.getString("reqId"));
            userInfo.put("flowFeatureFlag", FeatureFlags.get((VaadinContext)this.context).isEnabled(FeatureFlags.COPILOT_FLOW));
            userInfo.put("copilotI18nFeatureFlag", FeatureFlags.get((VaadinContext)this.context).isEnabled(FeatureFlags.COPILOT_I18N));
            userInfo.put("copilotExperimentalFeatureFlag", FeatureFlags.get((VaadinContext)this.context).isEnabled(FeatureFlags.COPILOT_EXPERIMENTAL));
            devToolsInterface.send("copilot-user-info", userInfo);
            return true;
        }
        if (command.equals("log-in")) {
            ProKey proKey = LocalProKey.get();
            JsonObject response = Json.createObject();
            response.put("reqId", data.getString("reqId"));
            if (proKey == null) {
                LicenseChecker.checkLicenseAsync((String)PRODUCT_VAADIN_COPILOT, (String)CopilotVersion.getVersion(), (BuildType)BuildType.DEVELOPMENT, (LicenseChecker.Callback)new LicenseChecker.Callback(){

                    public void ok() {
                        devToolsInterface.send("copilot-prokey-received", Json.createObject());
                    }

                    public void failed(Exception e) {
                        UserInfoHandler.this.getLogger().error("Unable to fetch pro key", (Throwable)e);
                    }
                }, loginUrl -> {
                    response.put("loginUrl", loginUrl);
                    response.put("reason", "no-pro-key");
                    devToolsInterface.send("log-in-resp", response);
                }, (int)900);
            } else {
                response.put("loginUrl", VaadinComIntegration.constructUrl(null, (Product)new Product(PRODUCT_VAADIN_COPILOT, CopilotVersion.getVersion())));
                response.put("reason", "no-subscription");
                devToolsInterface.send("log-in-resp", response);
            }
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private boolean hasValidLicense() {
        try {
            LicenseChecker.checkLicense((String)PRODUCT_VAADIN_COPILOT, (String)CopilotVersion.getVersion(), (BuildType)BuildType.DEVELOPMENT, null);
            return true;
        }
        catch (LicenseException e) {
            if (!this.ignoreWhenDoingBackgroundCheck(e)) {
                this.getLogger().error("Problem checking the subscription status", (Throwable)e);
            }
            return false;
        }
    }

    private boolean ignoreWhenDoingBackgroundCheck(LicenseException e) {
        String msg = e.getMessage();
        if (msg.contains("The provided license key does not allow usage")) {
            return true;
        }
        return msg.contains("could not be reached and no offline key was found");
    }
}

