/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.routes.AccessRequirement;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.flow.shared.util.SharedUtil;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteCreator {
    private final ProjectManager projectManager;

    public RouteCreator(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(RouteCreator.class);
    }

    public void createFlowView(String route, AccessRequirement accessRequirement) throws IOException {
        RouteCreator.getLogger().debug("Creating Flow view for route {}", (Object)route);
        String[] parts = route.split("/");
        String filename = parts[parts.length - 1];
        filename = filename.isEmpty() || filename.endsWith("/") ? "Main" : SharedUtil.capitalize((String)filename);
        if (!this.projectManager.sanitizeFilename(filename).equals(filename)) {
            throw new IllegalArgumentException("Invalid filename " + filename);
        }
        String viewsPackage = this.projectManager.getFlowViewsPackage();
        File viewFile = this.projectManager.getJavaSourceFolder();
        for (String folder : viewsPackage.split("\\.")) {
            viewFile = new File(viewFile, folder);
        }
        String className = filename;
        if ((viewFile = new File(viewFile, filename + ".java")).exists()) {
            throw new IllegalArgumentException("File already exists: " + viewFile.getAbsolutePath());
        }
        viewFile.getParentFile().mkdirs();
        this.projectManager.writeFile(viewFile, CopilotIDEPlugin.undoLabel("Add route"), this.getFlowRouteTemplate(viewsPackage, route, className, accessRequirement));
    }

    public void createHillaView(String route, AccessRequirement accessRequirement) throws IOException {
        String[] parts;
        RouteCreator.getLogger().debug("Creating Hilla view for route {}", (Object)route);
        Object filename = route;
        if (((String)filename).isEmpty() || ((String)filename).endsWith("/")) {
            filename = (String)filename + "@index";
        }
        if (!this.projectManager.sanitizeFilename((String)filename).equals(filename)) {
            throw new IllegalArgumentException("Invalid filename " + (String)filename);
        }
        File viewFile = this.projectManager.getHillaViewsFolder();
        for (String part : parts = ((String)filename).split("/")) {
            viewFile = new File(viewFile, part);
        }
        if ((viewFile = RouteCreator.addExtension(viewFile, ".tsx")).exists()) {
            throw new IllegalArgumentException("File already exists: " + viewFile.getAbsolutePath());
        }
        viewFile.getParentFile().mkdirs();
        this.projectManager.writeFile(viewFile, CopilotIDEPlugin.undoLabel("Add route"), this.getHillaRouteTemplate(parts[parts.length - 1], accessRequirement));
    }

    private String getHillaRouteTemplate(String routeName, AccessRequirement accessRequirement) {
        String functionName = SharedUtil.capitalize((String)routeName) + "View";
        if (functionName.matches("^[^A-Z].*")) {
            functionName = "A" + functionName;
        }
        return "import type { ViewConfig } from '@vaadin/hilla-file-router/types.js';\n\nexport const config: ViewConfig = {\n  title: 'TITLE',\n  ACCESS_CONTROL\n};\n\nexport default function FUNCTION_NAME() {\n    return (\n        <div>\n            <h1>ROUTE_NAME</h1>\n        </div>\n    );\n}\n".replace("TITLE", routeName).replace("FUNCTION_NAME", functionName).replace("ROUTE_NAME", routeName).replace("ACCESS_CONTROL", (CharSequence)(switch (accessRequirement.getType()) {
            case AccessRequirement.Type.PERMIT_ALL -> "loginRequired: true,";
            case AccessRequirement.Type.ANONYMOUS_ALLOWED -> "";
            case AccessRequirement.Type.DENY_ALL -> "rolesAllowed: [],";
            case AccessRequirement.Type.ROLES_ALLOWED -> "rolesAllowed: [" + Arrays.stream(accessRequirement.getRoles()).map(role -> "\"" + role + "\"").collect(Collectors.joining(", ")) + "],";
            default -> throw new IllegalArgumentException("Unknown access requirement: " + String.valueOf((Object)accessRequirement.getType()));
        }));
    }

    private String getFlowRouteTemplate(String packageName, String route, String className, AccessRequirement accessRequirement) {
        Class<PermitAll> accessClass;
        String accessParam = null;
        switch (accessRequirement.getType()) {
            case PERMIT_ALL: {
                accessClass = PermitAll.class;
                break;
            }
            case ANONYMOUS_ALLOWED: {
                accessClass = AnonymousAllowed.class;
                break;
            }
            case DENY_ALL: {
                accessClass = DenyAll.class;
                break;
            }
            case ROLES_ALLOWED: {
                accessClass = RolesAllowed.class;
                accessParam = "{" + Arrays.stream(accessRequirement.getRoles()).map(role -> "\"" + role + "\"").collect(Collectors.joining(", ")) + "}";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown access requirement: " + String.valueOf((Object)accessRequirement.getType()));
            }
        }
        Object accessAnnotation = accessClass.getSimpleName();
        if (accessParam != null) {
            accessAnnotation = (String)accessAnnotation + "(" + accessParam + ")";
        }
        return "package VIEW_PACKAGE;\n\nimport com.vaadin.flow.component.html.H1;\nimport com.vaadin.flow.component.orderedlayout.HorizontalLayout;\nimport com.vaadin.flow.router.Route;\nimport com.vaadin.flow.server.auth.AnonymousAllowed;\nimport ACCESS_CLASS_NAME;\n\n@Route(value = \"ROUTE\")\n@ACCESS_ANNOTATION\npublic class CLASS_NAME extends HorizontalLayout {\n\n    public CLASS_NAME() {\n        add(new H1(\"This is CLASS_NAME\"));\n    }\n\n}\n".replace("VIEW_PACKAGE", packageName).replace("ROUTE", route).replace("ACCESS_CLASS_NAME", accessClass.getName()).replace("CLASS_NAME", className).replace("ACCESS_ANNOTATION", (CharSequence)accessAnnotation);
    }

    private static File addExtension(File viewFile, String ext) {
        return new File(viewFile.getParentFile(), viewFile.getName() + ext);
    }
}

