/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.ThemeUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class ProjectManager {
    private final Path projectRoot;
    private final Path javaSourceFolder;
    private final ApplicationConfiguration applicationConfiguration;
    private final CopilotIDEPlugin idePlugin;

    public ProjectManager(ApplicationConfiguration applicationConfiguration) throws IOException {
        this.projectRoot = applicationConfiguration.getProjectFolder().toPath().toRealPath(new LinkOption[0]);
        this.javaSourceFolder = applicationConfiguration.getJavaSourceFolder().toPath();
        this.applicationConfiguration = applicationConfiguration;
        this.idePlugin = CopilotIDEPlugin.getInstance();
    }

    public String readFile(String filename) throws IOException {
        return this.readFile(new File(filename));
    }

    public String readFile(File file) throws IOException {
        if (this.isFileInsideProject(file)) {
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("File " + file.getPath() + " is not inside the project at " + String.valueOf(this.projectRoot));
    }

    public List<String> readLines(File file) throws IOException {
        if (!this.isFileInsideProject(file)) {
            throw new IllegalArgumentException("File " + file.getPath() + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        return FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
    }

    boolean isFileInsideProject(File file) throws IOException {
        if (file.exists()) {
            Path path = file.toPath();
            return path.toRealPath(new LinkOption[0]).startsWith(this.projectRoot);
        }
        return this.isFileInsideProject(file.getParentFile());
    }

    public void writeFile(String filename, String undoLabel, String content) throws IOException {
        this.writeFile(new File(filename), undoLabel, content);
    }

    public void writeFile(File file, String undoLabel, String content) throws IOException {
        if (this.isFileInsideProject(file)) {
            File folder = file.getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Unable to create folder " + folder.getAbsolutePath());
            }
            if (this.idePlugin.isActive()) {
                this.idePlugin.writeFile(file, undoLabel, content);
                return;
            }
            boolean shouldWrite = true;
            if (file.exists()) {
                String currentContent = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                boolean bl = shouldWrite = !content.equals(currentContent);
            }
            if (shouldWrite) {
                FileUtils.write((File)file, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
            }
        } else {
            throw new IllegalArgumentException("File " + file.getPath() + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
    }

    public String makeAbsolute(String projectRelativeFilename) throws IOException {
        Path resolved = this.projectRoot.resolve(projectRelativeFilename).toRealPath(new LinkOption[0]);
        if (!resolved.startsWith(this.projectRoot)) {
            throw new IllegalArgumentException("File " + projectRelativeFilename + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        return resolved.toString();
    }

    public String makeRelative(String filename) throws IOException {
        Path absolutePath = new File(filename).toPath().toRealPath(new LinkOption[0]);
        if (!absolutePath.startsWith(this.projectRoot)) {
            throw new IllegalArgumentException("File " + filename + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        return this.projectRoot.relativize(absolutePath).toString();
    }

    public String getRelativeName(File projectFile) {
        String relativeFilename = projectFile.getAbsolutePath().substring(this.projectRoot.toFile().getAbsolutePath().length() + 1);
        while (relativeFilename.startsWith("./") || relativeFilename.startsWith(".\\")) {
            relativeFilename = relativeFilename.substring(2);
        }
        return relativeFilename;
    }

    public File getFileForClass(Class<?> cls) {
        return this.getFileForClass(cls.getName());
    }

    public File getFileForClass(String cls) {
        if (cls.contains("$")) {
            cls = cls.substring(0, cls.indexOf("$"));
        }
        String javaFilename = cls.replace(".", File.separator) + ".java";
        return new File(this.javaSourceFolder.toFile(), javaFilename);
    }

    public File getSourceFile(ComponentTracker.Location location) {
        return this.getFileForClass(location.className());
    }

    public File getJavaSourceFolder() {
        return this.javaSourceFolder.toFile();
    }

    public File getProjectRoot() {
        return this.projectRoot.toFile();
    }

    public File getFrontendFolder() {
        return FrontendUtils.getProjectFrontendDir((AbstractConfiguration)this.applicationConfiguration);
    }

    public Optional<String> getThemeName() {
        return ThemeUtils.getThemeName((VaadinContext)this.applicationConfiguration.getContext());
    }

    public Optional<File> getThemeFolder() {
        return this.getThemeName().map(t -> ThemeUtils.getThemeFolder((File)this.getFrontendFolder(), (String)t));
    }
}

