/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotServerRequest;
import com.vaadin.copilot.CopilotServerResponse;
import com.vaadin.copilot.CopilotServerResponseCode;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AICommandHandler
implements CopilotCommand {
    private static final String MESSAGE_PROMPT_FAILED = "prompt-failed";
    private static final String MESSAGE_PROMPT_OK = "prompt-ok";
    public static final String SERVER_URL_ENV = "copilot.serverBaseUrl";
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private Map<String, String> metadata;
    private final ProjectManager projectManager;

    public AICommandHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
        this.objectMapper = new ObjectMapper();
        this.metadata = new HashMap<String, String>();
        ServerInfo serverInfo = new ServerInfo();
        this.metadata = serverInfo.getVersions().stream().collect(Collectors.toMap(ServerInfo.NameAndVersion::name, ServerInfo.NameAndVersion::version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("prompt-text")) {
            String prompt = data.getString("text");
            HashMap<String, String> sources = new HashMap<String, String>();
            JsonObject reactSources = data.getObject("sources");
            if (reactSources != null) {
                for (String filename : reactSources.keys()) {
                    this.getLogger().debug("Hilla file: {}", (Object)filename);
                    sources.put(filename, reactSources.getString(filename));
                }
            }
            if (data.hasKey("uiid")) {
                Map<String, String> fileSourceMapJava;
                Double uiId = data.getNumber("uiid");
                VaadinSession session = VaadinSession.getCurrent();
                try {
                    session.lock();
                    fileSourceMapJava = this.getJavaSourceMap(uiId, session);
                }
                catch (IOException e) {
                    this.getLogger().error("Error reading requested project Flow Java files", (Throwable)e);
                    devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                    boolean bl = true;
                    return bl;
                }
                finally {
                    session.unlock();
                }
                sources.putAll(fileSourceMapJava);
            }
            String proKey = Optional.ofNullable(LocalProKey.get()).map(ProKey::getProKey).orElse(null);
            try {
                CopilotServerRequest req = new CopilotServerRequest(prompt, sources, this.metadata, proKey);
                this.queryCopilotServer(req, response -> {
                    try {
                        this.handleQueryResponse((CopilotServerResponse)response);
                        devToolsInterface.send("copilot-prompt-ok", Json.createObject());
                    }
                    catch (IOException e) {
                        this.getLogger().error("Error handling copilot server response", (Throwable)e);
                        devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                    }
                });
            }
            catch (Exception e) {
                this.getLogger().error("Error querying copilot server", (Throwable)e);
                devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                return true;
            }
            return true;
        }
        return false;
    }

    private Map<String, String> getJavaSourceMap(Number uiId, VaadinSession session) throws IOException {
        UI ui = session.getUIById(uiId.intValue());
        ArrayList<Component> componentList = new ArrayList<Component>();
        HashMap<String, String> sources = new HashMap<String, String>();
        this.addComponents((Component)ui, componentList);
        HashSet<ComponentTracker.Location> locations = new HashSet<ComponentTracker.Location>();
        for (Component component : componentList) {
            ComponentTracker.Location create = ComponentTracker.findCreate((Component)component);
            ComponentTracker.Location attach = ComponentTracker.findAttach((Component)component);
            if (create == null || attach == null) continue;
            locations.add(create);
            locations.add(attach);
        }
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)session.getService().getContext());
        for (ComponentTracker.Location location : locations) {
            File javaFile = location.findJavaFile((AbstractConfiguration)applicationConfiguration);
            if (sources.containsKey(location.filename())) continue;
            ArrayList<String> javaFileNames = new ArrayList<String>();
            if (javaFile.exists()) {
                javaFileNames.add(javaFile.getName());
                sources.put(javaFile.getAbsolutePath(), this.projectManager.readFile(javaFile.getPath()));
            }
            this.getLogger().debug("Java filenames: {}", javaFileNames);
        }
        return sources;
    }

    private void addComponents(Component component, List<Component> componentList) {
        componentList.add(component);
        component.getChildren().forEach(c -> this.addComponents((Component)c, componentList));
    }

    private void queryCopilotServer(CopilotServerRequest req, Consumer<CopilotServerResponse> responseHandler) {
        String json;
        URI queryUri;
        try {
            queryUri = new URI(this.getServerBaseUrl() + "query");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid server configuration, server uri is wrong", e);
        }
        try {
            json = this.objectMapper.writeValueAsString((Object)req);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid request", e);
        }
        if (AICommandHandler.isDevelopment()) {
            this.getLogger().info("Querying copilot server at {} using {}", (Object)queryUri, (Object)json);
        }
        HttpRequest request = HttpRequest.newBuilder().uri(queryUri).POST(HttpRequest.BodyPublishers.ofString(json)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(120L)).build();
        Consumer<String> responseParser = responseJson -> {
            try {
                this.getLogger().info("Response: {}", responseJson);
                CopilotServerResponse response = (CopilotServerResponse)this.objectMapper.readValue(responseJson, CopilotServerResponse.class);
                responseHandler.accept(response);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Unable to parse copilot server response", e);
            }
        };
        ((CompletableFuture)((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(responseParser)).join();
    }

    private String getServerBaseUrl() {
        String serverBaseUrl = System.getenv(SERVER_URL_ENV);
        if (serverBaseUrl != null) {
            return serverBaseUrl;
        }
        if (AICommandHandler.isDevelopment()) {
            try {
                String localhostUrl = "http://localhost:8081/v1/";
                String statusUrl = localhostUrl + "actuator/health";
                HttpRequest request = HttpRequest.newBuilder().uri(new URI(statusUrl)).timeout(Duration.ofSeconds(1L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    return localhostUrl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "https://copilot.stg.vaadin.com/v1/";
        }
        return "https://copilot.vaadin.com/v1/";
    }

    private static boolean isDevelopment() {
        return System.getProperty("copilot.development") != null;
    }

    private void handleQueryResponse(CopilotServerResponse response) throws IOException {
        if (response.code() == CopilotServerResponseCode.ERROR) {
            this.getLogger().error("Copilot server returned error because an internal error. The reason could be a malformed request or a timeout.");
            return;
        }
        if (response.code() == CopilotServerResponseCode.ERROR_REQUEST) {
            this.getLogger().error("Copilot server returned error because an internal error. The reason could be a malformed request or a timeout.");
            return;
        }
        if (response.code() == CopilotServerResponseCode.NOTHING) {
            this.getLogger().debug("Copilot server returned no changes");
            return;
        }
        if (response.code() == CopilotServerResponseCode.HILLA_REACT) {
            this.getLogger().debug("Copilot server returned Hilla/React changes");
        } else if (response.code() == CopilotServerResponseCode.FLOW) {
            this.getLogger().debug("Copilot server returned Flow changes");
        }
        for (Map.Entry<String, String> change : response.changes().entrySet()) {
            try {
                this.projectManager.writeFile(change.getKey(), change.getValue());
            }
            catch (IOException e) {
                throw new IOException("Unable to write file (" + change.getKey() + ") with data from copilot server response", e);
            }
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

